/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.async.api.MultiThreadedEventContext;
import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.locks.ClientServerExchangeLockContext;
import com.tc.object.locks.LockID;
import com.tc.object.locks.ServerLockLevel;
import com.tc.object.locks.ThreadID;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.session.SessionID;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class LockResponseMessage
extends DSOMessageBase
implements MultiThreadedEventContext {
    private static final ServerLockLevel[] SERVER_LOCK_LEVEL_VALUES = ServerLockLevel.values();
    private static final ResponseType[] RESPONSE_TYPE_VALUES = ResponseType.values();
    private static final byte TYPE = 1;
    private static final byte THREAD_ID = 2;
    private static final byte LOCK_ID = 3;
    private static final byte LOCK_LEVEL = 4;
    private static final byte CONTEXT = 5;
    private static final byte LOCK_LEASE_MILLIS = 6;
    private final Collection<ClientServerExchangeLockContext> contexts = new ArrayList<ClientServerExchangeLockContext>();
    private ResponseType responseType;
    private ThreadID threadID;
    private LockID lockID;
    private ServerLockLevel lockLevel;
    private int leaseTimeInMs;

    public LockResponseMessage(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
    }

    public LockResponseMessage(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
    }

    @Override
    protected void dehydrateValues() {
        this.putNVPair((byte)1, (byte)this.responseType.ordinal());
        switch (this.responseType) {
            case AWARD: 
            case REFUSE: 
            case RECALL: 
            case WAIT_TIMEOUT: {
                this.putNVPair((byte)3, this.lockID);
                this.putNVPair((byte)2, this.threadID.toLong());
                this.putNVPair((byte)4, (byte)this.lockLevel.ordinal());
                break;
            }
            case RECALL_WITH_TIMEOUT: {
                this.putNVPair((byte)3, this.lockID);
                this.putNVPair((byte)2, this.threadID.toLong());
                this.putNVPair((byte)4, (byte)this.lockLevel.ordinal());
                this.putNVPair((byte)6, this.leaseTimeInMs);
                break;
            }
            case INFO: {
                this.putNVPair((byte)3, this.lockID);
                this.putNVPair((byte)2, this.threadID.toLong());
                if (this.lockLevel != null) {
                    this.putNVPair((byte)4, (byte)this.lockLevel.ordinal());
                }
                for (ClientServerExchangeLockContext cselc : this.contexts) {
                    this.putNVPair((byte)5, cselc);
                }
                break;
            }
            default: {
                throw new AssertionError((Object)this.responseType);
            }
        }
    }

    @Override
    protected String describePayload() {
        StringBuffer rv = new StringBuffer();
        rv.append("Type : ").append((Object)this.responseType).append('\n');
        rv.append(this.lockID).append(' ').append(this.threadID).append(' ').append("Lock Type: ").append((Object)this.lockLevel).append('\n');
        return rv.toString();
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        switch (name) {
            case 1: {
                try {
                    this.responseType = RESPONSE_TYPE_VALUES[this.getByteValue()];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return false;
                }
                return true;
            }
            case 2: {
                this.threadID = new ThreadID(this.getLongValue());
                return true;
            }
            case 3: {
                this.lockID = this.getLockIDValue();
                return true;
            }
            case 4: {
                try {
                    this.lockLevel = SERVER_LOCK_LEVEL_VALUES[this.getByteValue()];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return false;
                }
                return true;
            }
            case 5: {
                this.contexts.add(this.getObject(new ClientServerExchangeLockContext()));
                return true;
            }
            case 6: {
                this.leaseTimeInMs = this.getIntValue();
                return true;
            }
        }
        return false;
    }

    public ResponseType getResponseType() {
        return this.responseType;
    }

    public int getAwardLeaseTime() {
        return this.leaseTimeInMs;
    }

    public LockID getLockID() {
        return this.lockID;
    }

    public ThreadID getThreadID() {
        return this.threadID;
    }

    public ServerLockLevel getLockLevel() {
        return this.lockLevel;
    }

    public void addContext(ClientServerExchangeLockContext ctxt) {
        this.contexts.add(ctxt);
    }

    public Collection<ClientServerExchangeLockContext> getContexts() {
        return this.contexts;
    }

    public void initializeAward(LockID lid, ThreadID sid, ServerLockLevel level) {
        this.initialize(ResponseType.AWARD, lid, sid, level, -1);
    }

    public void initializeRefuse(LockID lid, ThreadID sid, ServerLockLevel level) {
        this.initialize(ResponseType.REFUSE, lid, sid, level, -1);
    }

    public void initializeRecallWithTimeout(LockID lid, ThreadID sid, ServerLockLevel level, int leaseTimeInMillis) {
        this.initialize(ResponseType.RECALL_WITH_TIMEOUT, lid, sid, level, leaseTimeInMillis);
    }

    public void initializeRecall(LockID lid, ThreadID sid, ServerLockLevel level) {
        this.initialize(ResponseType.RECALL, lid, sid, level, -1);
    }

    public void initializeWaitTimeout(LockID lid, ThreadID sid, ServerLockLevel level) {
        this.initialize(ResponseType.WAIT_TIMEOUT, lid, sid, level, -1);
    }

    public void initializeLockInfo(LockID lid, ThreadID sid, ServerLockLevel level) {
        this.initialize(ResponseType.INFO, lid, sid, level, -1);
    }

    private void initialize(ResponseType requestType, LockID lid, ThreadID sid, ServerLockLevel level, int leaseTimeInMills) {
        this.responseType = requestType;
        this.threadID = sid;
        this.lockID = lid;
        this.lockLevel = level;
        this.leaseTimeInMs = leaseTimeInMills;
    }

    @Override
    public Object getSchedulingKey() {
        return this.getSourceNodeID();
    }

    @Override
    public boolean flush() {
        return false;
    }

    public static enum ResponseType {
        AWARD,
        RECALL,
        RECALL_WITH_TIMEOUT,
        WAIT_TIMEOUT,
        INFO,
        REFUSE;

    }
}

