/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.ehcache.clustered.common.internal.ClusteredEhcacheIdentity;
import org.ehcache.clustered.common.internal.messages.ChainCodec;
import org.ehcache.clustered.common.internal.messages.CodecUtil;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.ServerStoreOpMessage;

class ServerStoreOpCodec {
    private static final byte STORE_OP_CODE_SIZE = 1;
    private static final byte CACHE_ID_LEN_SIZE = 4;
    private static final byte KEY_SIZE = 8;
    private static final byte CHAIN_LEN_SIZE = 4;
    private static final byte INVALIDATION_ID_LEN_SIZE = 4;
    private static final byte MESSAGE_ID_SIZE = 24;
    private final ChainCodec chainCodec = new ChainCodec();

    ServerStoreOpCodec() {
    }

    public byte[] encode(ServerStoreOpMessage message) {
        int cacheIdLen = message.getCacheId().length();
        switch (message.operation()) {
            case GET: {
                ServerStoreOpMessage.GetMessage getMessage = (ServerStoreOpMessage.GetMessage)message;
                ByteBuffer encodedMsg = ByteBuffer.allocate(9 + 2 * cacheIdLen);
                encodedMsg.put(getMessage.getOpCode());
                encodedMsg.putLong(getMessage.getKey());
                CodecUtil.putStringAsCharArray(encodedMsg, getMessage.getCacheId());
                return encodedMsg.array();
            }
            case APPEND: {
                ServerStoreOpMessage.AppendMessage appendMessage = (ServerStoreOpMessage.AppendMessage)message;
                ByteBuffer encodedMsg = ByteBuffer.allocate(37 + 2 * cacheIdLen + appendMessage.getPayload().remaining());
                ServerStoreOpCodec.putCacheIdKeyAndOpCode(encodedMsg, appendMessage, appendMessage.getKey());
                encodedMsg.put(appendMessage.getPayload());
                return encodedMsg.array();
            }
            case GET_AND_APPEND: {
                ServerStoreOpMessage.GetAndAppendMessage getAndAppendMessage = (ServerStoreOpMessage.GetAndAppendMessage)message;
                ByteBuffer encodedMsg = ByteBuffer.allocate(37 + 2 * cacheIdLen + getAndAppendMessage.getPayload().remaining());
                ServerStoreOpCodec.putCacheIdKeyAndOpCode(encodedMsg, getAndAppendMessage, getAndAppendMessage.getKey());
                encodedMsg.put(getAndAppendMessage.getPayload());
                return encodedMsg.array();
            }
            case REPLACE: {
                ServerStoreOpMessage.ReplaceAtHeadMessage replaceAtHeadMessage = (ServerStoreOpMessage.ReplaceAtHeadMessage)message;
                byte[] encodedExpectedChain = this.chainCodec.encode(replaceAtHeadMessage.getExpect());
                byte[] encodedUpdatedChain = this.chainCodec.encode(replaceAtHeadMessage.getUpdate());
                ByteBuffer encodedMsg = ByteBuffer.allocate(37 + 2 * cacheIdLen + 4 + encodedExpectedChain.length + encodedUpdatedChain.length);
                ServerStoreOpCodec.putCacheIdKeyAndOpCode(encodedMsg, replaceAtHeadMessage, replaceAtHeadMessage.getKey());
                encodedMsg.putInt(encodedExpectedChain.length);
                encodedMsg.put(encodedExpectedChain);
                encodedMsg.put(encodedUpdatedChain);
                return encodedMsg.array();
            }
            case CLIENT_INVALIDATION_ACK: {
                ServerStoreOpMessage.ClientInvalidationAck clientInvalidationAck = (ServerStoreOpMessage.ClientInvalidationAck)message;
                ByteBuffer encodedMsg = ByteBuffer.allocate(5 + 2 * cacheIdLen);
                encodedMsg.put(clientInvalidationAck.getOpCode());
                encodedMsg.putInt(clientInvalidationAck.getInvalidationId());
                CodecUtil.putStringAsCharArray(encodedMsg, clientInvalidationAck.getCacheId());
                return encodedMsg.array();
            }
            case CLEAR: {
                ServerStoreOpMessage.ClearMessage clearMessage = (ServerStoreOpMessage.ClearMessage)message;
                ByteBuffer encodedMsg = ByteBuffer.allocate(25 + 2 * cacheIdLen);
                encodedMsg.put(clearMessage.getOpCode());
                encodedMsg.put(ClusteredEhcacheIdentity.serialize(message.getClientId()));
                encodedMsg.putLong(message.getId());
                CodecUtil.putStringAsCharArray(encodedMsg, clearMessage.getCacheId());
                return encodedMsg.array();
            }
        }
        throw new UnsupportedOperationException("This operation is not supported : " + (Object)((Object)message.operation()));
    }

    private static void putCacheIdKeyAndOpCode(ByteBuffer byteBuffer, ServerStoreOpMessage message, long key) {
        byteBuffer.put(message.getOpCode());
        byteBuffer.put(ClusteredEhcacheIdentity.serialize(message.getClientId()));
        byteBuffer.putLong(message.getId());
        byteBuffer.putInt(message.getCacheId().length());
        CodecUtil.putStringAsCharArray(byteBuffer, message.getCacheId());
        byteBuffer.putLong(key);
    }

    public EhcacheEntityMessage decode(byte[] payload) {
        ByteBuffer msg = ByteBuffer.wrap(payload);
        byte opCode = msg.get();
        ServerStoreOpMessage.ServerStoreOp storeOp = ServerStoreOpMessage.ServerStoreOp.getServerStoreOp(opCode);
        switch (storeOp) {
            case GET: {
                long key = msg.getLong();
                String cacheId = CodecUtil.getStringFromBuffer(msg, msg.remaining() / 2);
                return new ServerStoreOpMessage.GetMessage(cacheId, key);
            }
            case GET_AND_APPEND: {
                UUID clientId = ServerStoreOpCodec.getClientId(msg);
                long msgId = msg.getLong();
                String cacheId = ServerStoreOpCodec.readStringFromBufferWithSize(msg);
                long key = msg.getLong();
                ServerStoreOpMessage.GetAndAppendMessage decodecMsg = new ServerStoreOpMessage.GetAndAppendMessage(cacheId, key, msg.slice().asReadOnlyBuffer(), clientId);
                ((EhcacheEntityMessage)decodecMsg).setId(msgId);
                return decodecMsg;
            }
            case APPEND: {
                UUID clientId = ServerStoreOpCodec.getClientId(msg);
                long msgId = msg.getLong();
                String cacheId = ServerStoreOpCodec.readStringFromBufferWithSize(msg);
                long key = msg.getLong();
                ServerStoreOpMessage.AppendMessage decodecMsg = new ServerStoreOpMessage.AppendMessage(cacheId, key, msg.slice().asReadOnlyBuffer(), clientId);
                ((EhcacheEntityMessage)decodecMsg).setId(msgId);
                return decodecMsg;
            }
            case REPLACE: {
                UUID clientId = ServerStoreOpCodec.getClientId(msg);
                long msgId = msg.getLong();
                String cacheId = ServerStoreOpCodec.readStringFromBufferWithSize(msg);
                long key = msg.getLong();
                int expectChainLen = msg.getInt();
                byte[] encodedExpectChain = new byte[expectChainLen];
                msg.get(encodedExpectChain);
                int updateChainLen = msg.remaining();
                byte[] encodedUpdateChain = new byte[updateChainLen];
                msg.get(encodedUpdateChain);
                ServerStoreOpMessage.ReplaceAtHeadMessage decodecMsg = new ServerStoreOpMessage.ReplaceAtHeadMessage(cacheId, key, this.chainCodec.decode(encodedExpectChain), this.chainCodec.decode(encodedUpdateChain), clientId);
                ((EhcacheEntityMessage)decodecMsg).setId(msgId);
                return decodecMsg;
            }
            case CLIENT_INVALIDATION_ACK: {
                int invalidationId = msg.getInt();
                String cacheId = CodecUtil.getStringFromBuffer(msg, msg.remaining() / 2);
                return new ServerStoreOpMessage.ClientInvalidationAck(cacheId, invalidationId);
            }
            case CLEAR: {
                UUID clientId = ServerStoreOpCodec.getClientId(msg);
                long msgId = msg.getLong();
                String cacheId = CodecUtil.getStringFromBuffer(msg, msg.remaining() / 2);
                ServerStoreOpMessage.ClearMessage decodecMsg = new ServerStoreOpMessage.ClearMessage(cacheId, clientId);
                ((EhcacheEntityMessage)decodecMsg).setId(msgId);
                return decodecMsg;
            }
        }
        throw new UnsupportedOperationException("This operation code is not supported : " + opCode);
    }

    private static String readStringFromBufferWithSize(ByteBuffer buffer) {
        int length = buffer.getInt();
        return CodecUtil.getStringFromBuffer(buffer, length);
    }

    private static UUID getClientId(ByteBuffer payload) {
        long msb = payload.getLong();
        long lsb = payload.getLong();
        return new UUID(msb, lsb);
    }
}

