/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.groups;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.net.GroupID;
import com.tc.net.groups.AbstractGroupMessage;
import com.tc.net.groups.NodeIDSerializer;
import java.io.IOException;

public class StripeIDMismatchGroupMessage
extends AbstractGroupMessage {
    public static final int ERROR_STRIPEID_MISMATCH = 0;
    public static final int ERROR_NOT_CLUSTER_MEMBER = 1;
    public static final int ERROR_MISMATCH_STRIPEID = 2;
    public static final int ERROR_MISMATCH_GROUPID = 3;
    public static final int MISMATCH_TEMPORARY = 4;
    public static final int MISMATCH_NOT_READY_YET = 5;
    private int errorType;
    private String reason;
    private GroupID groupID;

    public StripeIDMismatchGroupMessage() {
        super(-1);
    }

    public StripeIDMismatchGroupMessage(int type, int errorType, String reason, GroupID groupID) {
        super(type);
        this.reason = reason;
        this.errorType = errorType;
        this.groupID = groupID;
    }

    @Override
    protected void basicDeserializeFrom(TCByteBufferInput in) throws IOException {
        this.errorType = in.readInt();
        this.reason = in.readString();
        NodeIDSerializer nodeIDSerializer = new NodeIDSerializer();
        nodeIDSerializer.deserializeFrom(in);
        this.groupID = (GroupID)nodeIDSerializer.getNodeID();
    }

    @Override
    protected void basicSerializeTo(TCByteBufferOutput out) {
        out.writeInt(this.errorType);
        out.writeString(this.reason);
        NodeIDSerializer nodeIDSerializer = new NodeIDSerializer(this.groupID);
        nodeIDSerializer.serializeTo(out);
    }

    public String toString() {
        return "StripeIDMismatchGroupMessage [ " + this.errorType + " , " + this.reason + " , " + this.groupID + " ]";
    }

    public String getReason() {
        return this.reason;
    }

    public int getErrorType() {
        return this.errorType;
    }

    public GroupID getGroupID() {
        return this.groupID;
    }
}

