/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util.concurrent;

import com.tc.text.StringUtils;
import com.tc.util.concurrent.ScheduledNamedTaskRunner;
import com.tc.util.concurrent.Timer;
import com.tc.util.concurrent.TimerNamedRunnable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

class PooledTimer
implements Timer {
    private static final String ALREADY_CANCELLED_MSG = "Cannot schedule a task - the timer has been already cancelled";
    private final ScheduledNamedTaskRunner executor;
    private final String name;
    private volatile boolean cancelled;

    public PooledTimer(ScheduledNamedTaskRunner executor) {
        this(null, executor);
    }

    public PooledTimer(String name, ScheduledNamedTaskRunner executor) {
        if (executor == null) {
            throw new IllegalArgumentException("executor should not be null");
        }
        this.name = name;
        this.executor = executor;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        if (this.cancelled) {
            throw new IllegalStateException(ALREADY_CANCELLED_MSG);
        }
        return this.executor.schedule(this.wrap(command), delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        if (this.cancelled) {
            throw new IllegalStateException(ALREADY_CANCELLED_MSG);
        }
        return this.executor.scheduleAtFixedRate(this.wrap(command), initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        if (this.cancelled) {
            throw new IllegalStateException(ALREADY_CANCELLED_MSG);
        }
        return this.executor.scheduleWithFixedDelay(this.wrap(command), initialDelay, delay, unit);
    }

    @Override
    public void execute(Runnable command) {
        if (this.cancelled) {
            throw new IllegalStateException(ALREADY_CANCELLED_MSG);
        }
        this.executor.execute(this.wrap(command));
    }

    @Override
    public void cancel() {
        this.executor.cancelTimer(this);
        this.cancelled = true;
    }

    private Runnable wrap(final Runnable r) {
        return StringUtils.isNotBlank(this.name) ? new TimerNamedRunnable(){

            @Override
            public String getName() {
                return PooledTimer.this.name;
            }

            @Override
            public Timer getTimer() {
                return PooledTimer.this;
            }

            @Override
            public void run() {
                r.run();
            }
        } : r;
    }
}

