/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.locks;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.object.locks.LockID;
import com.tc.object.locks.LockIDSerializer;
import com.tc.object.locks.Notify;
import com.tc.object.locks.ThreadID;
import java.io.IOException;

public class NotifyImpl
implements Notify {
    public static final Notify NULL = new NotifyImpl(true);
    private LockID lockID;
    private ThreadID threadID;
    private boolean all;
    private boolean initialized;
    private int hashCode;
    private final boolean isNull;

    public NotifyImpl(LockID lockID, ThreadID threadID, boolean all) {
        this.isNull = false;
        this.initialize(lockID, threadID, all);
    }

    public NotifyImpl() {
        this.isNull = false;
    }

    private NotifyImpl(boolean isNull) {
        this.isNull = isNull;
    }

    @Override
    public boolean isNull() {
        return this.isNull;
    }

    private void initialize(LockID l, ThreadID id, boolean isAll) {
        if (this.initialized) {
            throw new AssertionError((Object)"Attempt to initialize twice");
        }
        this.lockID = l;
        this.threadID = id;
        this.all = isAll;
        this.hashCode = this.calculateHashCode();
        this.initialized = true;
    }

    private int calculateHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.all ? 1231 : 1237);
        result = 31 * result + (this.lockID == null ? 0 : this.lockID.hashCode());
        result = 31 * result + (this.threadID == null ? 0 : this.threadID.hashCode());
        return result;
    }

    @Override
    public void serializeTo(TCByteBufferOutput out) {
        if (!this.initialized) {
            throw new AssertionError((Object)"Attempt to serialize an uninitialized Notify.");
        }
        new LockIDSerializer(this.lockID).serializeTo(out);
        out.writeLong(this.threadID.toLong());
        out.writeBoolean(this.all);
    }

    @Override
    public Notify deserializeFrom(TCByteBufferInput in) throws IOException {
        LockIDSerializer lidsr = new LockIDSerializer();
        LockID lid = lidsr.deserializeFrom(in).getLockID();
        this.initialize(lid, new ThreadID(in.readLong()), in.readBoolean());
        return this;
    }

    public int hashCode() {
        if (!this.initialized) {
            throw new AssertionError((Object)"Called hashCode before initializing.");
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof NotifyImpl)) {
            return false;
        }
        NotifyImpl cmp = (NotifyImpl)o;
        return this.lockID.equals(cmp.lockID) && this.threadID.equals(cmp.threadID) && this.all == cmp.all;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.lockID + ", " + this.threadID + ", " + "all: " + this.all + "]";
    }

    @Override
    public ThreadID getThreadID() {
        return this.threadID;
    }

    @Override
    public LockID getLockID() {
        return this.lockID;
    }

    @Override
    public boolean getIsAll() {
        return this.all;
    }
}

