/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.net.protocol.tcm.ChannelID;
import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.ConnectionIDFactory;
import com.tc.net.protocol.transport.ConnectionIDFactoryListener;
import com.tc.util.UUID;
import java.util.Collections;
import java.util.Set;

public class DefaultConnectionIdFactory
implements ConnectionIDFactory {
    private long sequence;
    private final String serverID = UUID.getUUID().toString();

    @Override
    public ConnectionID populateConnectionID(ConnectionID connectionID) {
        if (new ChannelID(connectionID.getChannelID()).isNull()) {
            return this.nextConnectionId(connectionID.getJvmID());
        }
        return this.makeConnectionId(connectionID.getJvmID(), connectionID.getChannelID());
    }

    private synchronized ConnectionID nextConnectionId(String clientJvmID) {
        return new ConnectionID(clientJvmID, this.sequence++, this.serverID);
    }

    private ConnectionID makeConnectionId(String clientJvmID, long channelID) {
        return new ConnectionID(clientJvmID, channelID, this.serverID);
    }

    @Override
    public Set<ConnectionID> loadConnectionIDs() {
        return Collections.emptySet();
    }

    @Override
    public void init(String clusterID, long nextAvailChannelID, Set<ConnectionID> connections) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerForConnectionIDEvents(ConnectionIDFactoryListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void restoreConnectionId(ConnectionID rv) {
    }

    @Override
    public long getCurrentConnectionID() {
        return this.sequence;
    }

    public String getServerID() {
        return this.serverID;
    }
}

