/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.tcm;

import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.protocol.tcm.GeneratedMessageFactory;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessage;
import com.tc.net.protocol.tcm.TCMessageFactory;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.net.protocol.tcm.UnsupportedMessageTypeException;
import com.tc.object.session.SessionID;
import com.tc.object.session.SessionProvider;
import java.lang.reflect.Constructor;

public class TCMessageFactoryImpl
implements TCMessageFactory {
    private final GeneratedMessageFactory[] fArray = new GeneratedMessageFactory[21];
    private final MessageMonitor monitor;
    private final SessionProvider sessionProvider;

    public TCMessageFactoryImpl(SessionProvider sessionProvider, MessageMonitor monitor) {
        this.sessionProvider = sessionProvider;
        this.monitor = monitor;
    }

    @Override
    public TCMessage createMessage(MessageChannel source, TCMessageType type) throws UnsupportedMessageTypeException {
        GeneratedMessageFactory factory = this.lookupFactory(type);
        return factory.createMessage(this.sessionProvider.getSessionID(), this.monitor, TCMessageFactoryImpl.createBuffer(), source, type);
    }

    private static TCByteBufferOutputStream createBuffer() {
        return new TCByteBufferOutputStream(4, 4096, false);
    }

    @Override
    public TCMessage createMessage(MessageChannel source, TCMessageType type, TCMessageHeader header, TCByteBuffer[] data) {
        GeneratedMessageFactory factory = this.lookupFactory(type);
        return factory.createMessage(this.sessionProvider.getSessionID(), this.monitor, source, header, data);
    }

    @Override
    public void addClassMapping(TCMessageType type, GeneratedMessageFactory messageFactory) {
        if (type == null || messageFactory == null) {
            throw new IllegalArgumentException();
        }
        if (this.fArray[type.getType() - 1] != null) {
            throw new IllegalStateException("message already has class mapping: " + type);
        }
        this.fArray[type.getType() - 1] = messageFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addClassMapping(TCMessageType type, Class<? extends TCMessage> msgClass) {
        if (type == null || msgClass == null) {
            throw new IllegalArgumentException();
        }
        String string = msgClass.getName().intern();
        synchronized (string) {
            if (this.fArray[type.getType() - 1] != null) {
                throw new IllegalStateException("message already has class mapping: " + type);
            }
            this.fArray[type.getType() - 1] = new GeneratedMessageFactoryImpl(msgClass);
        }
    }

    private GeneratedMessageFactory lookupFactory(TCMessageType type) {
        GeneratedMessageFactory factory = this.fArray[type.getType() - 1];
        if (factory == null) {
            throw new RuntimeException("No factory for type " + type);
        }
        return factory;
    }

    private static class GeneratedMessageFactoryImpl
    implements GeneratedMessageFactory {
        private final Constructor<? extends TCMessage> sendCstr;
        private final Constructor<? extends TCMessage> recvCstr;

        GeneratedMessageFactoryImpl(Class<? extends TCMessage> msgClass) {
            this.sendCstr = GeneratedMessageFactoryImpl.findConstructor(msgClass, SessionID.class, MessageMonitor.class, TCByteBufferOutputStream.class, MessageChannel.class, TCMessageType.class);
            this.recvCstr = GeneratedMessageFactoryImpl.findConstructor(msgClass, SessionID.class, MessageMonitor.class, MessageChannel.class, TCMessageHeader.class, TCByteBuffer[].class);
            if (this.sendCstr == null && this.recvCstr == null) {
                throw new RuntimeException("No constructors available for " + msgClass);
            }
        }

        private static Constructor<? extends TCMessage> findConstructor(Class<? extends TCMessage> msgClass, Class<?> ... argTypes) {
            try {
                return msgClass.getConstructor(argTypes);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public TCMessage createMessage(SessionID sid, MessageMonitor monitor, TCByteBufferOutputStream output, MessageChannel channel, TCMessageType type) {
            if (this.sendCstr == null) {
                throw new UnsupportedOperationException();
            }
            try {
                return this.sendCstr.newInstance(sid, monitor, output, channel, type);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public TCMessage createMessage(SessionID sid, MessageMonitor monitor, MessageChannel channel, TCMessageHeader msgHeader, TCByteBuffer[] data) {
            if (this.recvCstr == null) {
                throw new UnsupportedOperationException();
            }
            try {
                return this.recvCstr.newInstance(sid, monitor, channel, msgHeader, data);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

