/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.core;

import com.tc.net.core.SecurityInfo;
import com.tc.util.Assert;
import java.io.Serializable;

public class ConnectionInfo
implements Serializable {
    public static final ConnectionInfo[] EMPTY_ARRAY = new ConnectionInfo[0];
    private final String hostname;
    private final int port;
    private final int groupId;
    private final String groupName;
    private final SecurityInfo securityInfo;
    private String s;

    public ConnectionInfo(String hostname, int port) {
        this(hostname, port, new SecurityInfo());
    }

    public ConnectionInfo(String hostname, int port, SecurityInfo securityInfo) {
        this(hostname, port, 0, null, securityInfo);
    }

    public ConnectionInfo(String hostname, int port, int groupId, String groupName) {
        this(hostname, port, groupId, groupName, new SecurityInfo());
    }

    public ConnectionInfo(String hostname, int port, int groupId, String groupName, SecurityInfo securityInfo) {
        Assert.assertNotNull(hostname);
        this.hostname = hostname;
        this.port = port;
        this.groupId = groupId;
        this.groupName = groupName;
        this.securityInfo = securityInfo;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ConnectionInfo) {
            ConnectionInfo other = (ConnectionInfo)o;
            if (this.groupName == null) {
                return this.hostname.equals(other.getHostname()) && this.port == other.getPort();
            }
            return this.hostname.equals(other.getHostname()) && this.port == other.getPort() && this.groupName.equals(other.groupName);
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.s == null ? (this.s = this.hostname + ":" + this.port + (this.groupName != null ? ":" + this.groupName : "")) : this.s;
    }

    public SecurityInfo getSecurityInfo() {
        return this.securityInfo;
    }
}

