/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.runnel.metadata;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.terracotta.runnel.decoding.fields.Field;
import org.terracotta.runnel.metadata.FieldDecoder;
import org.terracotta.runnel.metadata.FieldSearcher;
import org.terracotta.runnel.utils.ReadBuffer;

public class Metadata {
    private final List<? extends Field> metadata;
    private final Map<String, Field> fieldsByName;

    public Metadata(List<? extends Field> metadata) {
        this(metadata, true);
    }

    public Metadata(List<? extends Field> metadata, boolean init) {
        this.metadata = metadata;
        if (init) {
            this.fieldsByName = new HashMap<String, Field>();
            this.init();
        } else {
            this.fieldsByName = new ConcurrentHashMap<String, Field>(16, 1.0f, 1);
        }
    }

    public void init() {
        if (!this.fieldsByName.isEmpty()) {
            throw new IllegalStateException("Metadata already initialized");
        }
        for (Field field : this.metadata) {
            this.fieldsByName.put(field.name(), field);
        }
    }

    public FieldSearcher fieldSearcher() {
        return new FieldSearcher(this);
    }

    public FieldDecoder fieldDecoder(ReadBuffer readBuffer) {
        return new FieldDecoder(this, readBuffer);
    }

    public Map<Integer, Field> buildFieldsByIndexMap() {
        HashMap<Integer, Field> map = new HashMap<Integer, Field>();
        for (Field field : this.fieldsByName.values()) {
            map.put(field.index(), field);
        }
        return map;
    }

    Field getFieldByName(String name) {
        return this.fieldsByName.get(name);
    }
}

