/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.runnel;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.terracotta.runnel.EnumMapping;

public class EnumMappingBuilder<E> {
    private final Map<E, Integer> enumToInteger;
    private final Map<Integer, E> integerToEnum = new HashMap<Integer, E>();
    private final Class<E> enumClass;

    private EnumMappingBuilder(Class<E> enumClass) {
        this.enumClass = enumClass;
        this.enumToInteger = Enum.class.isAssignableFrom(enumClass) ? new EnumMap<E, Integer>(enumClass) : new HashMap<E, Integer>();
    }

    public static <E> EnumMappingBuilder<E> newEnumMappingBuilder(Class<E> enumClass) {
        return new EnumMappingBuilder<E>(enumClass);
    }

    public EnumMapping<E> build() {
        if (Enum.class.isAssignableFrom(this.enumClass)) {
            HashSet<E> unregisteredEnums = new HashSet<E>(EnumSet.allOf(this.enumClass));
            unregisteredEnums.removeAll(this.enumToInteger.keySet());
            if (!unregisteredEnums.isEmpty()) {
                throw new IllegalStateException("Missing enum mappings for : " + String.valueOf(unregisteredEnums));
            }
        }
        return new EnumMapping<E>(this.enumToInteger, this.integerToEnum);
    }

    public EnumMappingBuilder<E> mapping(E e, int value) {
        if (this.enumToInteger.containsKey(e)) {
            throw new IllegalArgumentException("Duplicate enum value : " + String.valueOf(e));
        }
        if (value < 0) {
            throw new IllegalArgumentException("Int value must be >= 0, got : " + value);
        }
        if (this.integerToEnum.containsKey(value)) {
            throw new IllegalArgumentException("Duplicate int value : " + value);
        }
        this.enumToInteger.put(e, value);
        this.integerToEnum.put(value, e);
        return this;
    }
}

