/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.inet;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.terracotta.inet.HostPort;

public class UriUtils {
    private UriUtils() {
    }

    public static List<String> parseSegments(String uri) {
        try {
            ArrayList<String> segments = new ArrayList<String>();
            String path = UriUtils.parsePath(uri);
            if (path != null) {
                for (String segment : path.split("/")) {
                    if (segment.isEmpty()) continue;
                    segments.add(URLDecoder.decode(segment, "UTF-8"));
                }
            }
            return segments;
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError();
        }
    }

    public static List<HostPort> parseHostPorts(String uri) {
        return UriUtils.parseHostPorts(uri, 9410);
    }

    public static List<HostPort> parseHostPorts(String uri, int defaultPort) {
        String auth = UriUtils.parseAuthority(uri);
        if (auth == null) {
            return Collections.emptyList();
        }
        return HostPort.parse(auth.split(","), defaultPort);
    }

    public static String parseScheme(String uri) {
        if (uri == null) {
            return null;
        }
        int index = uri.indexOf(":");
        return index <= 0 ? null : URI.create(uri.substring(0, index) + "://fake").getScheme();
    }

    public static String parseAuthority(String uri) {
        if (uri == null) {
            return null;
        }
        int index = uri.indexOf("://");
        if (index <= 0) {
            return null;
        }
        String schemeLess = uri.substring(index + 3);
        if (schemeLess.isEmpty()) {
            return null;
        }
        int beginningOfPath = schemeLess.indexOf("/");
        int beginningOfQuery = schemeLess.indexOf("?");
        int beginningOfFragment = schemeLess.indexOf("#");
        String authority = beginningOfPath != -1 ? schemeLess.substring(0, beginningOfPath) : (beginningOfQuery != -1 ? schemeLess.substring(0, beginningOfQuery) : (beginningOfFragment != -1 ? schemeLess.substring(0, beginningOfFragment) : schemeLess));
        return authority.isEmpty() ? null : authority;
    }

    public static String parseUserInfo(String uri) {
        String authority = UriUtils.parseAuthority(uri);
        if (authority == null) {
            return null;
        }
        String[] servers = authority.split(",");
        if (servers.length > 1) {
            return null;
        }
        String server = servers[0];
        int indexOfAlpha = server.indexOf("@");
        if (indexOfAlpha == -1) {
            return null;
        }
        String userInfo = server.substring(0, indexOfAlpha);
        return userInfo.isEmpty() ? null : userInfo;
    }

    public static String parsePath(String uri) {
        String path;
        if (uri == null) {
            return null;
        }
        int schemePosition = uri.indexOf("://");
        if (schemePosition == 0) {
            return null;
        }
        String schemeLess = schemePosition != -1 ? uri.substring(schemePosition + 3) : uri;
        String authority = UriUtils.parseAuthority(uri);
        if (authority == null) {
            int beginningOfQuery = schemeLess.indexOf("?");
            int beginningOfFragment = schemeLess.indexOf("#");
            path = beginningOfQuery != -1 ? schemeLess.substring(0, beginningOfQuery) : (beginningOfFragment != -1 ? schemeLess.substring(0, beginningOfFragment) : schemeLess);
        } else {
            String authorityLess = schemeLess.replace(authority, "");
            int beginningOfQuery = authorityLess.indexOf("?");
            int beginningOfFragment = authorityLess.indexOf("#");
            path = beginningOfQuery != -1 ? authorityLess.substring(0, beginningOfQuery) : (beginningOfFragment != -1 ? authorityLess.substring(0, beginningOfFragment) : authorityLess);
        }
        return path;
    }

    public static String parseQuery(String uri) {
        if (uri == null) {
            return null;
        }
        int indexOfQuestionMark = uri.indexOf("?");
        if (indexOfQuestionMark == -1) {
            return null;
        }
        int indexOfHash = uri.indexOf("#");
        String query = indexOfHash != -1 ? uri.substring(indexOfQuestionMark + 1, indexOfHash) : uri.substring(indexOfQuestionMark + 1);
        return query.isEmpty() ? null : query;
    }

    public static String appendSegmentToPath(String path, String segment) {
        if (path == null) {
            path = "";
        }
        if (segment == null) {
            segment = "";
        }
        if (path.isEmpty()) {
            return segment;
        }
        if (segment.isEmpty()) {
            return path;
        }
        if (path.charAt(path.length() - 1) == '/' && segment.startsWith("/")) {
            return path.substring(0, path.length() - 1) + segment;
        }
        if (path.charAt(path.length() - 1) == '/' || segment.startsWith("/")) {
            return path + segment;
        }
        return path + "/" + segment;
    }
}

