/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.service;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.terracotta.dynamic_config.api.model.Scope;
import org.terracotta.dynamic_config.api.model.Setting;

public class ConfigPropertiesTranslator {
    private static final String BLANK = "";
    private static final String DOT = ".";
    private static final String COLON = ":";
    private static final String EQUALS = "=";
    private static final String NAMES_LIST_DELIM = ",";
    private static final String NODE = "node";
    private static final String STRIPE = "stripe";
    private static final String NEW_LINE = System.lineSeparator();
    static final String ERR_STRIPE_NAMES_PROPERTY_MISSING = "The 'stripe-names' property was not identified.";
    static final String ERR_NO_STRIPES_IDENTIFIED = "No stripe names were identified.";
    static final String ERR_NODE_NAMES_PROPERTY_MISSING = "No 'node-names' property belonging to any stripe was identified.";
    static final String ERR_NO_NODES_IDENTIFIED = "No node names belonging to any stripe were identified.";
    static final String ERR_NO_NODES_SPECIFIED_FOR_PROPERTY = "No nodes were specified for property ";
    private final Set<String> errors = new LinkedHashSet<String>();
    private final Properties converted = new Properties();
    private final Map<String, String> inputConfigSettings = new LinkedHashMap<String, String>();
    private final Map<String, String> nodesNamespace = new TreeMap<String, String>();
    private final Map<String, String> stripesNamespace = new TreeMap<String, String>();
    private final StringBuilder configFileOutput = new StringBuilder();

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public Properties load(Path configFile) {
        Properties properties;
        Objects.requireNonNull(configFile);
        if (configFile.getFileName() == null || !configFile.getFileName().toString().endsWith(".cfg")) {
            throw new IllegalArgumentException("Expected a .cfg file, but got " + String.valueOf(configFile.getFileName()));
        }
        InputStreamReader in = new InputStreamReader(Files.newInputStream(configFile, new OpenOption[0]), StandardCharsets.UTF_8);
        try {
            properties = this.convert(in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | RuntimeException e) {
                throw new IllegalArgumentException("Failed to read configuration file: " + String.valueOf(configFile.getFileName()) + ". Make sure the file exists, is readable and in the right format. Error: " + e.getMessage(), e);
            }
        }
        ((Reader)in).close();
        return properties;
    }

    public Properties convert(Reader stream) throws IOException {
        this.errors.clear();
        this.inputConfigSettings.clear();
        try (BufferedReader reader = new BufferedReader(stream);){
            List lines = reader.lines().filter(line -> !(line = line.trim()).isEmpty() && !line.startsWith("#") && !line.startsWith("!")).collect(Collectors.toList());
            Iterator itr = lines.iterator();
            Object line2 = BLANK;
            while (itr.hasNext()) {
                String thisLine = (String)itr.next();
                int continuationIndex = thisLine.lastIndexOf(92);
                if (continuationIndex == -1) {
                    line2 = (String)line2 + thisLine;
                    String[] splits = ((String)line2).split(EQUALS);
                    this.inputConfigSettings.put(splits[0].trim(), splits.length > 1 ? splits[1].trim() : BLANK);
                    line2 = BLANK;
                    continue;
                }
                line2 = (String)line2 + thisLine.substring(0, continuationIndex);
            }
        }
        catch (Exception ex) {
            throw this.errorsWith(ex.getMessage());
        }
        this.createStripesNamespace();
        this.createNodesNamespace();
        this.inputConfigSettings.keySet().stream().filter(k -> k.endsWith(":stripe-name") || k.endsWith(":name")).collect(Collectors.toList()).forEach(this.inputConfigSettings::remove);
        this.inputConfigSettings.keySet().forEach(this::validateProperty);
        if (!this.errors.isEmpty()) {
            throw this.errors();
        }
        this.converted.clear();
        this.inputConfigSettings.entrySet().stream().filter(e -> this.isSettingAtScope((String)e.getKey(), SettingScope.CLUSTER)).forEach(ee -> this.addProperty((String)ee.getKey(), (String)ee.getValue()));
        this.inputConfigSettings.entrySet().stream().filter(e -> this.isSettingAtScope((String)e.getKey(), SettingScope.STRIPE)).forEach(ee -> this.addProperty((String)ee.getKey(), (String)ee.getValue()));
        this.inputConfigSettings.entrySet().stream().filter(e -> this.isSettingAtScope((String)e.getKey(), SettingScope.NODE)).forEach(ee -> this.addProperty((String)ee.getKey(), (String)ee.getValue()));
        this.stripesNamespace.forEach((name, namespace) -> {
            if (this.converted.keySet().stream().noneMatch(k -> k.toString().startsWith((String)namespace))) {
                this.addError("Stripe '" + name + "' is not used (none of its nodes have any settings assigned). Consider removing it from the 'stripe-names' property.");
            }
        });
        this.nodesNamespace.forEach((name, namespace) -> {
            if (this.converted.keySet().stream().noneMatch(k -> k.toString().startsWith((String)namespace))) {
                this.addError("Node '" + name + "' has no settings assigned to it. Add at least one setting or remove it from the appropriate '<stripe>:node-names' property.");
            }
        });
        if (!this.errors.isEmpty()) {
            throw this.errors();
        }
        this.stripesNamespace.forEach((name, namespace) -> this.converted.put(namespace + "stripe-name", name));
        this.nodesNamespace.forEach((name, namespace) -> this.converted.put(namespace + "name", name));
        return this.converted;
    }

    private void createStripesNamespace() {
        this.stripesNamespace.clear();
        String csvStripeNames = this.inputConfigSettings.get("stripe-names");
        if (csvStripeNames == null) {
            throw this.errorsWith(ERR_STRIPE_NAMES_PROPERTY_MISSING);
        }
        if (csvStripeNames.isEmpty()) {
            throw this.errorsWith(ERR_NO_STRIPES_IDENTIFIED);
        }
        List<String> stripes = this.split(csvStripeNames, NAMES_LIST_DELIM);
        if (stripes.isEmpty()) {
            throw this.errorsWith(ERR_NO_STRIPES_IDENTIFIED);
        }
        this.fillNamespace(this.stripesNamespace, stripes, STRIPE);
        this.inputConfigSettings.remove("stripe-names");
    }

    private void createNodesNamespace() {
        this.nodesNamespace.clear();
        List<String> nodeNamesKeys = this.inputConfigSettings.keySet().stream().filter(k -> k.endsWith(":node-names")).collect(Collectors.toList());
        if (nodeNamesKeys.isEmpty()) {
            throw this.errorsWith(ERR_NODE_NAMES_PROPERTY_MISSING);
        }
        nodeNamesKeys.forEach(k -> {
            String stripeNamespace = this.validateNodeNamesProperty((String)k, this.inputConfigSettings.get(k));
            if (!stripeNamespace.isEmpty()) {
                this.fillNamespace(this.nodesNamespace, this.split(this.inputConfigSettings.get(k), NAMES_LIST_DELIM), stripeNamespace + NODE);
            }
            this.inputConfigSettings.remove(k);
        });
        if (this.nodesNamespace.isEmpty()) {
            this.addError(ERR_NO_NODES_IDENTIFIED);
        }
        if (!this.errors.isEmpty()) {
            throw this.errors();
        }
    }

    private String validateNodeNamesProperty(String nodeNamesProperty, String csvNodeNames) {
        String stripeIndex = BLANK;
        List<String> splits = this.split(nodeNamesProperty, COLON);
        if (splits.size() == 2) {
            stripeIndex = this.validateStripeName(splits.get(0), nodeNamesProperty);
        } else if (splits.size() == 3) {
            String scope = splits.get(0);
            if (!scope.equals(STRIPE)) {
                this.addError("Invalid scope for '" + nodeNamesProperty + ". Expected 'stripe' but found '" + scope + "'");
            }
            stripeIndex = this.validateStripeName(splits.get(1), nodeNamesProperty);
        } else {
            this.addError("Invalid syntax for property '" + nodeNamesProperty + "'");
        }
        if (csvNodeNames.isEmpty() || this.split(csvNodeNames, NAMES_LIST_DELIM).isEmpty()) {
            this.addError(ERR_NO_NODES_SPECIFIED_FOR_PROPERTY + nodeNamesProperty);
            stripeIndex = BLANK;
        }
        return stripeIndex;
    }

    private String validateStripeName(String stripeName, String nodeNamesProperty) {
        String stripeIndex = BLANK;
        if (stripeName.isEmpty()) {
            this.addError("Blank stripe name specified in property '" + nodeNamesProperty + "'");
        } else {
            stripeIndex = this.stripesNamespace.getOrDefault(stripeName, BLANK);
            if (stripeIndex.isEmpty()) {
                this.addError("Stripe '" + stripeName + "' referenced in '" + nodeNamesProperty + "' not found in 'stripe-names'");
            }
        }
        return stripeIndex;
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    private void validateProperty(String prop) {
        try {
            List<String> splits = this.split(prop, COLON);
            if (splits.size() == 3) {
                this.validateNamespaceForProperty(prop, splits.get(1), prop.substring(0, prop.indexOf(COLON)));
            } else if (splits.size() == 2) {
                this.validateNamespaceForProperty(prop, splits.get(0), BLANK);
            } else if (splits.size() != 1) {
                throw new IOException("Invalid syntax for property '" + prop + "'");
            }
        }
        catch (Exception ex) {
            this.addError(ex.getMessage());
        }
    }

    private void validateNamespaceForProperty(String prop, String stripeOrNodeName, String scope) throws IllegalArgumentException {
        String stripeNamespace = this.stripesNamespace.getOrDefault(stripeOrNodeName, BLANK);
        String nodeNamespace = this.nodesNamespace.getOrDefault(stripeOrNodeName, BLANK);
        if (scope.isEmpty()) {
            if (stripeNamespace.isEmpty() && nodeNamespace.isEmpty()) {
                throw new IllegalArgumentException("Name '" + stripeOrNodeName + "' in property '" + prop + "' is not a recognized stripe or node name");
            }
            if (!stripeNamespace.isEmpty() && !nodeNamespace.isEmpty()) {
                throw new IllegalArgumentException("Name '" + stripeOrNodeName + "' in property '" + prop + "' is both a stripe name and node name'. It must be qualified with either 'stripe:' or 'node:'");
            }
        } else if (scope.equals(STRIPE)) {
            if (stripeNamespace.isEmpty()) {
                throw new IllegalArgumentException("Stripe '" + stripeOrNodeName + "' in property '" + prop + "' is not a recognized stripe");
            }
        } else if (scope.equals(NODE)) {
            if (nodeNamespace.isEmpty()) {
                throw new IllegalArgumentException("Node '" + stripeOrNodeName + "' in property '" + prop + "' is not a recognized node");
            }
        } else {
            throw new IllegalArgumentException("Scope '" + scope + ":' specified in property '" + prop + "' is invalid. Scope must be one of 'stripe:' or 'node:'");
        }
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    private void addProperty(String prop, String value) {
        try {
            String setting = prop;
            String stripeOrNodeName = BLANK;
            String indexNamespace = BLANK;
            List<String> splits = this.split(prop, COLON);
            if (splits.size() == 3) {
                stripeOrNodeName = splits.get(1);
                setting = splits.get(2);
                indexNamespace = this.getIndexNamespaceForStripeOrNodeName(stripeOrNodeName, prop.substring(0, prop.indexOf(COLON)));
            } else if (splits.size() == 2) {
                stripeOrNodeName = splits.get(0);
                setting = splits.get(1);
                indexNamespace = this.getIndexNamespaceForStripeOrNodeName(stripeOrNodeName, BLANK);
            }
            int rootIndex = setting.indexOf(DOT);
            Setting rootSetting = Setting.fromName(setting.substring(0, rootIndex == -1 ? setting.length() : rootIndex));
            String finalSetting = setting;
            if (rootSetting.isScope(Scope.NODE) && indexNamespace.isEmpty()) {
                this.nodesNamespace.forEach((nn, ns) -> this.converted.put(ns + finalSetting, value));
            } else if (rootSetting.isScope(Scope.NODE) && this.stripesNamespace.containsKey(stripeOrNodeName)) {
                String finalIndexNamespace = indexNamespace;
                this.nodesNamespace.values().stream().filter(v -> v.startsWith(finalIndexNamespace)).forEach(v -> this.converted.put(v + finalSetting, value));
            } else {
                this.converted.put(indexNamespace + setting, value);
            }
        }
        catch (Exception ex) {
            this.addError(ex.getMessage());
        }
    }

    private String getIndexNamespaceForStripeOrNodeName(String stripeOrNodeName, String scope) throws IllegalArgumentException {
        String stripeNamespace = this.stripesNamespace.getOrDefault(stripeOrNodeName, BLANK);
        String nodeNamespace = this.nodesNamespace.getOrDefault(stripeOrNodeName, BLANK);
        String indexNamespace = scope.isEmpty() ? (!stripeNamespace.isEmpty() ? stripeNamespace : nodeNamespace) : (scope.equals(STRIPE) ? stripeNamespace : nodeNamespace);
        return indexNamespace;
    }

    private void fillNamespace(Map<String, String> namespace, List<String> names, String scope) {
        int i = 1;
        for (String name : names) {
            if (namespace.containsKey(name)) continue;
            namespace.put(name, scope + DOT + i++ + DOT);
        }
    }

    private boolean isSettingAtScope(String setting, SettingScope scope) {
        boolean atScope = false;
        List<String> splits = this.split(setting, COLON);
        if (scope == SettingScope.CLUSTER) {
            if (splits.size() == 1) {
                atScope = true;
            }
        } else {
            String stripeOrNodeName = BLANK;
            if (splits.size() == 3) {
                stripeOrNodeName = splits.get(1);
            } else if (splits.size() == 2) {
                stripeOrNodeName = splits.get(0);
            }
            if (scope == SettingScope.STRIPE) {
                if (!this.stripesNamespace.getOrDefault(stripeOrNodeName, BLANK).isEmpty()) {
                    atScope = true;
                }
            } else if (scope == SettingScope.NODE && !this.nodesNamespace.getOrDefault(stripeOrNodeName, BLANK).isEmpty()) {
                atScope = true;
            }
        }
        return atScope;
    }

    public String writeConfigOutput(Properties properties) {
        return this.writeConfigOutput(properties, BLANK);
    }

    public String writeConfigOutput(Properties properties, String fileHeader) {
        return this.writeConfigOutput(fileHeader, properties, BLANK, null, BLANK, null, BLANK);
    }

    public String writeConfigOutput(String fileHeader, Properties userDefinedProperties, String userDefinedPropertiesHeader, Properties defaultProperties, String defaultPropertiesHeader, Properties hiddenProperties, String hiddenPropertiesHeader) {
        Properties userDefinedPropertiesCopy = new Properties();
        userDefinedPropertiesCopy.putAll((Map<?, ?>)userDefinedProperties);
        this.stripesNamespace.clear();
        userDefinedProperties.entrySet().stream().filter(es -> es.getKey().toString().endsWith(".stripe-name")).forEach(e -> {
            String key = e.getKey().toString();
            this.stripesNamespace.put(key.substring(0, key.indexOf(".stripe-name")) + DOT, e.getValue().toString());
            userDefinedPropertiesCopy.remove(key);
        });
        this.nodesNamespace.clear();
        userDefinedProperties.entrySet().stream().filter(es -> es.getKey().toString().endsWith(".name")).forEach(e -> {
            String key = e.getKey().toString();
            this.nodesNamespace.put(key.substring(0, key.indexOf(".name")) + DOT, e.getValue().toString());
            userDefinedPropertiesCopy.remove(key);
        });
        Map<String, String> userDefinedProps = this.sort(userDefinedPropertiesCopy);
        Map<String, String> defaultProps = this.sort(defaultProperties);
        Map<String, String> hiddenProps = this.sort(hiddenProperties);
        this.configFileOutput.setLength(0);
        this.writeHeader(fileHeader);
        this.writeHeader(userDefinedPropertiesHeader);
        this.writeStripeNames();
        this.writeNodeNames();
        this.writeProperties(userDefinedProps, WriteScope.CLUSTER_WIDE_ONLY, false);
        this.writeProperties(userDefinedProps, WriteScope.NODE_SCOPE_ONLY, true);
        this.appendl(BLANK);
        if (defaultProperties != null) {
            this.writeHeader(defaultPropertiesHeader);
            if (defaultProps.isEmpty()) {
                this.appendl("# No default properties in use.");
            } else {
                this.writeProperties(defaultProps, WriteScope.BOTH, false);
            }
            this.appendl(BLANK);
        }
        if (hiddenProperties != null) {
            this.writeHeader(hiddenPropertiesHeader);
            if (hiddenProps.isEmpty()) {
                this.appendl("# No hidden properties found.");
            } else {
                this.writeProperties(hiddenProps, WriteScope.BOTH, false);
            }
        }
        return this.configFileOutput.toString();
    }

    private void writeHeader(String header) {
        if (!header.isEmpty()) {
            this.appendl("# " + header);
            this.appendl(BLANK);
        }
    }

    private void writeStripeNames() {
        this.append("stripe-names=");
        this.stripesNamespace.forEach((k, stripeName) -> this.append(stripeName + NAMES_LIST_DELIM));
        this.configFileOutput.delete(this.configFileOutput.length() - NAMES_LIST_DELIM.length(), this.configFileOutput.length());
        this.appendl(BLANK);
    }

    private void writeNodeNames() {
        this.stripesNamespace.forEach((k, stripeName) -> {
            this.append("stripe:" + stripeName + ":node-names=");
            this.nodesNamespace.forEach((kk, nodeName) -> {
                if (kk.startsWith((String)k)) {
                    this.append(nodeName + NAMES_LIST_DELIM);
                }
            });
            this.configFileOutput.delete(this.configFileOutput.length() - NAMES_LIST_DELIM.length(), this.configFileOutput.length());
            this.appendl(BLANK);
        });
        this.appendl(BLANK);
    }

    private void writeProperties(Map<String, String> props, WriteScope writeScope, boolean group) {
        AtomicReference<String> lastNamespace = new AtomicReference<String>(BLANK);
        props.forEach((k, v) -> {
            String thisNamespace = BLANK;
            Optional<Map.Entry> namespace = this.nodesNamespace.entrySet().stream().filter(es -> k.startsWith((String)es.getKey())).findFirst();
            if (namespace.isPresent()) {
                thisNamespace = (String)namespace.get().getKey();
                String nodeName = (String)namespace.get().getValue();
                String setting = k.substring(thisNamespace.length());
                if (writeScope == WriteScope.BOTH || writeScope == WriteScope.NODE_SCOPE_ONLY) {
                    lastNamespace.set(this.appendl((String)lastNamespace.get(), thisNamespace, group, "node:" + nodeName + COLON + setting, (String)v));
                }
            } else {
                namespace = this.stripesNamespace.entrySet().stream().filter(es -> k.startsWith((String)es.getKey())).findFirst();
                if (namespace.isPresent()) {
                    thisNamespace = (String)namespace.get().getKey();
                    String stripeName = (String)namespace.get().getValue();
                    String setting = k.substring(thisNamespace.length());
                    if (writeScope == WriteScope.BOTH || writeScope == WriteScope.NODE_SCOPE_ONLY) {
                        lastNamespace.set(this.appendl((String)lastNamespace.get(), thisNamespace, group, "stripe:" + stripeName + COLON + setting, (String)v));
                    }
                } else if (writeScope == WriteScope.BOTH || writeScope == WriteScope.CLUSTER_WIDE_ONLY) {
                    lastNamespace.set(this.appendl((String)lastNamespace.get(), thisNamespace, group, (String)k, (String)v));
                }
            }
        });
    }

    private void append(String fragment) {
        this.configFileOutput.append(fragment);
    }

    private void appendl(String fragment) {
        this.configFileOutput.append(fragment).append(NEW_LINE);
    }

    private String appendl(String lastNamespace, String thisNamespace, boolean group, String setting, String value) {
        if (group && !lastNamespace.equals(thisNamespace)) {
            lastNamespace = thisNamespace;
            this.appendl(BLANK);
        }
        this.appendl(setting + EQUALS + value);
        return lastNamespace;
    }

    private void addError(String error) {
        this.errors.add(error);
    }

    IllegalArgumentException errorsWith(String error) {
        this.errors.add(error);
        return this.errors();
    }

    IllegalArgumentException errors() {
        StringBuilder error = new StringBuilder();
        error.append("Error(s) were found parsing the .cfg file:").append(NEW_LINE);
        this.errors.forEach(s -> error.append("  ").append((String)s).append(NEW_LINE));
        return new IllegalArgumentException(new IOException(error.toString()));
    }

    private Map<String, String> sort(Properties props) {
        TreeMap<String, String> sortedProps = new TreeMap<String, String>();
        if (props != null) {
            props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> sortedProps.put(k.toString(), v.toString())));
        }
        return sortedProps;
    }

    private List<String> split(String line, String separator) {
        return Stream.of(line.split(separator)).map(String::trim).collect(Collectors.toList());
    }

    private static enum SettingScope {
        CLUSTER,
        STRIPE,
        NODE;

    }

    private static enum WriteScope {
        CLUSTER_WIDE_ONLY,
        NODE_SCOPE_ONLY,
        BOTH;

    }
}

