/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.connection.ConnectionException;
import org.terracotta.connection.entity.Entity;
import org.terracotta.connection.entity.EntityRef;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.EndpointType;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.UID;
import org.terracotta.dynamic_config.entity.topology.client.DynamicTopologyEntity;
import org.terracotta.exception.EntityNotFoundException;
import org.terracotta.exception.EntityNotProvidedException;
import org.terracotta.exception.EntityVersionMismatchException;
import org.terracotta.inet.HostPort;
import org.terracotta.lease.connection.LeasedConnection;
import org.terracotta.lease.connection.LeasedConnectionFactory;

public abstract class ConnectionSource {
    public abstract String getClusterTierManager();

    public abstract LeasedConnection connect(Properties var1) throws ConnectionException;

    public abstract URI getClusterUri();

    private static class HostPortSet
    extends AbstractSet<InetSocketAddress> {
        private volatile EndpointType endpointType;
        private volatile Collection<HostPort> hostPorts;

        public HostPortSet(Iterable<InetSocketAddress> initial) {
            this.hostPorts = StreamSupport.stream(initial.spliterator(), false).map(HostPort::create).collect(Collectors.toList());
            this.endpointType = null;
        }

        @Override
        public Iterator<InetSocketAddress> iterator() {
            return this.hostPorts.stream().map(HostPort::createInetSocketAddress).iterator();
        }

        @Override
        public int size() {
            return this.hostPorts.size();
        }

        public void refresh(Cluster cluster) {
            if (this.endpointType == null) {
                this.endpointType = cluster.determineEndpointType(this.hostPorts);
            }
            this.hostPorts = cluster.determineEndpoints(this.endpointType).stream().map(Node.Endpoint::getHostPort).collect(Collectors.toList());
        }
    }

    private static abstract class AbstractConnectionSource
    extends ConnectionSource {
        private static final Logger LOGGER = LoggerFactory.getLogger(AbstractConnectionSource.class);
        private final HostPortSet currentServers;
        private final String clusterTierManager;

        public AbstractConnectionSource(Iterable<InetSocketAddress> servers, String clusterTierManager) {
            this.currentServers = new HostPortSet(servers);
            this.clusterTierManager = Objects.requireNonNull(clusterTierManager, "Cluster tier manager identifier cannot be null");
        }

        @Override
        public final String getClusterTierManager() {
            return this.clusterTierManager;
        }

        @Override
        public final LeasedConnection connect(Properties connectionProperties) throws ConnectionException {
            final LeasedConnection connection = LeasedConnectionFactory.connect(this.currentServers, connectionProperties);
            try {
                EntityRef ref = connection.getEntityRef(DynamicTopologyEntity.class, 1L, "dynamic-config-topology-entity");
                final DynamicTopologyEntity dynamicTopologyEntity = ref.fetchEntity(null);
                try {
                    this.currentServers.refresh(dynamicTopologyEntity.getUpcomingCluster());
                }
                catch (InterruptedException | TimeoutException e) {
                    LOGGER.warn("Failed to populate connection with cluster topology - passive failover may fail", (Throwable)e);
                }
                dynamicTopologyEntity.setListener(new DynamicTopologyEntity.Listener(){

                    @Override
                    public void onNodeRemoval(Cluster cluster, UID stripeUID, Node removedNode) {
                        currentServers.refresh(cluster);
                    }

                    @Override
                    public void onNodeAddition(Cluster cluster, UID addedNodeUID) {
                        currentServers.refresh(cluster);
                    }
                });
                return new LeasedConnection(){

                    @Override
                    public <T extends Entity, C, U> EntityRef<T, C, U> getEntityRef(Class<T> cls, long version, String name) throws EntityNotProvidedException {
                        return connection.getEntityRef(cls, version, name);
                    }

                    @Override
                    public void close() throws IOException {
                        Future<Void> close = dynamicTopologyEntity.releaseEntity();
                        try {
                            close.get(10L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        catch (ExecutionException e) {
                            throw new IOException(e.getCause());
                        }
                        catch (TimeoutException timeoutException) {
                        }
                        finally {
                            connection.close();
                        }
                    }

                    @Override
                    public boolean isValid() {
                        return connection.isValid();
                    }
                };
            }
            catch (EntityNotFoundException | EntityNotProvidedException | EntityVersionMismatchException e) {
                throw new AssertionError((Object)e);
            }
        }

        public final Iterable<InetSocketAddress> getServers() {
            return this.currentServers;
        }
    }

    public static class ServerList
    extends AbstractConnectionSource {
        public ServerList(Iterable<InetSocketAddress> servers, String clusterTierManager) {
            super(servers, clusterTierManager);
        }

        @Override
        public URI getClusterUri() {
            throw new IllegalStateException("Cannot use getClusterUri() on ConnectionSource.ServerList. Use getServers() instead.");
        }

        public String toString() {
            return "servers: " + String.valueOf(this.getServers()) + " [cache-manager: " + this.getClusterTierManager() + "]";
        }
    }

    public static class ClusterUri
    extends ConnectionSource {
        private final URI clusterUri;
        private final String clusterTierManager;

        public ClusterUri(URI clusterUri) {
            this.clusterUri = Objects.requireNonNull(clusterUri, "Cluster URI cannot be null");
            this.clusterTierManager = ClusterUri.extractCacheManager(clusterUri);
        }

        @Override
        public String getClusterTierManager() {
            return this.clusterTierManager;
        }

        @Override
        public LeasedConnection connect(Properties connectionProperties) throws ConnectionException {
            return LeasedConnectionFactory.connect(ClusterUri.extractClusterUri(this.clusterUri), connectionProperties);
        }

        @Override
        public URI getClusterUri() {
            return this.clusterUri;
        }

        public String toString() {
            return "clusterUri: " + String.valueOf(this.clusterUri);
        }

        private static String extractCacheManager(URI uri) {
            URI baseUri = ClusterUri.extractClusterUri(uri);
            return baseUri.relativize(uri).getPath();
        }

        private static URI extractClusterUri(URI uri) {
            try {
                return new URI(uri.getScheme(), uri.getAuthority(), null, null, null);
            }
            catch (URISyntaxException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

