/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.config;

import java.net.InetSocketAddress;
import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import java.util.Properties;
import org.ehcache.CacheManager;
import org.ehcache.PersistentCacheManager;
import org.ehcache.clustered.client.config.Timeouts;
import org.ehcache.clustered.client.config.builders.ClusteringServiceConfigurationBuilder;
import org.ehcache.clustered.client.internal.ConnectionSource;
import org.ehcache.clustered.client.service.ClusteringService;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.CacheManagerConfiguration;
import org.ehcache.core.HumanReadable;
import org.ehcache.spi.service.ServiceCreationConfiguration;

public class ClusteringServiceConfiguration
implements ServiceCreationConfiguration<ClusteringService, ClusteringServiceConfigurationBuilder>,
CacheManagerConfiguration<PersistentCacheManager>,
HumanReadable {
    public static final ClientMode DEFAULT_CLIENT_MODE = ClientMode.CONNECT;
    @Deprecated
    public static final boolean DEFAULT_AUTOCREATE = DEFAULT_CLIENT_MODE.equals((Object)ClientMode.AUTO_CREATE);
    private final ConnectionSource connectionSource;
    private final ClientMode clientMode;
    private final ServerSideConfiguration serverConfiguration;
    private final Timeouts timeouts;
    private final Properties properties;

    @Deprecated
    public ClusteringServiceConfiguration(URI clusterUri) {
        this(clusterUri, Timeouts.DEFAULT);
    }

    @Deprecated
    public ClusteringServiceConfiguration(Iterable<InetSocketAddress> servers, String clusterTierManager) {
        this(servers, clusterTierManager, Timeouts.DEFAULT);
    }

    @Deprecated
    public ClusteringServiceConfiguration(URI clusterUri, Timeouts timeouts) {
        this(clusterUri, timeouts, null);
    }

    @Deprecated
    public ClusteringServiceConfiguration(Iterable<InetSocketAddress> servers, String clusterTierManager, Timeouts timeouts) {
        this(servers, clusterTierManager, timeouts, null);
    }

    @Deprecated
    public ClusteringServiceConfiguration(URI clusterUri, ServerSideConfiguration serverConfig) {
        this(clusterUri, Timeouts.DEFAULT, serverConfig);
    }

    @Deprecated
    public ClusteringServiceConfiguration(URI clusterUri, Timeouts timeouts, ServerSideConfiguration serverConfig) {
        this(clusterUri, timeouts, DEFAULT_AUTOCREATE, serverConfig);
    }

    @Deprecated
    public ClusteringServiceConfiguration(Iterable<InetSocketAddress> servers, String clusterTierManager, Timeouts timeouts, ServerSideConfiguration serverConfig) {
        this(servers, clusterTierManager, timeouts, DEFAULT_AUTOCREATE, serverConfig);
    }

    @Deprecated
    public ClusteringServiceConfiguration(URI clusterUri, boolean autoCreate, ServerSideConfiguration serverConfig) {
        this(clusterUri, Timeouts.DEFAULT, autoCreate, serverConfig);
    }

    @Deprecated
    public ClusteringServiceConfiguration(Iterable<InetSocketAddress> servers, String clusterTierManager, boolean autoCreate, ServerSideConfiguration serverConfig) {
        this(servers, clusterTierManager, Timeouts.DEFAULT, autoCreate, serverConfig);
    }

    @Deprecated
    public ClusteringServiceConfiguration(URI clusterUri, Timeouts timeouts, boolean autoCreate, ServerSideConfiguration serverConfig) {
        this(clusterUri, timeouts, autoCreate, serverConfig, new Properties());
    }

    @Deprecated
    public ClusteringServiceConfiguration(Iterable<InetSocketAddress> servers, String clusterTierManager, Timeouts timeouts, boolean autoCreate, ServerSideConfiguration serverConfig) {
        this(servers, clusterTierManager, timeouts, autoCreate, serverConfig, new Properties());
    }

    @Deprecated
    public ClusteringServiceConfiguration(URI clusterUri, Timeouts timeouts, boolean autoCreate, ServerSideConfiguration serverConfig, Properties properties) {
        this((ConnectionSource)new ConnectionSource.ClusterUri(clusterUri), timeouts, autoCreate, serverConfig, properties);
    }

    @Deprecated
    public ClusteringServiceConfiguration(Iterable<InetSocketAddress> servers, String clusterTierManager, Timeouts timeouts, boolean autoCreate, ServerSideConfiguration serverConfig, Properties properties) {
        this((ConnectionSource)new ConnectionSource.ServerList(servers, clusterTierManager), timeouts, autoCreate, serverConfig, properties);
    }

    @Deprecated
    public ClusteringServiceConfiguration(ConnectionSource connectionSource, Timeouts timeouts, boolean autoCreate, ServerSideConfiguration serverSideConfiguration, Properties properties) {
        this(connectionSource, timeouts, autoCreate ? ClientMode.AUTO_CREATE : (serverSideConfiguration == null ? ClientMode.CONNECT : ClientMode.EXPECTING), serverSideConfiguration, properties);
    }

    public ClusteringServiceConfiguration(ConnectionSource connectionSource, Timeouts timeouts, ClientMode clientMode, ServerSideConfiguration serverSideConfiguration, Properties properties) {
        this.connectionSource = Objects.requireNonNull(connectionSource);
        this.clientMode = Objects.requireNonNull(clientMode);
        this.serverConfiguration = serverSideConfiguration;
        this.timeouts = Objects.requireNonNull(timeouts, "Operation timeouts cannot be null");
        this.properties = (Properties)Objects.requireNonNull(properties, "Properties cannot be null").clone();
    }

    protected ClusteringServiceConfiguration(ClusteringServiceConfiguration baseConfig) {
        Objects.requireNonNull(baseConfig, "Base configuration cannot be null");
        this.connectionSource = baseConfig.getConnectionSource();
        this.timeouts = baseConfig.getTimeouts();
        this.clientMode = baseConfig.getClientMode();
        this.serverConfiguration = baseConfig.getServerConfiguration();
        this.properties = baseConfig.getProperties();
    }

    public URI getClusterUri() {
        return this.connectionSource.getClusterUri();
    }

    public ConnectionSource getConnectionSource() {
        return this.connectionSource;
    }

    @Deprecated
    public boolean isAutoCreate() {
        ClientMode clientMode = this.getClientMode();
        return ClientMode.AUTO_CREATE.equals((Object)clientMode) || ClientMode.AUTO_CREATE_ON_RECONNECT.equals((Object)clientMode);
    }

    public ClientMode getClientMode() {
        return this.clientMode;
    }

    public ServerSideConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public Properties getProperties() {
        return (Properties)this.properties.clone();
    }

    @Deprecated
    public Duration getReadOperationTimeout() {
        return this.timeouts.getReadOperationTimeout();
    }

    public Class<ClusteringService> getServiceType() {
        return ClusteringService.class;
    }

    public CacheManagerBuilder<PersistentCacheManager> builder(CacheManagerBuilder<? extends CacheManager> other) {
        return other.using((ServiceCreationConfiguration)this);
    }

    public String readableString() {
        return this.getClass().getName() + ":\n    " + String.valueOf(this.getConnectionSource()) + "\n    timeouts: " + String.valueOf(this.getTimeouts()) + "\n    clientMode: " + String.valueOf((Object)this.getClientMode()) + "\n    defaultServerResource: " + (this.serverConfiguration == null ? null : this.serverConfiguration.getDefaultServerResource()) + "\n    " + this.readablePoolsString();
    }

    private String readablePoolsString() {
        StringBuilder pools = new StringBuilder("resourcePools:\n");
        if (this.serverConfiguration != null) {
            this.serverConfiguration.getResourcePools().forEach((key, value) -> {
                pools.append("        ");
                pools.append((String)key);
                pools.append(": ");
                pools.append(value);
                pools.append("\n");
            });
        } else {
            pools.append("        None.");
        }
        return pools.toString();
    }

    public ClusteringServiceConfigurationBuilder derive() {
        return ClusteringServiceConfigurationBuilder.seededFrom(this);
    }

    public ClusteringServiceConfiguration build(ClusteringServiceConfigurationBuilder representation) {
        return representation.build();
    }

    public static enum ClientMode {
        CONNECT,
        EXPECTING,
        AUTO_CREATE,
        AUTO_CREATE_ON_RECONNECT;

    }
}

