/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.connection;

import com.tc.object.ClientEntityManager;
import com.tc.text.MapListPrettyPrint;
import com.tc.text.PrettyPrintable;
import com.terracotta.connection.EndpointConnectorImpl;
import com.terracotta.connection.EntityClientServiceFactory;
import com.terracotta.connection.entity.TerracottaEntityRef;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.terracotta.connection.Connection;
import org.terracotta.connection.entity.Entity;
import org.terracotta.connection.entity.EntityRef;
import org.terracotta.entity.EndpointConnector;
import org.terracotta.entity.EntityClientService;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityResponse;
import org.terracotta.exception.ConnectionClosedException;
import org.terracotta.exception.ConnectionShutdownException;
import org.terracotta.exception.EntityNotProvidedException;

public class TerracottaConnection
implements Connection,
PrettyPrintable {
    private final Supplier<ClientEntityManager> entityManager;
    private final EntityClientServiceFactory factory = new EntityClientServiceFactory();
    private final EndpointConnector endpointConnector;
    private final Runnable shutdown;
    private final ConcurrentMap<Class<? extends Entity>, EntityClientService<?, ?, ? extends EntityMessage, ? extends EntityResponse, ?>> cachedEntityServices = new ConcurrentHashMap();
    private final AtomicLong clientIds = new AtomicLong(1L);
    private final Properties connectionPropertiesForReporting;
    private boolean isShutdown = false;

    public TerracottaConnection(Properties props, Supplier<ClientEntityManager> entityManager, Runnable shutdown) {
        this(props, entityManager, new EndpointConnectorImpl(), shutdown);
    }

    public TerracottaConnection(Properties props, Supplier<ClientEntityManager> entityManager, EndpointConnector endpointConnector, Runnable shutdown) {
        this.entityManager = entityManager;
        this.endpointConnector = endpointConnector;
        this.shutdown = shutdown;
        this.connectionPropertiesForReporting = props;
    }

    @Override
    public synchronized <T extends Entity, C, U> EntityRef<T, C, U> getEntityRef(Class<T> cls, long version, String name) throws EntityNotProvidedException {
        if (this.isShutdown) {
            throw new ConnectionShutdownException("Already shut down");
        }
        EntityClientService<T, ?, EntityMessage, EntityResponse, U> service = this.getEntityService(cls);
        if (null == service) {
            throw new EntityNotProvidedException(cls.getName(), name);
        }
        return new TerracottaEntityRef(this.entityManager, this.endpointConnector, cls, version, name, service, this.clientIds);
    }

    private <T extends Entity, U> EntityClientService<T, ?, ? extends EntityMessage, ? extends EntityResponse, U> getEntityService(Class<T> entityClass) {
        EntityClientService service = (EntityClientService)this.cachedEntityServices.get(entityClass);
        if (service == null && null != (service = this.factory.creationServiceForType(entityClass))) {
            EntityClientService tmp = this.cachedEntityServices.putIfAbsent(entityClass, service);
            service = tmp == null ? service : tmp;
        }
        return service;
    }

    @Override
    public synchronized void close() {
        if (!this.isShutdown) {
            this.shutdown.run();
            this.isShutdown = true;
        }
    }

    @Override
    public boolean isValid() {
        try {
            return this.entityManager.get().isValid();
        }
        catch (ConnectionClosedException c) {
            return false;
        }
    }

    @Override
    public Map<String, ?> getStateMap() {
        LinkedHashMap state = new LinkedHashMap();
        state.put("props", this.connectionPropertiesForReporting);
        try {
            state.put("stats", this.entityManager.get().getStateMap());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return state;
    }

    public String toString() {
        MapListPrettyPrint print = new MapListPrettyPrint();
        this.prettyPrint(print);
        return "TerracottaConnection{" + String.valueOf(print) + "}";
    }
}

