/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util.concurrent;

import com.tc.util.Assert;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrottledTaskExecutor {
    private final ConcurrentLinkedQueue<Task> scheduledTasks;
    private final Semaphore semaphore;
    private final AtomicLong sequenceID;
    private static final Logger logger = LoggerFactory.getLogger(ThrottledTaskExecutor.class);

    public ThrottledTaskExecutor(int maxOutstandingTasks) {
        Assert.eval(maxOutstandingTasks > 0);
        this.semaphore = new Semaphore(maxOutstandingTasks);
        this.scheduledTasks = new ConcurrentLinkedQueue();
        this.sequenceID = new AtomicLong(0L);
    }

    public long offer(Runnable task) {
        Task newTask = new Task(this.sequenceID.incrementAndGet(), task);
        return this.offer(newTask);
    }

    private long offer(Task newTask) {
        this.scheduledTasks.add(newTask);
        if (this.semaphore.tryAcquire() && this.runTasks()) {
            return newTask.getId();
        }
        if (logger.isDebugEnabled()) {
            this.debugLog("Scheduling : " + String.valueOf(newTask));
        }
        return newTask.scheduled();
    }

    private boolean runTasks() {
        Task t = this.scheduledTasks.poll();
        if (t != null) {
            if (logger.isDebugEnabled()) {
                this.debugLog("Running : " + String.valueOf(t));
            }
            this.execute(t);
            return true;
        }
        this.semaphore.release();
        return false;
    }

    private long execute(Task task) {
        return task.execute();
    }

    public void receiveFeedback() {
        this.runTasks();
    }

    synchronized int getScheduledTasksCount() {
        return this.scheduledTasks.size();
    }

    private void debugLog(String message) {
        if (logger.isDebugEnabled()) {
            logger.debug(message);
        }
    }

    private static class Task {
        private final long SCHEDULED_TASK_ID = -1L;
        private final long id;
        private final Runnable task;

        public Task(long id, Runnable task) {
            this.id = id;
            this.task = task;
        }

        public long scheduled() {
            return -1L;
        }

        public long execute() {
            this.task.run();
            return this.id;
        }

        public long getId() {
            return this.id;
        }

        public String toString() {
            return "Task  - id: " + this.id;
        }
    }
}

