/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

public class ClassUtils {
    public static int arrayDimensions(Class<?> arrayClass) {
        ClassUtils.verifyIsArray(arrayClass);
        return arrayClass.getName().lastIndexOf("[") + 1;
    }

    public static Class<?> baseComponentType(Class<?> c) {
        ClassUtils.verifyIsArray(c);
        while (c.isArray()) {
            c = c.getComponentType();
        }
        return c;
    }

    private static void verifyIsArray(Class<?> arrayClass) {
        if (arrayClass == null) {
            throw new NullPointerException();
        }
        if (!arrayClass.isArray()) {
            throw new IllegalArgumentException(String.valueOf(arrayClass) + " is not an array type");
        }
    }

    public static boolean isPrimitiveArray(Object test) {
        if (test == null) {
            return false;
        }
        Class<?> c = test.getClass();
        if (!c.isArray()) {
            return false;
        }
        return c.getComponentType().isPrimitive();
    }

    public static boolean isDsoEnum(Class<?> c) {
        while (c.getSuperclass() != null) {
            if (c.isEnum()) {
                return true;
            }
            c = c.getSuperclass();
        }
        return false;
    }
}

