/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.tcm;

import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCReference;
import com.tc.io.TCByteBufferInputStream;
import com.tc.net.protocol.TCNetworkMessage;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.TCAction;
import com.tc.net.protocol.tcm.TCMessageFactory;
import com.tc.net.protocol.tcm.TCMessageHeaderImpl;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.util.HexDump;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TCMessageParser {
    private static final Logger logger = LoggerFactory.getLogger(TCMessageParser.class);
    private final TCMessageFactory factory;

    TCMessageParser(TCMessageFactory factory) {
        this.factory = factory;
    }

    TCAction parseMessage(MessageChannel source, TCNetworkMessage msg) {
        TCByteBufferInputStream helper = new TCByteBufferInputStream(msg.getPayload());
        TCByteBuffer header = helper.read(8);
        TCMessageHeaderImpl hdr = new TCMessageHeaderImpl(header);
        int headerLength = hdr.getHeaderByteLength();
        if (headerLength != 8) {
            logger.error("Invalid header length ! length = " + headerLength);
            logger.error("error header = " + String.valueOf(hdr));
            logger.error(" buffer data is " + this.toString(msg.getPayload()));
            throw new RuntimeException("Invalid header length: " + headerLength);
        }
        int msgType = hdr.getMessageType();
        TCMessageType type = TCMessageType.getInstance(hdr.getMessageType());
        if (type == null) {
            throw new RuntimeException("Can't find message type for type: " + msgType);
        }
        TCAction converted = this.factory.createMessage(source, type, hdr, helper);
        return converted;
    }

    private String toString(TCReference data) {
        if (data == null || !data.iterator().hasNext()) {
            return "null or size 0";
        }
        StringBuffer sb = new StringBuffer();
        for (TCByteBuffer buf : data) {
            sb.append(buf);
            sb.append(" { ");
            byte[] read = new byte[buf.remaining()];
            buf.duplicate().get(read);
            HexDump.dump(read);
            sb.append(" } ");
        }
        return sb.toString();
    }
}

