/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.core;

import com.tc.logging.LossyTCLogger;
import com.tc.net.core.CoreNIOServices;
import com.tc.net.core.SocketParams;
import com.tc.util.Assert;
import com.tc.util.concurrent.SetOnceFlag;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCWorkerCommManager {
    private static final Logger logger = LoggerFactory.getLogger(TCWorkerCommManager.class);
    private static final LossyTCLogger lossyLogger = new LossyTCLogger(logger, 10L, LossyTCLogger.LossyTCLoggerType.COUNT_BASED, false);
    private static final String WORKER_NAME_PREFIX = "TCWorkerComm # ";
    private final int totalWorkerComm;
    private final CoreNIOServices[] workerCommThreads;
    private final SetOnceFlag started = new SetOnceFlag();
    private final SetOnceFlag stopped = new SetOnceFlag();
    private boolean paused = false;

    TCWorkerCommManager(String name, int workerCommCount, SocketParams socketParams) {
        if (workerCommCount <= 0) {
            throw new IllegalArgumentException("invalid worker count: " + workerCommCount);
        }
        logger.info("Creating " + workerCommCount + " worker comm threads for " + name);
        this.totalWorkerComm = workerCommCount;
        this.workerCommThreads = new CoreNIOServices[workerCommCount];
        for (int i = 0; i < this.workerCommThreads.length; ++i) {
            this.workerCommThreads[i] = new CoreNIOServices(name + " - TCWorkerComm # " + i, this, socketParams);
        }
    }

    public CoreNIOServices getNextWorkerComm() {
        CoreNIOServices leastWeightWorkerComm = null;
        while (leastWeightWorkerComm == null) {
            leastWeightWorkerComm = this.getLeastWeightWorkerComm();
        }
        Assert.assertTrue(null != leastWeightWorkerComm);
        String message = "Selecting " + String.valueOf(leastWeightWorkerComm) + "  from " + String.valueOf(Arrays.asList(this.workerCommThreads));
        if (logger.isDebugEnabled()) {
            logger.debug(message);
        }
        return leastWeightWorkerComm;
    }

    private CoreNIOServices getLeastWeightWorkerComm() {
        CoreNIOServices selectedWorkerComm = null;
        for (CoreNIOServices workerComm : this.workerCommThreads) {
            if (!workerComm.compareWeights(selectedWorkerComm)) continue;
            selectedWorkerComm = workerComm;
        }
        return selectedWorkerComm;
    }

    public synchronized void start() {
        if (this.started.attemptSet()) {
            for (CoreNIOServices workerCommThread : this.workerCommThreads) {
                workerCommThread.start();
            }
        } else {
            throw new IllegalStateException("already started");
        }
    }

    public synchronized void stop() {
        if (!this.started.isSet()) {
            return;
        }
        if (this.stopped.attemptSet()) {
            for (int i = 0; i < this.totalWorkerComm; ++i) {
                this.workerCommThreads[i].requestStop();
            }
        }
    }

    protected CoreNIOServices getWorkerComm(int workerCommId) {
        return this.workerCommThreads[workerCommId];
    }

    protected int getWeightForWorkerComm(int workerCommId) {
        return this.workerCommThreads[workerCommId].getWeight();
    }

    protected long getTotalBytesReadByWorkerComm(int workerCommId) {
        return this.workerCommThreads[workerCommId].getTotalBytesRead();
    }

    protected long getTotalBytesWrittenByWorkerComm(int workerCommId) {
        return this.workerCommThreads[workerCommId].getTotalBytesWritten();
    }

    public List<?> getState() {
        return Arrays.stream(this.workerCommThreads).map(s -> s.getState()).collect(Collectors.toList());
    }

    synchronized void waitDuringPause() throws IOException {
        while (this.paused) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                throw new InterruptedIOException();
            }
        }
    }

    public boolean isOverweight(int weight) {
        if (weight <= this.totalWorkerComm) {
            return false;
        }
        for (CoreNIOServices c : this.workerCommThreads) {
            if (c.getWeight() * 2 >= weight || c.getCongestionScore() != 0L) continue;
            return true;
        }
        return false;
    }

    public synchronized void pause() {
        this.paused = true;
    }

    public synchronized void unpause() {
        this.paused = false;
        this.notifyAll();
    }
}

