/*
 * Decompiled with CFR 0.152.
 */
package com.tc.management;

import com.tc.management.ManagementResources;
import com.tc.management.beans.L2MBeanNames;
import com.tc.util.Assert;
import com.tc.util.UUID;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;

public abstract class TerracottaManagement {
    private static final ManagementResources MANAGEMENT_RESOURCES = new ManagementResources();
    private static final String COMMA = ",";
    private static final String COLON = ":";
    private static final String EQUALS = "=";
    private static final String UNDERSCORE = "_";
    private static final String NODE_PREFIX_KEY = "clients";
    private static final String NODE_PREFIX = "clients=Clients";

    public static ObjectName createObjectName(Type type, String uiFriendlyName, MBeanDomain domain) throws MalformedObjectNameException {
        Assert.assertNotNull((Object)domain);
        StringBuffer objName = new StringBuffer(domain.toString());
        objName.append(COLON);
        objName.append("name").append(EQUALS).append(uiFriendlyName);
        if (type != null) {
            objName.append(COMMA).append("type").append(EQUALS).append(type);
        }
        try {
            return new ObjectName(objName.toString());
        }
        catch (MalformedObjectNameException mal) {
            throw new MalformedObjectNameException(objName.toString() + " " + mal.getMessage());
        }
    }

    private static void addNodeInfo(StringBuffer objName, InetSocketAddress addr) {
        objName.append(COMMA).append("node").append(EQUALS).append(TerracottaManagement.buildNodeId(addr));
    }

    public static String buildNodeId(InetSocketAddress addr) {
        String remoteHost = addr.getAddress().getCanonicalHostName();
        int remotePort = addr.getPort();
        return remoteHost + UNDERSCORE + remotePort;
    }

    public static ObjectName addNodeInfo(ObjectName objName, InetSocketAddress addr) throws MalformedObjectNameException {
        if (objName.getKeyProperty("node") != null) {
            Hashtable<String, String> kpl = objName.getKeyPropertyList();
            kpl.remove("node");
            objName = ObjectName.getInstance(objName.getDomain(), kpl);
        }
        StringBuffer sb = new StringBuffer(objName.getCanonicalName());
        if (objName.getKeyProperty(NODE_PREFIX_KEY) == null) {
            sb.append(COMMA).append(NODE_PREFIX);
        }
        TerracottaManagement.addNodeInfo(sb, addr);
        return new ObjectName(sb.toString());
    }

    private static void addNodeInfo(StringBuffer objName, UUID id) {
        objName.append(COMMA).append("node").append(EQUALS).append(id);
    }

    public static ObjectName addNodeInfo(ObjectName objName, UUID id) throws MalformedObjectNameException {
        if (objName.getKeyProperty("node") != null) {
            Hashtable<String, String> kpl = objName.getKeyPropertyList();
            kpl.remove("node");
            objName = ObjectName.getInstance(objName.getDomain(), kpl);
        }
        StringBuffer sb = new StringBuffer(objName.getCanonicalName());
        if (objName.getKeyProperty(NODE_PREFIX_KEY) == null) {
            sb.append(COMMA).append(NODE_PREFIX);
        }
        TerracottaManagement.addNodeInfo(sb, id);
        return new ObjectName(sb.toString());
    }

    public abstract Object findMBean(ObjectName var1, Class<?> var2) throws Exception;

    public static final Object findMBean(ObjectName objectName, Class<?> mBeanInterface, MBeanServerConnection mBeanServer) throws IOException {
        Set<ObjectInstance> matchingBeans = mBeanServer.queryMBeans(objectName, null);
        Iterator<ObjectInstance> beanPos = matchingBeans.iterator();
        if (beanPos.hasNext()) {
            return MBeanServerInvocationHandler.newProxyInstance(mBeanServer, objectName, mBeanInterface, false);
        }
        return null;
    }

    public static final QueryExp matchAllTerracottaMBeans(UUID id) {
        try {
            ObjectName query = new ObjectName(String.valueOf((Object)MBeanDomain.PUBLIC) + ":*,node=" + String.valueOf(id));
            return query;
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public static final String quoteIfNecessary(String objectNamePart) {
        if (objectNamePart.matches("[,=:*?\"']")) {
            return ObjectName.quote(objectNamePart);
        }
        return objectNamePart;
    }

    public static final Set<ObjectName> getAllL2DumperMBeans(MBeanServerConnection mbs) throws MalformedObjectNameException, NullPointerException, IOException {
        return mbs.queryNames(new ObjectName(L2MBeanNames.DUMPER.getCanonicalName() + ",*"), null);
    }

    public static enum MBeanDomain {
        PUBLIC(MANAGEMENT_RESOURCES.getPublicMBeanDomain());

        private final String value;

        private MBeanDomain(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static interface MBeanKeys {
        public static final String TYPE = "type";
        public static final String MBEAN_NODE = "node";
        public static final String MBEAN_NODE_NAME = "node-name";
        public static final String SUBSYSTEM = "subsystem";
        public static final String NAME = "name";
    }

    public static class Subsystem {
        private static final Map<String, Subsystem> subsystemByName = Collections.synchronizedMap(new HashMap());
        public static final Subsystem Logging = new Subsystem(MANAGEMENT_RESOURCES.getLoggingSubsystem());
        public static final Subsystem Statistics = new Subsystem(MANAGEMENT_RESOURCES.getStatisticsSubsystem());
        public static final Subsystem None = new Subsystem(MANAGEMENT_RESOURCES.getNoneSubsystem());
        private final String subsystem;

        private Subsystem(String subsystem) {
            this.subsystem = subsystem;
            subsystemByName.put(subsystem, this);
        }

        public String toString() {
            return this.subsystem;
        }

        static Subsystem getSubsystem(String name) {
            return subsystemByName.get(name);
        }
    }

    public static class Type {
        private static final Map<String, Type> typesByName = Collections.synchronizedMap(new HashMap());
        public static final Type Client = new Type(MANAGEMENT_RESOURCES.getDsoClientType());
        public static final Type Server = new Type(MANAGEMENT_RESOURCES.getTerracottaServerType());
        private final String type;

        private Type(String type) {
            this.type = type;
            typesByName.put(type, this);
        }

        public String toString() {
            return this.type;
        }

        static Type getType(String name) {
            return typesByName.get(name);
        }
    }
}

