/*
 * Decompiled with CFR 0.152.
 */
package com.tc.io;

import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCByteBufferFactory;
import com.tc.bytes.TCReference;
import com.tc.bytes.TCReferenceSupport;
import com.tc.io.TCByteBufferInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.util.Iterator;

public class TCByteBufferInputStream
extends InputStream
implements TCByteBufferInput {
    private static final int EOF = -1;
    private final Runnable onCloseHook;
    private final TCReference data;
    private final Iterator<TCByteBuffer> list;
    private TCByteBuffer current;
    private long totalLength;
    private boolean closed = false;

    public TCByteBufferInputStream(TCByteBuffer data) {
        this(new TCByteBuffer[]{data});
    }

    public TCByteBufferInputStream(TCReference data) {
        if (data == null) {
            throw new NullPointerException();
        }
        this.data = data.duplicate();
        this.list = this.data.iterator();
        this.current = this.list.hasNext() ? this.list.next() : TCByteBufferFactory.getInstance(0);
        this.totalLength = this.data.available();
        this.onCloseHook = this.data::close;
    }

    public TCByteBufferInputStream(TCByteBuffer[] data) {
        this(TCReferenceSupport.createGCReference(data));
    }

    @Override
    public TCByteBufferInput duplicate() {
        this.checkClosed();
        return new TCByteBufferInputStream(this.data);
    }

    @Override
    public int getTotalLength() {
        return Math.toIntExact(this.totalLength);
    }

    @Override
    public int available() {
        return Math.toIntExact(this.data.available());
    }

    @Override
    public long length() {
        return this.totalLength;
    }

    @Override
    public long remaining() {
        return this.data.available();
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.onCloseHook.run();
        }
    }

    @Override
    public final int read(byte[] b, int off, int len) {
        this.checkClosed();
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        long remaining = this.data.available();
        if (remaining == 0L) {
            return -1;
        }
        int bytesRead = 0;
        int numToRead = remaining > Integer.MAX_VALUE ? len : Math.min((int)remaining, len);
        TCByteBuffer src = this.nextBuffer();
        while (src.hasRemaining()) {
            int read = Math.min(src.remaining(), numToRead);
            src.get(b, off, read);
            off += read;
            bytesRead += read;
            if ((numToRead -= read) == 0) break;
            src = this.nextBuffer();
        }
        return bytesRead;
    }

    @Override
    public final int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    @Override
    public final TCByteBuffer read(int len) {
        this.checkClosed();
        if (len == 0) {
            return TCByteBufferFactory.getInstance(0);
        }
        if (!this.data.hasRemaining()) {
            return TCByteBufferFactory.getInstance(0);
        }
        TCByteBuffer result = TCByteBufferFactory.getInstance(len);
        TCByteBuffer src = this.nextBuffer();
        while (result.hasRemaining()) {
            int limit = src.limit();
            src.limit(Math.min(src.position() + result.remaining(), limit));
            result.put(src);
            src.limit(limit);
            src = this.nextBuffer();
        }
        if (result.hasRemaining()) {
            throw new BufferUnderflowException();
        }
        return result.flip();
    }

    @Override
    public final TCReference readReference(int len) {
        this.checkClosed();
        if (len == 0) {
            return TCReferenceSupport.createGCReference(TCByteBufferFactory.getInstance(0));
        }
        TCReference dup = this.data.duplicate(len);
        long run = dup.available();
        this.skip(run);
        if (run != (long)len) {
            throw new BufferUnderflowException();
        }
        return dup;
    }

    @Override
    public final int read() {
        this.checkClosed();
        TCByteBuffer src = this.nextBuffer();
        while (src.hasRemaining()) {
            if (src.hasRemaining()) {
                return src.get() & 0xFF;
            }
            src = this.nextBuffer();
        }
        return -1;
    }

    private TCByteBuffer nextBuffer() {
        if (!this.current.hasRemaining() && this.list.hasNext()) {
            this.current = this.list.next();
        }
        return this.current;
    }

    @Override
    public long skip(long skip) {
        this.checkClosed();
        long available = this.data.available();
        if (skip <= 0L || available == 0L) {
            return 0L;
        }
        long numToSkip = Math.min(available, skip);
        long bytesSkipped = 0L;
        TCByteBuffer src = this.nextBuffer();
        while (src.hasRemaining()) {
            int remaining = src.remaining();
            if (remaining > 0) {
                int numToRead = numToSkip > Integer.MAX_VALUE ? remaining : Math.min(remaining, (int)numToSkip);
                src.position(src.position() + numToRead);
                bytesSkipped += (long)numToRead;
                if ((numToSkip -= (long)numToRead) == 0L) break;
            }
            src = this.nextBuffer();
        }
        return bytesSkipped;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("stream is closed");
        }
    }

    @Override
    public final int readInt() throws IOException {
        int byte4;
        int byte3;
        int byte2;
        int byte1 = this.read();
        if ((byte1 | (byte2 = this.read()) | (byte3 = this.read()) | (byte4 = this.read())) < 0) {
            throw new EOFException();
        }
        return (byte1 << 24) + (byte2 << 16) + (byte3 << 8) + byte4;
    }

    @Override
    public final byte readByte() throws IOException {
        int b = this.read();
        if (b < 0) {
            throw new EOFException();
        }
        return (byte)b;
    }

    @Override
    public final boolean readBoolean() throws IOException {
        int b = this.read();
        if (b < 0) {
            throw new EOFException();
        }
        return b != 0;
    }

    @Override
    public final char readChar() throws IOException {
        int byte2;
        int byte1 = this.read();
        if ((byte1 | (byte2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((byte1 << 8) + byte2);
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final long readLong() throws IOException {
        int byte8;
        int byte7;
        int byte6;
        int byte5;
        int byte4;
        int byte3;
        int byte2;
        int byte1 = this.read();
        if ((byte1 | (byte2 = this.read()) | (byte3 = this.read()) | (byte4 = this.read()) | (byte5 = this.read()) | (byte6 = this.read()) | (byte7 = this.read()) | (byte8 = this.read())) < 0) {
            throw new EOFException();
        }
        return ((long)byte1 << 56) + ((long)(byte2 & 0xFF) << 48) + ((long)(byte3 & 0xFF) << 40) + ((long)(byte4 & 0xFF) << 32) + ((long)(byte5 & 0xFF) << 24) + (long)((byte6 & 0xFF) << 16) + (long)((byte7 & 0xFF) << 8) + (long)(byte8 & 0xFF);
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final short readShort() throws IOException {
        int byte2;
        int byte1 = this.read();
        if ((byte1 | (byte2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((byte1 << 8) + byte2);
    }

    @Override
    public final String readString() throws IOException {
        boolean isNull = this.readBoolean();
        if (isNull) {
            return null;
        }
        int utf = this.read();
        if (utf < 0) {
            throw new EOFException();
        }
        switch (utf) {
            case 0: {
                return this.readStringFromChars();
            }
            case 1: {
                return DataInputStream.readUTF(this);
            }
        }
        throw new AssertionError((Object)("utf = " + utf));
    }

    private String readStringFromChars() throws IOException {
        int len = this.readInt();
        if (len == 0) {
            return "";
        }
        char[] chars = new char[len];
        int n = chars.length;
        for (int i = 0; i < n; ++i) {
            chars[i] = this.readChar();
        }
        return new String(chars);
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = this.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    @Override
    public final int skipBytes(int n) {
        return Math.toIntExact(this.skip(n));
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        int b = this.read();
        if (b < 0) {
            throw new EOFException();
        }
        return b;
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        int byte2;
        int byte1 = this.read();
        if ((byte1 | (byte2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (byte1 << 8) + byte2;
    }

    @Override
    public final String readLine() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final String readUTF() throws IOException {
        return this.readString();
    }
}

