/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.store;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.function.Predicate;
import org.ehcache.clustered.common.internal.util.ByteBufferInputStream;
import org.ehcache.shadow.org.terracotta.utilities.classloading.FilteredObjectInputStream;

public class Util {
    public static Object unmarshall(ByteBuffer payload, Predicate<Class<?>> isClassPermitted) {
        Object object;
        FilteredObjectInputStream objectInputStream = new FilteredObjectInputStream(new ByteBufferInputStream(payload), isClassPermitted, null);
        try {
            object = objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    objectInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        objectInputStream.close();
        return object;
    }

    public static byte[] marshall(Object message) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ObjectOutputStream oout = new ObjectOutputStream(out);){
            oout.writeObject(message);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return out.toByteArray();
    }
}

