/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.dup;

import com.tc.io.InputWrapper;
import com.tc.io.OutputWrapper;
import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferInputStream;
import com.tc.io.TCByteBufferOutput;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.l2.msg.IBatchableGroupMessage;
import com.tc.l2.msg.ReplicationMessage;
import com.tc.net.ServerID;
import com.tc.net.groups.AbstractGroupMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class RelayMessage
extends AbstractGroupMessage
implements IBatchableGroupMessage<ReplicationMessage> {
    public static final int START_SYNC = 1;
    public static final int RELAY_BATCH = 2;
    public static final int RELAY_RESUME = 4;
    public static final int RELAY_INVALID = 8;
    public static final int RELAY_SUCCESS = 16;
    private Collection<ReplicationMessage> payloadMessages;
    private long lastSeen;

    public RelayMessage() {
        super(-1);
    }

    RelayMessage(int type) {
        super(type);
        if (type == 2) {
            this.payloadMessages = new ArrayList<ReplicationMessage>();
        }
    }

    RelayMessage(long lastSeen) {
        super(4);
        this.lastSeen = lastSeen;
    }

    public long getLastSeen() {
        return this.lastSeen;
    }

    @Override
    protected void basicDeserializeFrom(TCByteBufferInput in) throws IOException {
        switch (this.getType()) {
            case 1: 
            case 8: {
                break;
            }
            case 2: {
                this.loadReplicationBatch(in);
                break;
            }
            case 4: {
                this.lastSeen = in.readLong();
            }
        }
    }

    @Override
    protected void basicSerializeTo(TCByteBufferOutput out) {
        switch (this.getType()) {
            case 1: 
            case 8: {
                break;
            }
            case 2: {
                this.createReplicationBatch(out);
                break;
            }
            case 4: {
                out.writeLong(this.lastSeen);
            }
        }
    }

    public static AbstractGroupMessage createStartSync() {
        return new RelayMessage(1);
    }

    public static RelayMessage createRelayBatch() {
        return new RelayMessage(2);
    }

    public static RelayMessage createInvalid() {
        return new RelayMessage(8);
    }

    public static RelayMessage createSuccess() {
        return new RelayMessage(16);
    }

    public static AbstractGroupMessage createResumeMessage(long lastSeen) {
        return new RelayMessage(lastSeen);
    }

    private void createReplicationBatch(TCByteBufferOutput output) {
        try (GZIPOutputStream compress = new GZIPOutputStream(new OutputWrapper(output));
             TCByteBufferOutputStream out = new TCByteBufferOutputStream();){
            for (ReplicationMessage added : this.payloadMessages) {
                added.serializeTo(out);
            }
            try (TCByteBufferInputStream in = new TCByteBufferInputStream(out.accessBuffers());){
                RelayMessage.transfer(in, compress);
            }
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
    }

    public long unwindBatch(Consumer<ReplicationMessage> next) {
        return this.payloadMessages.stream().peek(next).map(ReplicationMessage::getSequenceID).reduce(Long::max).orElse(Long.MIN_VALUE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadReplicationBatch(TCByteBufferInput source) {
        TCByteBufferOutputStream output = new TCByteBufferOutputStream();
        try (GZIPInputStream decompress = new GZIPInputStream(new InputWrapper(source));){
            RelayMessage.transfer(decompress, output);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        output.close();
        this.payloadMessages = new ArrayList<ReplicationMessage>();
        try (TCByteBufferInputStream input = new TCByteBufferInputStream(output.accessBuffers());){
            while (input.available() > 0) {
                ReplicationMessage msg = new ReplicationMessage();
                this.payloadMessages.add(msg);
                try {
                    msg.deserializeFrom(input);
                    msg.setMessageOrginator(ServerID.NULL_ID);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                    return;
                }
            }
        }
    }

    private static long transfer(InputStream in, OutputStream out) throws IOException {
        int read;
        long transferred = 0L;
        byte[] buffer = new byte[1024];
        while ((read = in.read(buffer, 0, buffer.length)) >= 0) {
            out.write(buffer, 0, read);
            transferred += (long)read;
        }
        return transferred;
    }

    @Override
    public void addToBatch(ReplicationMessage element) {
        this.payloadMessages.add(element);
    }

    @Override
    public int getBatchSize() {
        return this.payloadMessages.size();
    }

    @Override
    public long getPayloadSize() {
        return this.payloadMessages.stream().map(ReplicationMessage::getPayloadSize).reduce(Long::sum).orElse(0L);
    }

    @Override
    public void setSequenceID(long rid) {
    }

    @Override
    public long getSequenceID() {
        return this.payloadMessages.stream().findFirst().map(ReplicationMessage::getSequenceID).orElse(0L);
    }

    @Override
    public AbstractGroupMessage asAbstractGroupMessage() {
        return this;
    }
}

