/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.core.ProductID;
import com.tc.net.core.TCConnection;
import com.tc.net.core.event.TCConnectionErrorEvent;
import com.tc.net.core.event.TCConnectionEvent;
import com.tc.net.core.event.TCConnectionEventListener;
import com.tc.net.protocol.IllegalReconnectException;
import com.tc.net.protocol.NetworkLayer;
import com.tc.net.protocol.TCNetworkMessage;
import com.tc.net.protocol.tcm.ChannelID;
import com.tc.net.protocol.transport.AbstractMessageTransport;
import com.tc.net.protocol.transport.ConnectionHealthCheckerContext;
import com.tc.net.protocol.transport.ConnectionHealthCheckerContextDummyImpl;
import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.HealthCheckerProbeMessage;
import com.tc.net.protocol.transport.JvmIDUtil;
import com.tc.net.protocol.transport.MessageTransportState;
import com.tc.net.protocol.transport.MessageTransportStatus;
import com.tc.net.protocol.transport.TransportHandshakeErrorContext;
import com.tc.net.protocol.transport.TransportHandshakeErrorHandler;
import com.tc.net.protocol.transport.TransportHandshakeMessageFactory;
import com.tc.net.protocol.transport.WireProtocolMessage;
import com.tc.object.session.SessionID;
import com.tc.util.Assert;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;

abstract class MessageTransportBase
extends AbstractMessageTransport
implements TCConnectionEventListener {
    private volatile TCConnection connection;
    private ConnectionID connectionId = new ConnectionID(JvmIDUtil.getJvmID(), ChannelID.NULL_ID.toLong());
    protected final MessageTransportStatus status;
    protected final TransportHandshakeMessageFactory messageFactory;
    private final TransportHandshakeErrorHandler handshakeErrorHandler;
    private WeakReference<NetworkLayer> receiveLayer;
    private final AtomicReference<TCConnectionEvent> connectionCloseEvent = new AtomicReference();
    private volatile ConnectionHealthCheckerContext healthCheckerContext = new ConnectionHealthCheckerContextDummyImpl();

    protected MessageTransportBase(MessageTransportState initialState, TransportHandshakeErrorHandler handshakeErrorHandler, TransportHandshakeMessageFactory messageFactory, Logger logger) {
        super(logger);
        this.handshakeErrorHandler = handshakeErrorHandler;
        this.messageFactory = messageFactory;
        this.status = new MessageTransportStatus(initialState, logger);
    }

    public synchronized void setHealthCheckerContext(ConnectionHealthCheckerContext context) {
        this.healthCheckerContext = context;
    }

    public synchronized ConnectionHealthCheckerContext getHealthCheckerContext() {
        return this.healthCheckerContext;
    }

    @Override
    public final ConnectionID getConnectionID() {
        return this.connectionId;
    }

    @Override
    public ProductID getProductID() {
        return this.connectionId.getProductId();
    }

    @Override
    public final void setReceiveLayer(NetworkLayer layer) {
        this.receiveLayer = new WeakReference<NetworkLayer>(layer);
    }

    @Override
    public final NetworkLayer getReceiveLayer() {
        return this.receiveLayer == null ? null : (NetworkLayer)this.receiveLayer.get();
    }

    @Override
    public final void setSendLayer(NetworkLayer layer) {
        throw new UnsupportedOperationException("Transport layer has no send layer.");
    }

    private boolean isSameConnection(TCConnection checkConn) {
        return checkConn == this.getConnection();
    }

    @Override
    public final void receiveTransportMessage(WireProtocolMessage message) {
        if (this.isSameConnection(message.getSource())) {
            this.receiveTransportMessageImpl(message);
        } else {
            this.getLogger().warn("Received message from an old connection: " + message.getSource() + "; " + message);
        }
    }

    protected abstract void receiveTransportMessageImpl(WireProtocolMessage var1);

    protected final void receiveToReceiveLayer(WireProtocolMessage message) {
        NetworkLayer receiver = this.getReceiveLayer();
        if (receiver == null) {
            this.disconnect();
            return;
        }
        if (message.getMessageProtocol() == 2) {
            this.getLogger().info(message.toString());
            throw new RuntimeException("Wrong handshake message from: " + message.getSource());
        }
        if (message.getMessageProtocol() == 4) {
            if (this.healthCheckerContext.receiveProbe((HealthCheckerProbeMessage)message)) {
                return;
            }
            throw new RuntimeException("Wrong HealthChecker Probe message from: " + message.getSource());
        }
        receiver.receive(message);
    }

    @Override
    public final void receive(TCNetworkMessage msgData) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        this.terminate(false);
    }

    public void disconnect() {
        this.terminate(true);
    }

    protected boolean resetIfNotEnd() {
        return this.status.resetIfNotEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminate(boolean disconnect) {
        MessageTransportStatus messageTransportStatus = this.status;
        synchronized (messageTransportStatus) {
            if (this.status.isEnd()) {
                this.getLogger().debug("Can only close an open connection");
                return;
            }
            if (disconnect) {
                this.status.disconnect();
            } else {
                this.status.end();
            }
        }
        if (!disconnect) {
            this.fireTransportClosedEvent();
        }
        if (this.healthCheckerContext != null) {
            this.healthCheckerContext.close();
        }
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.asynchClose();
        }
    }

    @Override
    public final void send(TCNetworkMessage message) throws IOException {
        if (!this.status.isEstablished()) {
            throw new IOException("connection not established");
        }
        this.sendToConnection(message);
    }

    @Override
    public void sendToConnection(TCNetworkMessage message) throws IOException {
        if (message == null) {
            throw new AssertionError((Object)"Attempt to send a null message.");
        }
        if (this.status.isEnd()) {
            message.complete();
            throw new IOException("Couldn't send message status: " + this.status);
        }
        this.connection.putMessage(message);
    }

    @Override
    public boolean isConnected() {
        TCConnection conn = this.getConnection();
        return conn != null && conn.isConnected() && conn.isTransportEstablished() && !conn.isClosed();
    }

    @Override
    public void attachNewConnection(TCConnection newConnection) throws IllegalReconnectException {
        this.attachNewConnection(this.connectionCloseEvent.getAndSet(null), this.connection, newConnection);
    }

    private void attachNewConnection(TCConnectionEvent closeEvent, TCConnection oldConnection, TCConnection newConnection) {
        Assert.assertNotNull(oldConnection);
        if (closeEvent == null || closeEvent.getSource() != oldConnection) {
            if (this.isConnected()) {
                this.status.reset();
                this.fireTransportDisconnectedEvent();
                this.getConnection().asynchClose();
            } else {
                this.logger.warn("Old connection " + oldConnection + "might not have been Transport Established ");
            }
        }
        if (oldConnection != null && oldConnection != this.getConnection()) {
            oldConnection.removeListener(this);
        }
        this.wireNewConnection(newConnection);
    }

    @Override
    public void connectEvent(TCConnectionEvent event) {
        this.status.connected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeEvent(TCConnectionEvent event) {
        if (this.isSameConnection(event.getSource())) {
            if (this.connectionCloseEvent.compareAndSet(null, event)) {
                boolean forcedDisconnect = false;
                MessageTransportStatus messageTransportStatus = this.status;
                synchronized (messageTransportStatus) {
                    this.getLogger().debug("CLOSE EVENT : " + this.connection + ". STATUS : " + this.status);
                    if (this.status.isEnd()) {
                        return;
                    }
                    if (this.status.isConnected() || this.status.isEstablished() || this.status.isDisconnected()) {
                        if (this.status.isDisconnected()) {
                            forcedDisconnect = true;
                        }
                    } else {
                        this.status.reset();
                        this.getLogger().debug("closing down connection - " + event + " - " + this.status);
                        return;
                    }
                    this.status.reset();
                }
                if (forcedDisconnect) {
                    this.fireTransportForcedDisconnectEvent();
                } else {
                    this.fireTransportDisconnectedEvent();
                }
            }
        } else {
            this.getLogger().debug("NOT SAME CONNECTION");
        }
    }

    @Override
    public void errorEvent(TCConnectionErrorEvent errorEvent) {
    }

    @Override
    public void endOfFileEvent(TCConnectionEvent event) {
    }

    protected void handleHandshakeError(TransportHandshakeErrorContext e) {
        this.handshakeErrorHandler.handleHandshakeError(e);
    }

    protected TCConnection getConnection() {
        return this.connection;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.connection != null ? this.connection.getRemoteAddress() : null;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.connection != null ? this.connection.getLocalAddress() : null;
    }

    protected void setConnection(TCConnection conn) {
        TCConnection old = this.connection;
        this.connection = conn;
        this.connectionCloseEvent.set(null);
        this.connection.addListener(this);
        if (old != null) {
            old.removeListener(this);
        }
    }

    protected void clearConnection() {
        TCConnection conn = this.getConnection();
        if (conn != null) {
            conn.close();
            conn.removeListener(this);
            this.connection = null;
            this.resetIfNotEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean wireNewConnection(TCConnection conn) {
        MessageTransportStatus messageTransportStatus = this.status;
        synchronized (messageTransportStatus) {
            if (this.status.isEnd()) {
                this.getLogger().warn("Connection stack is already closed. " + this.status + "; Conn: " + conn);
                conn.removeListener(this);
                conn.asynchClose();
                return false;
            }
            this.setConnection(conn);
            this.status.reset();
            if (conn.isConnected()) {
                this.status.connected();
            }
            return true;
        }
    }

    @Override
    public short getStackLayerFlag() {
        return 1;
    }

    @Override
    public String getStackLayerName() {
        return "Transport Layer";
    }

    @Override
    public final synchronized void initConnectionID(ConnectionID cid) {
        this.connectionId = cid;
    }

    protected final synchronized void clearConnectionID() {
        this.connectionId = new ConnectionID(JvmIDUtil.getJvmID(), ChannelID.NULL_ID.toLong());
    }

    @Override
    public SessionID getSessionID() {
        TCConnection conn = this.getConnection();
        return conn == null ? SessionID.NULL_ID : new SessionID(System.identityHashCode(conn));
    }

    @Override
    public TCByteBufferOutputStream createOutput() {
        TCConnection conn = this.getConnection();
        if (conn == null) {
            return new TCByteBufferOutputStream();
        }
        return conn.createOutput();
    }

    @Override
    public Map<String, ?> getStateMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("connection", this.getConnection().getState());
        map.put("id", this.connectionId.toString());
        return map;
    }
}

