/*
 * Decompiled with CFR 0.152.
 */
package com.tc.process;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

public class StreamCopier
extends Thread {
    protected final OutputStream out;
    private final BufferedReader reader;
    private final String identifier;

    public StreamCopier(InputStream stream, OutputStream out) {
        this(stream, out, null);
    }

    public StreamCopier(InputStream stream, OutputStream out, String identifier) {
        if (stream == null || out == null) {
            throw new AssertionError((Object)"null streams not allowed");
        }
        this.reader = new BufferedReader(new InputStreamReader(stream));
        this.out = out;
        this.identifier = identifier;
        this.setName("Stream Copier");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        try {
            Object line;
            while ((line = this.reader.readLine()) != null) {
                if (this.identifier != null) {
                    line = this.identifier + (String)line;
                }
                line = (String)line + System.getProperty("line.separator", "\n");
                this.out.write(((String)line).getBytes());
                this.out.flush();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

