/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.tcm;

import com.tc.bytes.TCByteBuffer;
import com.tc.net.protocol.AbstractTCNetworkHeader;
import com.tc.net.protocol.TCProtocolException;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.util.Assert;

public class TCMessageHeaderImpl
extends AbstractTCNetworkHeader
implements TCMessageHeader {
    public TCMessageHeaderImpl(TCByteBuffer hdrData) {
        super(hdrData, 8, 8);
    }

    public TCMessageHeaderImpl(TCMessageType type) {
        super(8, 8);
        this.setMessageType(type.getType());
        this.setVersion((short)1);
        this.setHeaderLength((short)2);
    }

    @Override
    public int getHeaderByteLength() {
        return this.getHeaderLength() * 4;
    }

    @Override
    public short getVersion() {
        return this.data.getUbyte(0);
    }

    @Override
    public int getHeaderLength() {
        return this.data.getUbyte(1);
    }

    @Override
    public int getMessageType() {
        return this.data.getUshort(2);
    }

    @Override
    public int getMessageTypeVersion() {
        return this.data.getUshort(4);
    }

    void setVersion(short version) {
        this.data.putUbyte(0, version);
    }

    @Override
    protected void setHeaderLength(short length) {
        Assert.eval(length <= 8);
        this.data.putUbyte(1, length);
    }

    @Override
    public void setMessageType(int type) {
        this.data.putUshort(2, type);
    }

    @Override
    public void setMessageTypeVersion(int version) {
        this.data.putUshort(4, version);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        TCMessageType type = TCMessageType.getInstance(this.getMessageType());
        buf.append("msgType: ");
        if (type != null) {
            buf.append(type.toString());
        } else {
            buf.append("UNKNOWN").append('(').append(this.getMessageType()).append(')');
        }
        buf.append(", msgVer=").append(this.getMessageTypeVersion());
        buf.append('\n');
        return buf.toString();
    }

    @Override
    public void validate() throws TCProtocolException {
        short version = this.getVersion();
        boolean expect = true;
        if (version != 1) {
            throw new TCProtocolException("Version " + version + " does not match expected version 1");
        }
    }

    @Override
    protected boolean isHeaderLengthAvail() {
        return this.data.position() > 1;
    }
}

