/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.core;

import com.tc.net.core.SocketEndpoint;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class ClearTextSocketEndpoint
implements SocketEndpoint {
    private final SocketChannel socket;
    private volatile boolean open = true;

    public ClearTextSocketEndpoint(SocketChannel socket) {
        this.socket = socket;
    }

    @Override
    public SocketEndpoint.ResultType writeFrom(ByteBuffer[] ref) throws IOException {
        if (!this.open) {
            return SocketEndpoint.ResultType.EOF;
        }
        long amount = this.socket.write(ref);
        if (amount == 0L) {
            return SocketEndpoint.ResultType.ZERO;
        }
        if (amount < 0L) {
            return SocketEndpoint.ResultType.EOF;
        }
        return SocketEndpoint.ResultType.SUCCESS;
    }

    @Override
    public SocketEndpoint.ResultType readTo(ByteBuffer[] ref) throws IOException {
        if (!this.open) {
            return SocketEndpoint.ResultType.EOF;
        }
        long amount = this.socket.read(ref);
        if (amount == 0L) {
            return SocketEndpoint.ResultType.ZERO;
        }
        if (amount < 0L) {
            return SocketEndpoint.ResultType.EOF;
        }
        return SocketEndpoint.ResultType.SUCCESS;
    }

    @Override
    public void close() throws IOException {
        this.open = false;
    }
}

