/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.common.struct;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Objects;
import org.terracotta.common.struct.Unit;

public final class Measure<T extends Enum<T>>
implements Comparable<Measure<T>> {
    private final BigInteger quantity;
    private final T unit;

    public static <U extends Enum<U>> Measure<U> of(long quantity, U type) {
        return new Measure<U>(BigInteger.valueOf(quantity), type);
    }

    public static <U extends Enum<U>> Measure<U> of(BigInteger quantity, U type) {
        return new Measure<U>(quantity, type);
    }

    public static <U extends Enum<U>> Measure<U> zero(Class<U> unitType) {
        return Measure.of(BigInteger.ZERO, ((Unit)((Object)((Enum[])unitType.getEnumConstants())[0])).getBaseUnit());
    }

    public static <U extends Enum<U>> Measure<U> parse(String quantityUnit, Class<U> unitType) throws IllegalArgumentException {
        return Measure.parse(quantityUnit, unitType, EnumSet.allOf(unitType));
    }

    public static <U extends Enum<U>> Measure<U> parse(String quantityUnit, Class<U> unitType, Collection<U> validUnits) throws IllegalArgumentException {
        BigInteger quantity;
        Objects.requireNonNull(quantityUnit);
        Objects.requireNonNull(unitType);
        if (quantityUnit.isEmpty()) {
            throw new IllegalArgumentException("Invalid measure. <quantity><unit> are missing.");
        }
        char[] chars = quantityUnit.toCharArray();
        if (chars[0] == '-') {
            throw new IllegalArgumentException("Quantity measure cannot be negative");
        }
        ArrayList<U> list = new ArrayList<U>(validUnits);
        list.sort(Comparator.comparing(u -> -((Unit)((Object)u)).getShortName().length()));
        Enum foundUnit = null;
        for (Enum validUnit : list) {
            if (!quantityUnit.endsWith(((Unit)((Object)validUnit)).getShortName())) continue;
            foundUnit = validUnit;
            break;
        }
        if (foundUnit == null) {
            throw new IllegalArgumentException("Invalid measure: '" + quantityUnit + "'. <unit> is missing or not recognized. It must be one of " + validUnits + ".");
        }
        quantityUnit = quantityUnit.substring(0, quantityUnit.length() - ((Unit)((Object)foundUnit)).getShortName().length());
        try {
            quantity = new BigInteger(quantityUnit);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid measure: '" + quantityUnit + "'. <quantity> must be a positive integer.");
        }
        return Measure.of(quantity, foundUnit);
    }

    protected Measure(BigInteger quantity, T unit) {
        this.quantity = quantity;
        this.unit = (Enum)Objects.requireNonNull(unit);
        if (quantity.signum() == -1) {
            throw new IllegalArgumentException("Quantity measure cannot be negative");
        }
    }

    public long getQuantity() {
        return this.quantity.longValueExact();
    }

    public long getQuantity(T unit) {
        return ((Unit)unit).convert(this.quantity, this.unit).longValueExact();
    }

    public BigInteger getExactQuantity() {
        return this.quantity;
    }

    public BigInteger getExactQuantity(T unit) {
        return ((Unit)unit).convert(this.quantity, this.unit);
    }

    public Measure<T> to(T unit) {
        return Measure.of(this.getQuantity(unit), unit);
    }

    public T getUnit() {
        return this.unit;
    }

    public Measure<T> add(long quantity, T unit) {
        return this.add(BigInteger.valueOf(quantity), unit);
    }

    public Measure<T> add(BigInteger quantity, T unit) {
        return this.add(((Unit)this.unit).convert(quantity, unit));
    }

    public Measure<T> add(long amount) {
        return this.add(BigInteger.valueOf(amount));
    }

    public Measure<T> add(BigInteger amount) {
        return Measure.of(this.quantity.add(amount), this.unit);
    }

    public Measure<T> multiply(long factor) {
        return this.multiply(BigInteger.valueOf(factor));
    }

    public Measure<T> multiply(BigInteger factor) {
        return Measure.of(this.quantity.multiply(factor), this.unit);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Measure)) {
            return false;
        }
        Measure measure = (Measure)o;
        return Objects.equals(this.getExactQuantity(), measure.getExactQuantity()) && Objects.equals(this.getUnit(), measure.getUnit());
    }

    public int hashCode() {
        return Objects.hash(this.quantity, this.unit);
    }

    public String toString() {
        return this.quantity + ((Unit)this.unit).getShortName();
    }

    @Override
    public int compareTo(Measure<T> o) {
        return this.getExactQuantity(((Unit)this.unit).getBaseUnit()).compareTo(o.getExactQuantity(((Unit)o.getUnit()).getBaseUnit()));
    }
}

