/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.net.core.ProductID;
import com.tc.net.core.SocketEndpointFactory;
import com.tc.net.core.TCConnectionManager;
import com.tc.net.core.TCConnectionManagerImpl;
import com.tc.net.protocol.NetworkStackHarnessFactory;
import com.tc.net.protocol.tcm.ClientMessageChannel;
import com.tc.net.protocol.tcm.CommunicationsManager;
import com.tc.net.protocol.tcm.CommunicationsManagerImpl;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCAction;
import com.tc.net.protocol.tcm.TCMessageRouter;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.net.protocol.transport.ClientConnectionErrorListener;
import com.tc.net.protocol.transport.ConnectionPolicy;
import com.tc.net.protocol.transport.HealthCheckerConfig;
import com.tc.net.protocol.transport.ReconnectionRejectedHandler;
import com.tc.net.protocol.transport.TransportHandshakeErrorHandlerForL1;
import com.tc.object.ClientBuilder;
import com.tc.object.ClientEntityManager;
import com.tc.object.ClientEntityManagerImpl;
import com.tc.object.handshakemanager.ClientHandshakeManager;
import com.tc.object.handshakemanager.ClientHandshakeManagerImpl;
import com.tc.object.msg.ClientHandshakeMessageFactory;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;

public class StandardClientBuilder
implements ClientBuilder {
    private final Properties connectionProperties;
    private volatile ClientConnectionErrorListener listener;
    private final SocketEndpointFactory buffers;

    public StandardClientBuilder(Properties connectionProperties, SocketEndpointFactory buffers) {
        this.connectionProperties = connectionProperties;
        this.buffers = buffers;
    }

    @Override
    public ClientMessageChannel createClientMessageChannel(CommunicationsManager commMgr, int socketConnectTimeout) {
        ClientMessageChannel cmc = commMgr.createClientChannel(this.getTypeOfClient(), socketConnectTimeout);
        if (this.listener != null) {
            cmc.addClientConnectionErrorListener(this.listener);
        }
        return cmc;
    }

    @Override
    public CommunicationsManager createCommunicationsManager(MessageMonitor monitor, TCMessageRouter messageRouter, NetworkStackHarnessFactory stackHarnessFactory, ConnectionPolicy connectionPolicy, TCConnectionManager connections, HealthCheckerConfig aConfig, Map<TCMessageType, Class<? extends TCAction>> messageTypeClassMapping, ReconnectionRejectedHandler reconnectionRejectedHandler) {
        return new CommunicationsManagerImpl(monitor, messageRouter, stackHarnessFactory, connections, connectionPolicy, aConfig, new TransportHandshakeErrorHandlerForL1(), messageTypeClassMapping, reconnectionRejectedHandler, this.getSocketEndpointFactory());
    }

    @Override
    public ClientHandshakeManager createClientHandshakeManager(Logger logger, ClientHandshakeMessageFactory chmf, String uuid, String name, String clientVersion, String clientRevision, ClientEntityManager entity) {
        return new ClientHandshakeManagerImpl(logger, chmf, uuid, name, clientVersion, clientRevision, entity);
    }

    @Override
    public ClientEntityManager createClientEntityManager(ClientMessageChannel channel) {
        return new ClientEntityManagerImpl(channel);
    }

    @Override
    public ProductID getTypeOfClient() {
        boolean noreconnect = Boolean.valueOf(this.connectionProperties.getProperty("connection.noreconnect", "false"));
        String typeName = this.connectionProperties.getProperty("connection.type");
        ProductID product = noreconnect ? ProductID.SERVER : ProductID.PERMANENT;
        try {
            if (typeName != null) {
                product = ProductID.valueOf(typeName.toUpperCase());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return product;
    }

    @Override
    public TCConnectionManager createConnectionManager(String uuid, String name) {
        return new TCConnectionManagerImpl(name + "/" + uuid, null, 0, this.getSocketEndpointFactory());
    }

    protected SocketEndpointFactory getSocketEndpointFactory() {
        return this.buffers;
    }

    @Override
    public void setClientConnectionErrorListener(ClientConnectionErrorListener listener) {
        this.listener = listener;
    }
}

