/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.util.Assert;

public class ClientEntityStateManager {
    private volatile State currentState = State.RUNNING;

    public boolean isRunning() {
        return this.currentState == State.RUNNING;
    }

    public boolean isShutdown() {
        return this.currentState == State.STOPPED;
    }

    public boolean isPaused() {
        return this.currentState == State.PAUSED;
    }

    public void stop() {
        this.moveTo(State.STOPPED);
    }

    public void running() {
        this.moveTo(State.RUNNING);
    }

    public void pause() {
        this.moveTo(State.PAUSED);
    }

    public String getCurrentState() {
        return this.currentState.toString();
    }

    private void moveTo(State newState) {
        this.currentState.check(newState);
        this.currentState = newState;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum State {
        PAUSED{

            @Override
            void check(State newState) {
                Assert.assertTrue("Attempt to pause while PAUSED", newState != PAUSED);
            }
        }
        ,
        RUNNING{

            @Override
            void check(State newState) {
                Assert.assertTrue("Attempt to unpause while RUNNING", newState != RUNNING);
            }
        }
        ,
        STOPPED{

            @Override
            void check(State newState) {
            }
        };


        abstract void check(State var1);
    }
}

