/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.tcm;

import com.tc.net.ServerID;
import com.tc.net.core.ClearTextSocketEndpointFactory;
import com.tc.net.core.ProductID;
import com.tc.net.core.SocketEndpointFactory;
import com.tc.net.core.TCConnection;
import com.tc.net.core.TCConnectionManager;
import com.tc.net.core.TCListener;
import com.tc.net.protocol.ClientNetworkStackHarness;
import com.tc.net.protocol.NetworkStackHarnessFactory;
import com.tc.net.protocol.tcm.ChannelID;
import com.tc.net.protocol.tcm.ChannelManagerImpl;
import com.tc.net.protocol.tcm.ClientMessageChannel;
import com.tc.net.protocol.tcm.ClientMessageChannelImpl;
import com.tc.net.protocol.tcm.CommunicationsManager;
import com.tc.net.protocol.tcm.GeneratedMessageFactory;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageChannelInternal;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.MessageTransportFactoryImpl;
import com.tc.net.protocol.tcm.NetworkListener;
import com.tc.net.protocol.tcm.NetworkListenerImpl;
import com.tc.net.protocol.tcm.RedirectAddressProvider;
import com.tc.net.protocol.tcm.ServerMessageChannelFactory;
import com.tc.net.protocol.tcm.ServerMessageChannelImpl;
import com.tc.net.protocol.tcm.TCAction;
import com.tc.net.protocol.tcm.TCMessageFactory;
import com.tc.net.protocol.tcm.TCMessageFactoryImpl;
import com.tc.net.protocol.tcm.TCMessageRouter;
import com.tc.net.protocol.tcm.TCMessageRouterImpl;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.net.protocol.transport.ClientMessageTransport;
import com.tc.net.protocol.transport.ConnectionHealthChecker;
import com.tc.net.protocol.transport.ConnectionHealthCheckerEchoImpl;
import com.tc.net.protocol.transport.ConnectionHealthCheckerImpl;
import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.ConnectionIDFactory;
import com.tc.net.protocol.transport.ConnectionPolicy;
import com.tc.net.protocol.transport.DisabledHealthCheckerConfigImpl;
import com.tc.net.protocol.transport.HealthCheckerConfig;
import com.tc.net.protocol.transport.MessageTransport;
import com.tc.net.protocol.transport.MessageTransportFactory;
import com.tc.net.protocol.transport.MessageTransportListener;
import com.tc.net.protocol.transport.ReconnectionRejectedHandler;
import com.tc.net.protocol.transport.ReconnectionRejectedHandlerL1;
import com.tc.net.protocol.transport.ReconnectionRejectedHandlerL2;
import com.tc.net.protocol.transport.ServerMessageTransport;
import com.tc.net.protocol.transport.ServerStackProvider;
import com.tc.net.protocol.transport.TransportHandshakeErrorHandler;
import com.tc.net.protocol.transport.TransportHandshakeErrorHandlerForL1;
import com.tc.net.protocol.transport.TransportHandshakeMessageFactory;
import com.tc.net.protocol.transport.TransportMessageFactoryImpl;
import com.tc.net.protocol.transport.WireProtocolAdaptorFactoryImpl;
import com.tc.net.protocol.transport.WireProtocolMessageSink;
import com.tc.util.Assert;
import com.tc.util.concurrent.SetOnceFlag;
import java.io.IOException;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommunicationsManagerImpl
implements CommunicationsManager {
    private static final Logger logger = LoggerFactory.getLogger(CommunicationsManager.class);
    private final SetOnceFlag shutdown = new SetOnceFlag();
    private final Set<NetworkListener> listeners = new HashSet<NetworkListener>();
    private final ReentrantLock licenseLock = new ReentrantLock();
    private final TCConnectionManager connectionManager;
    private final NetworkStackHarnessFactory stackHarnessFactory;
    private final TransportHandshakeMessageFactory transportMessageFactory;
    private final MessageMonitor monitor;
    private final TCMessageRouter messageRouter;
    private final HealthCheckerConfig healthCheckerConfig;
    private final ConnectionPolicy connectionPolicy;
    private final ReconnectionRejectedHandler reconnectionRejectedHandler;
    protected final ConcurrentHashMap<TCMessageType, Class<? extends TCAction>> messageTypeClassMapping = new ConcurrentHashMap();
    protected final ConcurrentHashMap<TCMessageType, GeneratedMessageFactory> messageTypeFactoryMapping = new ConcurrentHashMap();
    private final ConnectionHealthChecker connectionHealthChecker;
    private ServerID serverID = ServerID.NULL_ID;
    private final TransportHandshakeErrorHandler handshakeErrHandler;

    public CommunicationsManagerImpl(MessageMonitor monitor, NetworkStackHarnessFactory stackHarnessFactory, TCConnectionManager connectionManager, ConnectionPolicy connectionPolicy) {
        this(monitor, new TCMessageRouterImpl(), stackHarnessFactory, connectionManager, connectionPolicy, new DisabledHealthCheckerConfigImpl(), new TransportHandshakeErrorHandlerForL1(), Collections.emptyMap(), Collections.emptyMap());
    }

    public CommunicationsManagerImpl(MessageMonitor monitor, TCMessageRouter messageRouter, NetworkStackHarnessFactory stackHarnessFactory, TCConnectionManager connectionManager, ConnectionPolicy connectionPolicy, HealthCheckerConfig config, ServerID serverID, TransportHandshakeErrorHandler transportHandshakeErrorHandler, Map<TCMessageType, Class<? extends TCAction>> messageTypeClassMapping, Map<TCMessageType, GeneratedMessageFactory> messageTypeFactoryMapping) {
        this(monitor, messageRouter, stackHarnessFactory, connectionManager, connectionPolicy, config, transportHandshakeErrorHandler, messageTypeClassMapping, ReconnectionRejectedHandlerL2.SINGLETON, new ClearTextSocketEndpointFactory());
        this.serverID = serverID;
    }

    public CommunicationsManagerImpl(MessageMonitor monitor, TCMessageRouter messageRouter, NetworkStackHarnessFactory stackHarnessFactory, TCConnectionManager connectionManager, ConnectionPolicy connectionPolicy, HealthCheckerConfig config, ServerID serverID, TransportHandshakeErrorHandler transportHandshakeErrorHandler, Map<TCMessageType, Class<? extends TCAction>> messageTypeClassMapping, Map<TCMessageType, GeneratedMessageFactory> messageTypeFactoryMapping, SocketEndpointFactory socketEndpointFactory) {
        this(monitor, messageRouter, stackHarnessFactory, connectionManager, connectionPolicy, config, transportHandshakeErrorHandler, messageTypeClassMapping, ReconnectionRejectedHandlerL2.SINGLETON, socketEndpointFactory);
        this.serverID = serverID;
    }

    public CommunicationsManagerImpl(MessageMonitor monitor, TCMessageRouter messageRouter, NetworkStackHarnessFactory stackHarnessFactory, TCConnectionManager connMgr, ConnectionPolicy connectionPolicy, HealthCheckerConfig healthCheckerConf, TransportHandshakeErrorHandler transportHandshakeErrorHandler, Map<TCMessageType, Class<? extends TCAction>> messageTypeClassMapping, Map<TCMessageType, GeneratedMessageFactory> messageTypeFactoryMapping) {
        this(monitor, messageRouter, stackHarnessFactory, connMgr, connectionPolicy, healthCheckerConf, transportHandshakeErrorHandler, messageTypeClassMapping, ReconnectionRejectedHandlerL1.SINGLETON, new ClearTextSocketEndpointFactory());
    }

    public CommunicationsManagerImpl(MessageMonitor monitor, TCMessageRouter messageRouter, NetworkStackHarnessFactory stackHarnessFactory, TCConnectionManager connMgr, ConnectionPolicy connectionPolicy, HealthCheckerConfig healthCheckerConf, TransportHandshakeErrorHandler transportHandshakeErrorHandler, Map<TCMessageType, Class<? extends TCAction>> messageTypeClassMapping, ReconnectionRejectedHandler reconnectionRejectedHandler, SocketEndpointFactory socketEndpointFactory) {
        this.monitor = monitor;
        this.messageRouter = messageRouter;
        this.transportMessageFactory = new TransportMessageFactoryImpl();
        this.connectionPolicy = connectionPolicy;
        this.stackHarnessFactory = stackHarnessFactory;
        this.healthCheckerConfig = healthCheckerConf;
        this.handshakeErrHandler = transportHandshakeErrorHandler;
        this.messageTypeClassMapping.putAll(messageTypeClassMapping);
        this.messageTypeFactoryMapping.putAll(this.messageTypeFactoryMapping);
        this.reconnectionRejectedHandler = reconnectionRejectedHandler;
        Assert.assertNotNull(connMgr);
        this.connectionManager = connMgr;
        Assert.eval(this.healthCheckerConfig != null);
        this.connectionHealthChecker = this.healthCheckerConfig.isHealthCheckerEnabled() ? new ConnectionHealthCheckerImpl(this.healthCheckerConfig, this.connectionManager, this.createReferenceCheck()) : new ConnectionHealthCheckerEchoImpl();
    }

    private Supplier<Boolean> createReferenceCheck() {
        ReferenceQueue gc = new ReferenceQueue();
        PhantomReference<CommunicationsManagerImpl> ref = new PhantomReference<CommunicationsManagerImpl>(this, gc);
        SetOnceFlag gcd = new SetOnceFlag();
        return () -> {
            if (gc.poll() == ref) {
                gcd.set();
            }
            return !gcd.isSet();
        };
    }

    @Override
    public Map<String, ?> getStateMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("connectionPolicy", this.connectionPolicy.toString());
        map.put("connectionManager", this.connectionManager.getStateMap());
        return map;
    }

    @Override
    public TCConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public boolean isInShutdown() {
        return this.shutdown.isSet();
    }

    @Override
    public void shutdown() {
        if (this.shutdown.attemptSet()) {
            NetworkListener[] col;
            this.connectionHealthChecker.stop();
            for (NetworkListener l : col = this.getAllListeners()) {
                l.stop();
            }
            this.connectionManager.shutdown();
            this.monitor.shutdown();
        } else {
            logger.warn("shutdown already started");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkListener[] getAllListeners() {
        Set<NetworkListener> set = this.listeners;
        synchronized (set) {
            return this.listeners.toArray(new NetworkListener[this.listeners.size()]);
        }
    }

    @Override
    public void addClassMapping(TCMessageType messageType, Class<? extends TCAction> messageClass) {
        this.messageTypeClassMapping.put(messageType, messageClass);
    }

    @Override
    public ClientMessageChannel createClientChannel(ProductID productId, int timeout) {
        return this.createClientChannel(productId, timeout, null, null);
    }

    public ClientMessageChannel createClientChannel(ProductID productId, int timeout, MessageTransportFactory transportFactory, TCMessageFactory messageFactory) {
        TCMessageFactory msgFactory;
        if (messageFactory == null) {
            msgFactory = new TCMessageFactoryImpl(this.monitor);
            for (Map.Entry<TCMessageType, Class<? extends TCAction>> entry : this.messageTypeClassMapping.entrySet()) {
                msgFactory.addClassMapping(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<TCMessageType, Object> entry : this.messageTypeFactoryMapping.entrySet()) {
                msgFactory.addClassMapping(entry.getKey(), (GeneratedMessageFactory)entry.getValue());
            }
        } else {
            msgFactory = messageFactory;
        }
        ClientMessageChannelImpl rv = new ClientMessageChannelImpl(msgFactory, this.messageRouter, productId);
        if (transportFactory == null) {
            transportFactory = new MessageTransportFactoryImpl(this.transportMessageFactory, this.connectionHealthChecker, this.connectionManager, timeout, this.handshakeErrHandler, this.reconnectionRejectedHandler);
        }
        ClientNetworkStackHarness clientNetworkStackHarness = this.stackHarnessFactory.createClientHarness(transportFactory, rv, new MessageTransportListener[0]);
        clientNetworkStackHarness.finalizeStack();
        return rv;
    }

    @Override
    public NetworkListener createListener(InetSocketAddress addr, boolean transportDisconnectRemovesChannel, ConnectionIDFactory connectionIdFactory, RedirectAddressProvider activeNameProvider) {
        return this.createListener(addr, c -> transportDisconnectRemovesChannel, connectionIdFactory, true, null, activeNameProvider, t -> true);
    }

    @Override
    public NetworkListener createListener(InetSocketAddress addr, Predicate<MessageChannel> transportDisconnectRemovesChannel, ConnectionIDFactory connectionIdFactory, Predicate<MessageTransport> validation) {
        return this.createListener(addr, transportDisconnectRemovesChannel, connectionIdFactory, true, null, null, validation);
    }

    NetworkListener createListener(InetSocketAddress addr, Predicate<MessageChannel> transportDisconnectRemovesChannel, ConnectionIDFactory connectionIdFactory, boolean reuseAddr, WireProtocolMessageSink wireProtoMsgSnk, RedirectAddressProvider activeProvider, Predicate<MessageTransport> validation) {
        if (this.shutdown.isSet()) {
            throw new IllegalStateException("Comms manger shut down");
        }
        final TCMessageFactoryImpl msgFactory = new TCMessageFactoryImpl(this.monitor);
        for (Map.Entry<TCMessageType, Class<? extends TCAction>> entry : this.messageTypeClassMapping.entrySet()) {
            msgFactory.addClassMapping(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<TCMessageType, Object> entry : this.messageTypeFactoryMapping.entrySet()) {
            msgFactory.addClassMapping(entry.getKey(), (GeneratedMessageFactory)entry.getValue());
        }
        ServerMessageChannelFactory channelFactory = new ServerMessageChannelFactory(){

            @Override
            public MessageChannelInternal createNewChannel(ChannelID id) {
                return new ServerMessageChannelImpl(id, CommunicationsManagerImpl.this.messageRouter, msgFactory, CommunicationsManagerImpl.this.serverID);
            }
        };
        ChannelManagerImpl channelManagerImpl = new ChannelManagerImpl(transportDisconnectRemovesChannel, channelFactory);
        return new NetworkListenerImpl(addr, this, channelManagerImpl, msgFactory, reuseAddr, connectionIdFactory, wireProtoMsgSnk, activeProvider, validation);
    }

    TCListener createCommsListener(InetSocketAddress addr, ServerMessageChannelFactory channelFactory, boolean resueAddr, Set<ConnectionID> initialConnectionIDs, RedirectAddressProvider activeProvider, Predicate<MessageTransport> validation, ConnectionIDFactory connectionIdFactory, WireProtocolMessageSink wireProtocolMessageSink) throws IOException {
        MessageTransportFactory transportFactory = new MessageTransportFactory(){

            @Override
            public ClientMessageTransport createNewTransport() {
                throw new AssertionError();
            }

            @Override
            public ServerMessageTransport createNewTransport(TransportHandshakeErrorHandler handler, TransportHandshakeMessageFactory handshakeMessageFactory, List<MessageTransportListener> transportListeners) {
                ServerMessageTransport rv = new ServerMessageTransport(handler, handshakeMessageFactory);
                rv.addTransportListeners(transportListeners);
                rv.addTransportListener(CommunicationsManagerImpl.this.connectionHealthChecker);
                return rv;
            }

            @Override
            public ServerMessageTransport createNewTransport(TCConnection connection, TransportHandshakeErrorHandler handler, TransportHandshakeMessageFactory handshakeMessageFactory, List<MessageTransportListener> transportListeners) {
                ServerMessageTransport rv = new ServerMessageTransport(connection, handler, handshakeMessageFactory);
                rv.addTransportListeners(transportListeners);
                rv.addTransportListener(CommunicationsManagerImpl.this.connectionHealthChecker);
                return rv;
            }
        };
        ServerStackProvider stackProvider = new ServerStackProvider(initialConnectionIDs, activeProvider, validation, this.stackHarnessFactory, channelFactory, transportFactory, this.transportMessageFactory, connectionIdFactory, this.connectionPolicy, new WireProtocolAdaptorFactoryImpl(), wireProtocolMessageSink, this.licenseLock);
        return this.connectionManager.createListener(addr, stackProvider, 512, resueAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerListener(NetworkListener lsnr) {
        Set<NetworkListener> set = this.listeners;
        synchronized (set) {
            boolean added = this.listeners.add(lsnr);
            if (!added) {
                logger.warn("replaced an existing listener in the listener map");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterListener(NetworkListener lsnr) {
        Set<NetworkListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(lsnr);
        }
    }

    public ConnectionHealthChecker getConnHealthChecker() {
        return this.connectionHealthChecker;
    }

    public TCMessageRouter getMessageRouter() {
        return this.messageRouter;
    }
}

