/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.net.NodeID;
import com.tc.util.Assert;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;

public class ServerID
implements NodeID,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final ServerID NULL_ID = new ServerID("NULL-ID", new byte[0]);
    private static final String UNINITIALIZED = "Uninitialized";
    private String name;
    private byte[] uid;
    private transient int hash;

    public ServerID() {
        this.name = UNINITIALIZED;
    }

    public ServerID(String name, byte[] uid) {
        this.name = name;
        this.uid = uid;
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int lhash = 27;
        for (int i = this.uid.length - 1; i >= 0; --i) {
            lhash = 31 * lhash + this.uid[i];
        }
        this.hash = lhash;
        return lhash;
    }

    public boolean equals(Object o) {
        if (o instanceof ServerID) {
            ServerID that = (ServerID)o;
            return Arrays.equals(that.uid, this.uid);
        }
        return false;
    }

    public byte[] getUID() {
        return this.uid;
    }

    public String getName() {
        Assert.assertTrue(!this.name.equals(UNINITIALIZED));
        return this.name;
    }

    public String toString() {
        return "NodeID[" + this.getName() + "(" + new String(this.getUID()) + ")]";
    }

    @Override
    public boolean isNull() {
        return NULL_ID.equals(this);
    }

    @Override
    public ServerID deserializeFrom(TCByteBufferInput in) throws IOException {
        int read;
        int length;
        this.name = in.readString();
        this.uid = new byte[length];
        int off = 0;
        for (length = in.readInt(); length > 0; length -= read) {
            read = in.read(this.uid, off, length);
            off += read;
        }
        return this;
    }

    @Override
    public void serializeTo(TCByteBufferOutput out) {
        Assert.assertTrue(!this.name.equals(UNINITIALIZED));
        out.writeString(this.name);
        int length = this.uid.length;
        out.writeInt(length);
        out.write(this.uid);
    }

    @Override
    public byte getNodeType() {
        return 2;
    }

    @Override
    public int compareTo(NodeID n) {
        if (this.getNodeType() != n.getNodeType()) {
            return this.getNodeType() - n.getNodeType();
        }
        int length = this.uid.length;
        ServerID target = (ServerID)n;
        byte[] targetUid = target.getUID();
        int diff = length - targetUid.length;
        if (diff != 0) {
            return diff;
        }
        for (int i = 0; i < length; ++i) {
            diff = this.uid[i] - targetUid[i];
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }
}

