/*
 * Decompiled with CFR 0.152.
 */
package com.tc.lang;

import com.tc.lang.ThrowableHandler;
import com.tc.logging.CallbackOnExitHandler;
import com.tc.util.runtime.ThreadDumpUtil;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCThreadGroup
extends ThreadGroup {
    private final ThrowableHandler throwableHandler;
    private final boolean stoppable;
    private final boolean ignorePoolThreads;
    private static final Logger LOGGER = LoggerFactory.getLogger(TCThreadGroup.class);

    public TCThreadGroup(ThrowableHandler throwableHandler) {
        this(throwableHandler, "TC Thread Group");
    }

    public TCThreadGroup(ThrowableHandler throwableHandler, String name) {
        this(throwableHandler, name, true, true);
    }

    public TCThreadGroup(ThrowableHandler throwableHandler, String name, boolean stoppable) {
        this(throwableHandler, name, stoppable, false);
    }

    public TCThreadGroup(ThrowableHandler throwableHandler, String name, boolean stoppable, boolean ignorePool) {
        super(name);
        this.throwableHandler = throwableHandler;
        this.stoppable = stoppable;
        this.ignorePoolThreads = ignorePool;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        this.throwableHandler.handleThrowable(thread, throwable);
    }

    public void addCallbackOnExitDefaultHandler(CallbackOnExitHandler callbackOnExitHandler) {
        this.throwableHandler.addCallbackOnExitDefaultHandler(callbackOnExitHandler);
    }

    public void addCallbackOnExitExceptionHandler(Class<?> c, CallbackOnExitHandler callbackOnExitHandler) {
        this.throwableHandler.addCallbackOnExitExceptionHandler(c, callbackOnExitHandler);
    }

    public boolean isStoppable() {
        return this.stoppable;
    }

    public void printLiveThreads(Consumer<String> reporter) {
        for (Thread t : this.threads()) {
            if (t == null || t == Thread.currentThread()) continue;
            reporter.accept(t.getThreadGroup().getName() + " - " + t.getName());
            reporter.accept(ThreadDumpUtil.getThreadDump(t));
        }
    }

    public boolean retire(long timeout, Consumer<InterruptedException> interruptHandler) {
        boolean complete = false;
        long killStart = System.currentTimeMillis();
        if (this.stoppable) {
            while (!complete && System.currentTimeMillis() < killStart + timeout) {
                complete = true;
                for (Thread t : this.threads()) {
                    if (t == Thread.currentThread()) continue;
                    complete = complete && this.lookForThreadExit(t, interruptHandler);
                }
            }
        } else {
            return true;
        }
        if (complete) {
            LOGGER.debug("finished thread exiting in {} seconds", (Object)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - killStart));
        }
        if (complete && this.activeCount() == 0) {
            this.destroy();
        }
        return complete;
    }

    private boolean lookForThreadExit(Thread t, Consumer<InterruptedException> interruptHandler) {
        if (this.ignorePoolThreads && (t.getName().startsWith("pool-") || t instanceof ForkJoinWorkerThread && ((ForkJoinWorkerThread)t).getPool() == ForkJoinPool.commonPool())) {
            return true;
        }
        try {
            t.join(500L);
            return !t.isAlive();
        }
        catch (InterruptedException i) {
            interruptHandler.accept(i);
            return false;
        }
    }

    private List<Thread> threads() {
        int ac = this.activeCount();
        Thread[] list = new Thread[ac];
        this.enumerate(list, true);
        return Arrays.stream(list).filter(t -> t != null && t.isAlive()).collect(Collectors.toList());
    }
}

