/*
 * Decompiled with CFR 0.152.
 */
package com.tc.io;

import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCByteBufferAllocator;
import com.tc.bytes.TCByteBufferFactory;
import com.tc.bytes.TCReference;
import com.tc.io.TCByteBufferOutput;
import com.tc.util.Assert;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.io.UncheckedIOException;
import java.util.function.Supplier;

public class TCByteBufferOutputStream
extends OutputStream
implements TCByteBufferOutput {
    private static final int DEFAULT_MAX_BLOCK_SIZE = 524288;
    private static final int DEFAULT_INITIAL_BLOCK_SIZE = 1024;
    private final DataOutputStream dos;
    private final TCByteBufferAllocator buffers;
    private TCByteBuffer current = TCByteBufferFactory.getInstance(0);
    private boolean closed;
    private int written;

    public TCByteBufferOutputStream() {
        this(1024, 524288);
    }

    public TCByteBufferOutputStream(int blockSize) {
        this(blockSize, blockSize);
    }

    public TCByteBufferOutputStream(final int init, final int max) {
        this(new TCByteBufferAllocator(new Supplier<TCByteBuffer>(){
            private int blockSize;
            {
                this.blockSize = init;
            }

            @Override
            public TCByteBuffer get() {
                try {
                    TCByteBuffer tCByteBuffer = TCByteBufferFactory.getInstance(this.blockSize);
                    return tCByteBuffer;
                }
                finally {
                    this.blockSize <<= 1;
                    if (this.blockSize > max) {
                        this.blockSize = max;
                    }
                }
            }
        }));
        if (init < 1) {
            throw new IllegalArgumentException("Max block size must be greater than or equal to 1");
        }
        if (max < 1) {
            throw new IllegalArgumentException("Initial block size must be greater than or equal to 1");
        }
    }

    public TCByteBufferOutputStream(TCByteBufferAllocator bufferSrc) {
        this.buffers = bufferSrc;
        this.dos = new DataOutputStream(this);
    }

    @Override
    public void write(int b) {
        this.checkClosed();
        ++this.written;
        this.checkBuffer();
        this.current.put((byte)b);
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(TCByteBuffer data) {
        if (data == null) {
            throw new NullPointerException();
        }
        this.write(new TCByteBuffer[]{data});
    }

    private void checkBuffer() {
        while (this.current == null || !this.current.hasRemaining()) {
            this.current = this.addBuffer();
        }
    }

    @Override
    public void write(TCByteBuffer[] data) {
        this.checkClosed();
        if (data == null) {
            throw new NullPointerException();
        }
        if (data.length == 0) {
            return;
        }
        for (TCByteBuffer element : data) {
            int len = element.remaining();
            while (element.hasRemaining()) {
                this.checkBuffer();
                int saveLimit = element.limit();
                if (element.remaining() > this.current.remaining()) {
                    element.limit(element.position() + this.current.remaining());
                }
                this.current.put(element);
                Assert.assertFalse(element.hasRemaining());
                element.limit(saveLimit);
            }
            this.written += len;
        }
    }

    public int getBytesWritten() {
        return this.written;
    }

    @Override
    public void write(byte[] b, int offset, int length) {
        this.checkClosed();
        if (b == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset > b.length || length < 0 || offset + length > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        this.written += length;
        int index = offset;
        int numToWrite = length;
        while (numToWrite > 0) {
            this.checkBuffer();
            int numToPut = Math.min(this.current.remaining(), numToWrite);
            this.current.put(b, index, numToPut);
            numToWrite -= numToPut;
            index += numToPut;
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.finalizeBuffer();
            this.closed = true;
        }
    }

    @Override
    public TCReference accessBuffers() {
        this.close();
        return this.buffers.complete();
    }

    public String toString() {
        return this.buffers == null ? "null" : this.buffers.toString();
    }

    private TCByteBuffer addBuffer() {
        this.finalizeBuffer();
        return this.buffers.add();
    }

    private void finalizeBuffer() {
        if (this.current != null) {
            this.current.flip();
            this.current = null;
        }
    }

    @Override
    public void writeBoolean(boolean value) {
        try {
            this.dos.writeBoolean(value);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void writeByte(int value) {
        try {
            this.dos.writeByte(value);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void writeChar(int value) {
        try {
            this.dos.writeChar(value);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void writeDouble(double value) {
        try {
            this.dos.writeDouble(value);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void writeFloat(float value) {
        try {
            this.dos.writeFloat(value);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void writeInt(int value) {
        try {
            this.dos.writeInt(value);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void writeLong(long value) {
        try {
            this.dos.writeLong(value);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void writeShort(int value) {
        try {
            this.dos.writeShort(value);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void writeString(String string) {
        this.writeString(string, false);
    }

    private void writeString(String string, boolean force) {
        if (string == null) {
            this.writeBoolean(true);
            return;
        }
        this.writeBoolean(false);
        int mark = this.getBytesWritten();
        if (!force) {
            try {
                this.dos.write(1);
                this.dos.writeUTF(string);
                return;
            }
            catch (IOException ioe) {
                if (!(ioe instanceof UTFDataFormatException)) {
                    throw new UncheckedIOException(ioe);
                }
                this.rewind(this.getBytesWritten() - mark);
            }
        }
        try {
            this.dos.write(0);
            this.writeStringAsRawChars(string);
        }
        catch (IOException ioe2) {
            throw new UncheckedIOException(ioe2);
        }
    }

    private void writeStringAsRawChars(String string) {
        if (string == null) {
            throw new AssertionError();
        }
        this.writeInt(string.length());
        try {
            this.dos.writeChars(string);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("stream is closed");
        }
    }

    @Override
    public void writeBytes(String s) {
        throw new UnsupportedOperationException("use writeString() instead");
    }

    @Override
    public void writeChars(String s) {
        this.writeString(s, true);
    }

    @Override
    public void writeUTF(String str) {
        this.writeString(str);
    }

    private void rewind(int bytes) {
        this.buffers.rewind(bytes);
    }
}

