/*
 * Decompiled with CFR 0.152.
 */
package com.tc.bytes;

import com.tc.bytes.TCByteBuffer;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface TCReference
extends Iterable<TCByteBuffer>,
AutoCloseable {
    public TCReference duplicate();

    default public TCReference duplicate(int length) {
        return this.duplicate().truncate(length);
    }

    default public TCReference truncate(int length) {
        Iterator it = this.iterator();
        int runTo = length;
        while (it.hasNext()) {
            TCByteBuffer curs = (TCByteBuffer)it.next();
            curs.limit(Math.min(curs.position() + runTo, curs.limit()));
            runTo -= curs.remaining();
        }
        return this;
    }

    default public TCReference limit(int length) {
        Iterator it = this.iterator();
        int runTo = length;
        while (it.hasNext()) {
            TCByteBuffer curs = (TCByteBuffer)it.next();
            int min = Math.min(runTo, curs.capacity());
            curs.limit(min);
            runTo -= curs.limit();
        }
        return this;
    }

    default public long available() {
        return this.stream().mapToInt(TCByteBuffer::remaining).asLongStream().sum();
    }

    default public boolean hasRemaining() {
        return this.stream().anyMatch(TCByteBuffer::hasRemaining);
    }

    default public ByteBuffer[] toByteBufferArray() {
        return (ByteBuffer[])this.stream().map(TCByteBuffer::getNioBuffer).toArray(ByteBuffer[]::new);
    }

    default public TCByteBuffer[] toArray() {
        return (TCByteBuffer[])this.stream().toArray(TCByteBuffer[]::new);
    }

    default public Stream<TCByteBuffer> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public void returnByteBufferArray(ByteBuffer[] array) {
        TCByteBuffer[] src = this.toArray();
        for (int x = 0; x < src.length; ++x) {
            src[x].returnNioBuffer(array[x]);
        }
    }

    @Override
    public void close();
}

