/*
 *  Copyright Terracotta, Inc.
 *  Copyright IBM Corp. 2024, 2025
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package com.tc.entity;

import com.tc.object.tx.TransactionID;
import com.tc.net.protocol.tcm.TCAction;


/**
 * The generic super-interface for the entity response types since SEDA requires that each thread only process one type of message.
 * This means that the caller needs to down-cast to the specific sub-type, cased on getAckType.
 * In the future, it would be ideal to remove this in favor of a different SEDA implementation.
 */
public interface VoltronEntityResponse extends TCAction {
  TransactionID getTransactionID();
  VoltronEntityMessage.Acks getAckType();
}
