/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.tripwire;

import java.nio.file.Path;
import java.util.function.Supplier;
import org.terracotta.tripwire.ClusterInfoEvent;
import org.terracotta.tripwire.ClusterInfoMonitor;
import org.terracotta.tripwire.ClusterInfoMonitorImpl;
import org.terracotta.tripwire.DiskMonitor;
import org.terracotta.tripwire.DiskMonitorImpl;
import org.terracotta.tripwire.Event;
import org.terracotta.tripwire.MemoryMonitor;
import org.terracotta.tripwire.MemoryMonitorImpl;
import org.terracotta.tripwire.MessageEvent;
import org.terracotta.tripwire.MonitoringEvent;
import org.terracotta.tripwire.NullEvent;
import org.terracotta.tripwire.PrimeEvent;
import org.terracotta.tripwire.ReplicationEvent;
import org.terracotta.tripwire.ServerStateEvent;
import org.terracotta.tripwire.StageMonitor;
import org.terracotta.tripwire.StageMonitorImpl;
import org.terracotta.tripwire.SyncEvent;
import org.terracotta.tripwire.TripwireRecording;

public class TripwireFactory {
    private static final boolean ENABLED;

    public static Event createMessageEvent(String eid, int concurrency, String action, long source, String instance, long transaction, String trace) {
        return ENABLED ? new MessageEvent(eid, concurrency, action, source, instance, transaction, trace) : new NullEvent();
    }

    public static Event createStageEvent(String stage, String debug) {
        return ENABLED ? new MonitoringEvent(stage, debug) : new NullEvent();
    }

    public static Event createStageEvent(String stage, Object debug) {
        return ENABLED ? new MonitoringEvent(stage, debug.toString()) : new NullEvent();
    }

    public static Event createPrimeEvent(String name, byte[] uid, long session, long id) {
        return ENABLED ? new PrimeEvent(name, uid, session, id) : new NullEvent();
    }

    public static Event createReplicationEvent(long session, long sequence) {
        return ENABLED ? new ReplicationEvent(session, sequence) : new NullEvent();
    }

    public static Event createServerStateEvent(String state, boolean active) {
        return ENABLED ? new ServerStateEvent(state, active) : new NullEvent();
    }

    public static Event createSyncEvent(String name, byte[] uid, long session) {
        return ENABLED ? new SyncEvent(name, uid, session) : new NullEvent();
    }

    public static Event createClusterInfo(String info) {
        return ENABLED ? new ClusterInfoEvent(info) : new NullEvent();
    }

    public static StageMonitor createStageMonitor(String stage, int threads) {
        return ENABLED ? new StageMonitorImpl(stage, threads) : new StageMonitor(){

            @Override
            public void eventOccurred(int backlog, long value) {
            }

            @Override
            public void register() {
            }

            @Override
            public void unregister() {
            }
        };
    }

    public static ClusterInfoMonitor createClusterInfoMonitor(Supplier<String> info) {
        return ENABLED ? new ClusterInfoMonitorImpl(info) : new ClusterInfoMonitor(){

            @Override
            public void register() {
            }

            @Override
            public void unregister() {
            }
        };
    }

    public static DiskMonitor createDiskMonitor(Path path) {
        return ENABLED ? new DiskMonitorImpl(path) : new DiskMonitor(){

            @Override
            public void register() {
            }

            @Override
            public void unregister() {
            }
        };
    }

    public static MemoryMonitor createMemoryMonitor(String name) {
        return ENABLED ? new MemoryMonitorImpl(name) : new MemoryMonitor(){

            @Override
            public void sample(long free, long used) {
            }

            @Override
            public void register() {
            }

            @Override
            public void unregister() {
            }
        };
    }

    public static TripwireRecording createTripwireRecording(String configuration) {
        return TripwireFactory.createTripwireRecording(configuration, null, 5, 0L);
    }

    public static TripwireRecording createTripwireRecording(String configuration, Path dest) {
        return TripwireFactory.createTripwireRecording(configuration, dest, 5, 0L);
    }

    public static TripwireRecording createTripwireRecording(String configuration, Path dest, int maxAge, long maxSize) {
        if (ENABLED) {
            return new TripwireRecording(configuration, dest, maxAge, maxSize);
        }
        throw new UnsupportedOperationException("tripwire is unavailable");
    }

    static {
        boolean hasJFR = false;
        try {
            Class<?> jfr = Class.forName("jdk.jfr.Event");
            hasJFR = jfr != null && !Boolean.getBoolean("tripwire.logging.disable");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ENABLED = hasJFR;
    }
}

