/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol;

import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCReference;
import com.tc.bytes.TCReferenceSupport;
import com.tc.exception.TCInternalError;
import com.tc.net.protocol.TCNetworkHeader;
import com.tc.net.protocol.TCNetworkMessage;
import com.tc.util.Assert;
import com.tc.util.HexDump;
import com.tc.util.concurrent.SetOnceFlag;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCNetworkMessageImpl
implements TCNetworkMessage {
    protected static final Logger logger = LoggerFactory.getLogger(TCNetworkMessage.class);
    private static final int MESSAGE_DUMP_MAXBYTES = 4096;
    private final SetOnceFlag callbackFired = new SetOnceFlag();
    private static final TCReference EMPTY_BUFFER = TCReferenceSupport.createReference(Collections.emptyList(), null);
    private final TCNetworkHeader header;
    private TCReference payloadData;
    private TCReference entireMessageData;
    private int totalLength;
    private int dataLength;
    private int headerLength;
    private final CompletableFuture<Void> complete = new CompletableFuture();

    protected TCNetworkMessageImpl(TCNetworkHeader header) {
        Assert.eval(header != null);
        this.header = header;
    }

    @Override
    public final int getDataLength() {
        this.checkSealed();
        return this.dataLength;
    }

    @Override
    public final int getHeaderLength() {
        this.checkSealed();
        return this.headerLength;
    }

    @Override
    public final int getTotalLength() {
        this.checkSealed();
        return this.totalLength;
    }

    @Override
    public final TCNetworkHeader getHeader() {
        return this.header;
    }

    @Override
    public final TCReference getPayload() {
        Assert.eval(this.payloadData != null);
        return this.payloadData;
    }

    protected final void setPayload(TCReference newPayload) {
        Assert.eval(this.payloadData == null);
        this.payloadData = newPayload == null ? EMPTY_BUFFER : newPayload;
        this.seal();
        this.complete.thenRun(this.payloadData::close);
    }

    @Override
    public final TCReference getEntireMessageData() {
        Assert.eval(this.entireMessageData != null);
        return this.entireMessageData;
    }

    public final String toString() {
        try {
            return this.toString0();
        }
        catch (Exception e) {
            logger.warn("Exception in toString()", (Throwable)e);
            return "EXCEPTION in toString(): " + e.getMessage();
        }
    }

    protected final String toString0() {
        String payload;
        StringBuilder buf = new StringBuilder();
        buf.append("Message Class: ").append(this.getClass().getName()).append("\n");
        buf.append("Sealed: ").append(this.payloadData != null).append(", ");
        buf.append("Header Length: ").append(this.getHeaderLength()).append(", ");
        buf.append("Data Length: ").append(this.getDataLength()).append(", ");
        buf.append("Total Length: ").append(this.getTotalLength()).append("\n");
        String extraMsgInfo = this.describeMessage();
        if (extraMsgInfo != null) {
            buf.append(extraMsgInfo).append("\n");
        }
        if ((payload = this.describePayload()) != null) {
            buf.append(payload);
        }
        return buf.toString();
    }

    protected String describeMessage() {
        return null;
    }

    protected String describePayload() {
        return null;
    }

    protected String messageBytes() {
        StringBuilder buf = new StringBuilder();
        int totalBytesDumped = 0;
        if (this.payloadData != null) {
            for (TCByteBuffer i : this.payloadData) {
                buf.append("Buffer ").append(i).append(": ");
                buf.append(i.toString());
                buf.append("\n");
                if (totalBytesDumped >= 4096) continue;
                int bytesFullBuf = i.limit();
                int bytesToDump = totalBytesDumped + bytesFullBuf < 4096 ? bytesFullBuf : 4096 - totalBytesDumped;
                byte[] read = new byte[i.remaining()];
                i.duplicate().get(read);
                buf.append(HexDump.dump(read));
                totalBytesDumped += bytesToDump;
            }
        } else {
            buf.append("No payload buffers present");
        }
        return buf.toString();
    }

    protected String dump() {
        StringBuilder toRet = new StringBuilder(this.toString());
        toRet.append("\n\n");
        if (this.entireMessageData != null) {
            int count = 0;
            for (TCByteBuffer data : this.entireMessageData) {
                toRet.append('[').append(count++).append(']').append('=').append(data.toString());
                toRet.append(" =  { ");
                byte[] ba = new byte[data.remaining()];
                data.duplicate().get(ba);
                HexDump.dump(ba);
                toRet.append(" }  \n\n");
            }
        }
        return toRet.toString();
    }

    private void seal() {
        Objects.requireNonNull(this.payloadData);
        try (TCReference headerRef = TCReferenceSupport.createGCReference(this.header.getDataBuffer());){
            TCReference message = TCReferenceSupport.createAggregateReference(headerRef, this.payloadData);
            long dataLen = this.payloadData.available();
            if (dataLen + (long)this.header.getHeaderByteLength() > Integer.MAX_VALUE) {
                throw new TCInternalError("Message too big");
            }
            this.dataLength = (int)dataLen;
            this.headerLength = this.header.getHeaderByteLength();
            this.totalLength = this.headerLength + this.dataLength;
            this.entireMessageData = message;
            this.complete.thenRun(this.entireMessageData::close);
        }
    }

    @Override
    public void complete() {
        this.fireCallbacks();
    }

    private void fireCallbacks() {
        if (this.callbackFired.attemptSet()) {
            this.complete.complete(null);
        }
    }

    @Override
    public void addCompleteCallback(Runnable r) {
        this.complete.thenRun(r);
    }

    private void checkSealed() {
        if (this.payloadData == null) {
            throw new IllegalStateException("Message is not sealed");
        }
    }
}

