/*
 * Decompiled with CFR 0.152.
 */
package com.tc.bytes;

import com.tc.bytes.TCByteBuffer;
import com.tc.util.Assert;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class TCByteBufferImpl
implements TCByteBuffer {
    private final TCByteBuffer source;
    private final ByteBuffer hiddenBuffer;
    private static final boolean ACCESS_CHECK = Boolean.getBoolean("buffer.access.check");
    private final AtomicBoolean lock = ACCESS_CHECK ? new AtomicBoolean() : null;
    private final AtomicInteger references = ACCESS_CHECK ? new AtomicInteger() : null;

    TCByteBufferImpl(int capacity, boolean direct) {
        this(null, direct ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity));
    }

    private TCByteBufferImpl(TCByteBuffer src, ByteBuffer buf) {
        this.source = src;
        this.hiddenBuffer = buf;
    }

    static TCByteBuffer wrap(byte[] data) {
        return new TCByteBufferImpl(null, ByteBuffer.wrap(data));
    }

    protected ByteBuffer getBuffer() {
        return this.accessBuffer();
    }

    @Override
    public TCByteBuffer clear() {
        this.accessBuffer().clear();
        return this;
    }

    @Override
    public int capacity() {
        return this.accessBuffer().capacity();
    }

    @Override
    public int position() {
        return this.accessBuffer().position();
    }

    @Override
    public TCByteBuffer flip() {
        this.accessBuffer().flip();
        return this;
    }

    @Override
    public TCByteBuffer compact() {
        this.accessBuffer().compact();
        return this;
    }

    @Override
    public boolean hasRemaining() {
        return this.accessBuffer().hasRemaining();
    }

    @Override
    public int limit() {
        return this.accessBuffer().limit();
    }

    @Override
    public TCByteBuffer limit(int newLimit) {
        this.accessBuffer().limit(newLimit);
        return this;
    }

    @Override
    public TCByteBuffer position(int newPosition) {
        this.accessBuffer().position(newPosition);
        return this;
    }

    @Override
    public int remaining() {
        return this.accessBuffer().remaining();
    }

    @Override
    public TCByteBuffer rewind() {
        this.accessBuffer().rewind();
        return this;
    }

    private void incrementBufferReference() {
        if (this.references != null) {
            this.references.incrementAndGet();
        }
    }

    private void decrementBufferReference() {
        if (this.references != null) {
            this.references.decrementAndGet();
        }
    }

    @Override
    public ByteBuffer getNioBuffer() {
        ByteBuffer buffer = this.accessBuffer();
        this.incrementBufferReference();
        return buffer;
    }

    @Override
    public void returnNioBuffer(ByteBuffer buffer) {
        if (buffer != this.accessBuffer()) {
            throw new IllegalArgumentException("buffer is not owned");
        }
        this.decrementBufferReference();
    }

    @Override
    public boolean isDirect() {
        return this.accessBuffer().isDirect();
    }

    @Override
    public byte[] array() {
        return this.accessBuffer().array();
    }

    @Override
    public byte get() {
        return this.accessBuffer().get();
    }

    @Override
    public boolean getBoolean() {
        return this.accessBuffer().get() > 0;
    }

    @Override
    public boolean getBoolean(int index) {
        return this.accessBuffer().get(index) > 0;
    }

    @Override
    public char getChar() {
        return this.accessBuffer().getChar();
    }

    @Override
    public char getChar(int index) {
        return this.accessBuffer().getChar(index);
    }

    @Override
    public double getDouble() {
        return this.accessBuffer().getDouble();
    }

    @Override
    public double getDouble(int index) {
        return this.accessBuffer().getDouble(index);
    }

    @Override
    public float getFloat() {
        return this.accessBuffer().getFloat();
    }

    @Override
    public float getFloat(int index) {
        return this.accessBuffer().getFloat(index);
    }

    @Override
    public int getInt() {
        return this.accessBuffer().getInt();
    }

    @Override
    public int getInt(int index) {
        return this.accessBuffer().getInt(index);
    }

    @Override
    public long getLong() {
        return this.accessBuffer().getLong();
    }

    @Override
    public long getLong(int index) {
        return this.accessBuffer().getLong(index);
    }

    @Override
    public short getShort() {
        return this.accessBuffer().getShort();
    }

    @Override
    public short getShort(int index) {
        return this.accessBuffer().getShort(index);
    }

    @Override
    public TCByteBuffer get(byte[] dst) {
        this.accessBuffer().get(dst);
        return this;
    }

    @Override
    public TCByteBuffer get(byte[] dst, int offset, int length) {
        this.accessBuffer().get(dst, offset, length);
        return this;
    }

    @Override
    public byte get(int index) {
        return this.accessBuffer().get(index);
    }

    @Override
    public TCByteBuffer put(byte b) {
        this.accessBuffer().put(b);
        return this;
    }

    @Override
    public TCByteBuffer put(byte[] src) {
        this.accessBuffer().put(src);
        return this;
    }

    @Override
    public TCByteBuffer put(byte[] src, int offset, int length) {
        this.accessBuffer().put(src, offset, length);
        return this;
    }

    @Override
    public TCByteBuffer put(int index, byte b) {
        this.accessBuffer().put(index, b);
        return this;
    }

    @Override
    public TCByteBuffer putBoolean(boolean b) {
        this.accessBuffer().put(b ? (byte)1 : 0);
        return this;
    }

    @Override
    public TCByteBuffer putBoolean(int index, boolean b) {
        this.accessBuffer().put(index, b ? (byte)1 : 0);
        return this;
    }

    @Override
    public TCByteBuffer putChar(char c) {
        this.accessBuffer().putChar(c);
        return this;
    }

    @Override
    public TCByteBuffer putChar(int index, char c) {
        this.accessBuffer().putChar(index, c);
        return this;
    }

    @Override
    public TCByteBuffer putDouble(double d) {
        this.accessBuffer().putDouble(d);
        return this;
    }

    @Override
    public TCByteBuffer putDouble(int index, double d) {
        this.accessBuffer().putDouble(index, d);
        return this;
    }

    @Override
    public TCByteBuffer putFloat(float f) {
        this.accessBuffer().putFloat(f);
        return this;
    }

    @Override
    public TCByteBuffer putFloat(int index, float f) {
        this.accessBuffer().putFloat(index, f);
        return this;
    }

    @Override
    public TCByteBuffer putInt(int i) {
        this.accessBuffer().putInt(i);
        return this;
    }

    @Override
    public TCByteBuffer putInt(int index, int i) {
        this.accessBuffer().putInt(index, i);
        return this;
    }

    @Override
    public TCByteBuffer putLong(long l) {
        this.accessBuffer().putLong(l);
        return this;
    }

    @Override
    public TCByteBuffer putLong(int index, long l) {
        this.accessBuffer().putLong(index, l);
        return this;
    }

    @Override
    public TCByteBuffer putShort(short s) {
        this.accessBuffer().putShort(s);
        return this;
    }

    @Override
    public TCByteBuffer putShort(int index, short s) {
        this.accessBuffer().putShort(index, s);
        return this;
    }

    @Override
    public TCByteBuffer duplicate() {
        return new TCByteBufferImpl(this, this.accessBuffer().duplicate());
    }

    @Override
    public TCByteBuffer put(TCByteBuffer src) {
        this.accessBuffer().put(src.getNioBuffer());
        return this;
    }

    @Override
    public TCByteBuffer slice() {
        return new TCByteBufferImpl(this, this.accessBuffer().slice());
    }

    @Override
    public int arrayOffset() {
        return this.accessBuffer().arrayOffset();
    }

    @Override
    public TCByteBuffer asReadOnlyBuffer() {
        return new TCByteBufferImpl(this, this.accessBuffer().asReadOnlyBuffer());
    }

    @Override
    public boolean isReadOnly() {
        return this.accessBuffer().isReadOnly();
    }

    public String toString() {
        return this.accessBuffer() == null ? "TCByteBufferJDK14(null buffer)" : "TCByteBufferJDK14@" + System.identityHashCode(this) + "(" + this.accessBuffer().toString() + ")";
    }

    @Override
    public boolean hasArray() {
        return this.accessBuffer().hasArray();
    }

    private void checkReferences() {
        if (this.references != null && this.references.get() > 0) {
            throw new IllegalStateException("Nio buffer still referenced " + this.references.get());
        }
    }

    @Override
    public TCByteBuffer reInit() {
        this.checkReferences();
        this.clear();
        this.lock();
        return this;
    }

    @Override
    public final TCByteBuffer get(int index, byte[] dst) {
        return this.get(index, dst, 0, dst.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final TCByteBuffer get(int index, byte[] dst, int offset, int length) {
        int origPosition = this.position();
        try {
            this.position(index);
            this.get(dst, offset, length);
        }
        finally {
            this.position(origPosition);
        }
        return this;
    }

    @Override
    public final TCByteBuffer put(int index, byte[] src) {
        return this.put(index, src, 0, src.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final TCByteBuffer put(int index, byte[] src, int offset, int length) {
        int origPosition = this.position();
        try {
            this.position(index);
            this.put(src, offset, length);
        }
        finally {
            this.position(origPosition);
        }
        return this;
    }

    @Override
    public final TCByteBuffer putUint(long i) {
        if (i > 0xFFFFFFFFL || i < 0L) {
            throw new IllegalArgumentException("Unsigned integer value must be positive and <= (2^32)-1");
        }
        this.put((byte)(i >> 24 & 0xFFL));
        this.put((byte)(i >> 16 & 0xFFL));
        this.put((byte)(i >> 8 & 0xFFL));
        this.put((byte)(i & 0xFFL));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final TCByteBuffer putUint(int index, long i) {
        int origPosition = this.position();
        try {
            this.position(index);
            this.putUint(i);
        }
        finally {
            this.position(origPosition);
        }
        return this;
    }

    @Override
    public final TCByteBuffer putUshort(int s) {
        if (s > 65535 || s < 0) {
            throw new IllegalArgumentException("Unsigned integer value must be positive and <= (2^16)-1");
        }
        this.put((byte)(s >> 8 & 0xFF));
        this.put((byte)(s & 0xFF));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final TCByteBuffer putUshort(int index, int s) {
        int origPosition = this.position();
        try {
            this.position(index);
            this.putUshort(s);
        }
        finally {
            this.position(origPosition);
        }
        return this;
    }

    @Override
    public final long getUint() {
        long rv = 0L;
        rv += (long)(this.get() & 0xFF) << 24;
        rv += (long)((this.get() & 0xFF) << 16);
        rv += (long)((this.get() & 0xFF) << 8);
        return rv += (long)(this.get() & 0xFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long getUint(int index) {
        int origPosition = this.position();
        try {
            this.position(index);
            long l = this.getUint();
            return l;
        }
        finally {
            this.position(origPosition);
        }
    }

    @Override
    public final int getUshort() {
        int rv = 0;
        rv += (this.get() & 0xFF) << 8;
        Assert.eval((rv += this.get() & 0xFF) >= 0 && rv <= 65535);
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getUshort(int index) {
        int origPosition = this.position();
        try {
            this.position(index);
            int n = this.getUshort();
            return n;
        }
        finally {
            this.position(origPosition);
        }
    }

    @Override
    public final short getUbyte() {
        return (short)(this.get() & 0xFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final short getUbyte(int index) {
        int origPosition = this.position();
        try {
            this.position(index);
            short s = this.getUbyte();
            return s;
        }
        finally {
            this.position(origPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final TCByteBuffer putUbyte(int index, short value) {
        int origPosition = this.position();
        try {
            this.position(index);
            this.putUbyte(value);
        }
        finally {
            this.position(origPosition);
        }
        return this;
    }

    @Override
    public final TCByteBuffer putUbyte(short value) {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("Unsigned byte value must in range 0-255 inclusive");
        }
        this.put((byte)(value & 0xFF));
        return this;
    }

    void verifyLocked() {
        if (ACCESS_CHECK && !this.lock.get()) {
            throw new IllegalStateException("buffer is not locked");
        }
    }

    private void checkLock() {
        if (ACCESS_CHECK && this.lock.get()) {
            throw new IllegalStateException("buffer is locked");
        }
    }

    private void lock() {
        if (ACCESS_CHECK && !this.lock.compareAndSet(false, true)) {
            throw new IllegalStateException("buffer is already locked");
        }
    }

    @Override
    public TCByteBuffer unlock() {
        if (ACCESS_CHECK && !this.lock.compareAndSet(true, false)) {
            throw new IllegalStateException("buffer is not locked");
        }
        return this;
    }

    private ByteBuffer accessBuffer() {
        this.checkLock();
        return this.hiddenBuffer;
    }
}

