/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

import com.tc.bytes.TCByteBuffer;
import com.tc.exception.TCException;
import com.tc.exception.TCRuntimeException;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Conversion {
    public static final long MIN_UINT = 0L;
    public static final long MAX_UINT = 0xFFFFFFFFL;
    private static final Pattern MEMORY_SIZE_PATTERN = Pattern.compile("[0-9]*([.][0-9]+)? *([bkmg])?");
    private static final Pattern SIZE_MODIFIER_PATTERN = Pattern.compile("[bkmg]");
    private static final DecimalFormat twoDForm = new DecimalFormat();
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    private static int makeInt(byte b3, byte b2, byte b1, byte b0) {
        return (b3 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | (b0 & 0xFF) << 0;
    }

    public static byte setFlag(byte flags, int offset, boolean value) {
        if (value) {
            return (byte)(flags | offset);
        }
        return (byte)(flags & ~offset);
    }

    public static boolean getFlag(byte flags, int offset) {
        return (flags & offset) == offset;
    }

    public static short byte2uint(byte b) {
        return (short)(b & 0xFF);
    }

    public static long bytes2uint(byte[] b) {
        return Conversion.bytes2uint(b, 0, b.length);
    }

    public static long bytes2uint(byte[] b, int length) {
        return Conversion.bytes2uint(b, 0, length);
    }

    public static long bytes2uint(byte[] b, int offset, int length) {
        if (length < 1 || length > 4) {
            throw new IllegalArgumentException("invalid byte array length: " + length);
        }
        if (b.length - offset < length) {
            throw new IllegalArgumentException("not enough data available for length " + length + " starting at offset " + offset + " in a byte array of length " + b.length);
        }
        long rv = 0L;
        switch (length) {
            case 1: {
                return Conversion.byte2uint(b[offset]);
            }
            case 2: {
                rv += (long)Conversion.byte2uint(b[0 + offset]) << 8;
                return rv += (long)Conversion.byte2uint(b[1 + offset]);
            }
            case 3: {
                rv += (long)Conversion.byte2uint(b[0 + offset]) << 16;
                rv += (long)Conversion.byte2uint(b[1 + offset]) << 8;
                return rv += (long)Conversion.byte2uint(b[2 + offset]);
            }
            case 4: {
                rv += (long)Conversion.byte2uint(b[0 + offset]) << 24;
                rv += (long)Conversion.byte2uint(b[1 + offset]) << 16;
                rv += (long)Conversion.byte2uint(b[2 + offset]) << 8;
                return rv += (long)Conversion.byte2uint(b[3 + offset]);
            }
        }
        throw new RuntimeException("internal error");
    }

    public static void writeUint(long l, byte[] dest, int index) {
        if (l > 0xFFFFFFFFL || l < 0L) {
            throw new IllegalArgumentException("unsigned integer value invalid: " + l);
        }
        int pos = index;
        dest[pos++] = (byte)(l >>> 24 & 0xFFL);
        dest[pos++] = (byte)(l >>> 16 & 0xFFL);
        dest[pos++] = (byte)(l >>> 8 & 0xFFL);
        dest[pos++] = (byte)(l & 0xFFL);
    }

    public static void writeInt(int i, byte[] dest, int index) {
        dest[index] = (byte)(i >>> 24 & 0xFF);
        dest[index + 1] = (byte)(i >>> 16 & 0xFF);
        dest[index + 2] = (byte)(i >>> 8 & 0xFF);
        dest[index + 3] = (byte)(i >>> 0 & 0xFF);
    }

    public static byte[] ushort2bytes(int i) {
        if (i > 65535 || i < 0) {
            throw new IllegalArgumentException("invalid short value: " + i);
        }
        byte[] rv = new byte[]{(byte)(i >>> 8 & 0xFF), (byte)(i >>> 0 & 0xFF)};
        return rv;
    }

    public static byte[] uint2bytes(long l) {
        if (l > 0xFFFFFFFFL || l < 0L) {
            throw new IllegalArgumentException("unsigned integer value out of range: " + l);
        }
        byte[] rv = new byte[]{(byte)(l >>> 24 & 0xFFL), (byte)(l >>> 16 & 0xFFL), (byte)(l >>> 8 & 0xFFL), (byte)(l >>> 0 & 0xFFL)};
        return rv;
    }

    public static String bytes2String(byte[] bytes) {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new TCRuntimeException(e);
        }
    }

    public static byte[] string2Bytes(String string) {
        try {
            return string == null ? EMPTY_BYTE_ARRAY : string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new TCRuntimeException(e);
        }
    }

    public static boolean bytes2Boolean(byte[] bytes) {
        return bytes[0] != 0;
    }

    public static byte[] boolean2Bytes(boolean v) {
        byte[] rv = new byte[]{v ? (byte)1 : 0};
        return rv;
    }

    public static byte[] byte2Bytes(byte v) {
        return new byte[]{v};
    }

    public static char bytes2Char(byte[] bytes) {
        return (char)(bytes[0] << 8 | bytes[1] & 0xFF);
    }

    public static byte[] char2Bytes(char v) {
        return new byte[]{(byte)(0xFF & v >> 8), (byte)(0xFF & v)};
    }

    public static double bytes2Double(byte[] bytes) {
        return Double.longBitsToDouble(Conversion.bytes2Long(bytes));
    }

    public static byte[] double2Bytes(double l) {
        return Conversion.long2Bytes(Double.doubleToLongBits(l));
    }

    public static float bytes2Float(byte[] bytes) {
        return Float.intBitsToFloat(Conversion.bytes2Int(bytes));
    }

    public static byte[] float2Bytes(float l) {
        return Conversion.int2Bytes(Float.floatToIntBits(l));
    }

    public static int bytes2Int(byte[] bytes, int offset) {
        return Conversion.makeInt(bytes[offset], bytes[offset + 1], bytes[offset + 2], bytes[offset + 3]);
    }

    public static int bytes2Int(byte[] bytes) {
        return Conversion.makeInt(bytes[0], bytes[1], bytes[2], bytes[3]);
    }

    public static byte[] int2Bytes(int v) {
        byte[] rv = new byte[]{(byte)(v >>> 24 & 0xFF), (byte)(v >>> 16 & 0xFF), (byte)(v >>> 8 & 0xFF), (byte)(v >>> 0 & 0xFF)};
        return rv;
    }

    public static long bytes2Long(byte[] bytes) {
        return Conversion.bytes2Long(bytes, 0);
    }

    public static long bytes2Long(byte[] bytes, int offset) {
        return ((long)bytes[offset] << 56) + ((long)(bytes[offset + 1] & 0xFF) << 48) + ((long)(bytes[offset + 2] & 0xFF) << 40) + ((long)(bytes[offset + 3] & 0xFF) << 32) + ((long)(bytes[offset + 4] & 0xFF) << 24) + (long)((bytes[offset + 5] & 0xFF) << 16) + (long)((bytes[offset + 6] & 0xFF) << 8) + (long)((bytes[offset + 7] & 0xFF) << 0);
    }

    public static byte[] long2Bytes(long l) {
        byte[] rv = new byte[8];
        Conversion.writeLong(l, rv, 0);
        return rv;
    }

    public static void writeLong(long l, byte[] rv, int offset) {
        rv[offset] = (byte)(l >>> 56);
        rv[offset + 1] = (byte)(l >>> 48);
        rv[offset + 2] = (byte)(l >>> 40);
        rv[offset + 3] = (byte)(l >>> 32);
        rv[offset + 4] = (byte)(l >>> 24);
        rv[offset + 5] = (byte)(l >>> 16);
        rv[offset + 6] = (byte)(l >>> 8);
        rv[offset + 7] = (byte)(l >>> 0);
    }

    public static short bytes2Short(byte[] bytes) {
        return (short)(((bytes[0] & 0xFF) << 8) + ((bytes[1] & 0xFF) << 0));
    }

    public static byte[] short2Bytes(short v) {
        byte[] rv = new byte[]{(byte)(v >>> 8 & 0xFF), (byte)(v >>> 0 & 0xFF)};
        return rv;
    }

    public static boolean byte2Boolean(byte b) {
        return b != 0;
    }

    public static byte boolean2Byte(boolean value) {
        return value ? (byte)1 : 0;
    }

    public static String bytesToHex(byte[] b) {
        return Conversion.bytesToHex(b, 0, b.length);
    }

    public static String bytesToHex(byte[] b, int index, int length) {
        StringBuilder buf = new StringBuilder();
        for (int pos = index; pos >= 0 && pos < index + length && pos < b.length; ++pos) {
            byte leading = (byte)(b[pos] >>> 4 & 0xF);
            byte trailing = (byte)(b[pos] & 0xF);
            buf.append(0 <= leading && leading <= 9 ? (char)(48 + leading) : (char)(65 + (leading - 10)));
            buf.append(0 <= trailing && trailing <= 9 ? (char)(48 + trailing) : (char)(65 + (trailing - 10)));
        }
        return buf.toString();
    }

    public static byte[] hexToBytes(String hexString) {
        if (hexString == null || hexString.length() % 2 != 0) {
            return null;
        }
        int length = hexString.length();
        byte[] rv = new byte[length / 2];
        int x = 0;
        int y = 0;
        while (x < length) {
            rv[y] = Byte.parseByte(hexString.substring(x, x + 2), 16);
            x += 2;
            ++y;
        }
        return rv;
    }

    public static String buffer2String(int length, TCByteBuffer buffer) {
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        return Conversion.bytes2String(bytes);
    }

    public static int memorySizeAsIntBytes(String memorySizeInUnits) throws MetricsFormatException {
        long rv = Conversion.memorySizeAsLongBytes(memorySizeInUnits);
        if (rv > Integer.MAX_VALUE) {
            throw new MetricsFormatException(memorySizeInUnits + " is greater than integer range");
        }
        return (int)rv;
    }

    public static long memorySizeAsLongBytes(String memorySizeInUnits) throws MetricsFormatException {
        double base;
        String input = memorySizeInUnits.toLowerCase().trim();
        Matcher matcher = MEMORY_SIZE_PATTERN.matcher(input);
        if (!matcher.matches()) {
            throw new MetricsFormatException("Unexpected Size: " + input);
        }
        String[] str = SIZE_MODIFIER_PATTERN.split(input);
        if (str.length > 1) {
            throw new MetricsFormatException("Unexpected size: " + input);
        }
        try {
            base = Double.parseDouble(str[0].trim());
        }
        catch (NumberFormatException nfe) {
            throw new MetricsFormatException("Unexpectes metrics: " + input);
        }
        if (input.endsWith(MemorySizeUnits.KILO.getUnit())) {
            return (long)(base * (double)MemorySizeUnits.KILO.asBytes());
        }
        if (input.endsWith(MemorySizeUnits.MEGA.getUnit())) {
            return (long)(base * (double)MemorySizeUnits.MEGA.asBytes());
        }
        if (input.endsWith(MemorySizeUnits.GIGA.getUnit())) {
            return (long)(base * (double)MemorySizeUnits.GIGA.asBytes());
        }
        return (long)base;
    }

    public static String memoryBytesAsSize(long bytes) throws NumberFormatException {
        if (bytes < MemorySizeUnits.KILO.asBytes()) {
            return bytes + "b";
        }
        if (bytes < MemorySizeUnits.MEGA.asBytes()) {
            double rv = (double)bytes / ((double)MemorySizeUnits.KILO.asBytes() * 1.0);
            return twoDForm.format(rv) + 'k';
        }
        if (bytes < MemorySizeUnits.GIGA.asBytes()) {
            double rv = (double)bytes / ((double)MemorySizeUnits.MEGA.asBytes() * 1.0);
            return twoDForm.format(rv) + 'm';
        }
        double rv = (double)bytes / ((double)MemorySizeUnits.GIGA.asBytes() * 1.0);
        return twoDForm.format(rv) + 'g';
    }

    public static String toJvmArgument(long bytes) {
        if (bytes < 0L) {
            throw new IllegalArgumentException("Size in bytes cannot be negative");
        }
        if (bytes < MemorySizeUnits.KILO.asBytes()) {
            return bytes + "b";
        }
        if (bytes < MemorySizeUnits.MEGA.asBytes()) {
            return Conversion.toKilo(bytes);
        }
        if (bytes < MemorySizeUnits.GIGA.asBytes()) {
            return Conversion.toMega(bytes);
        }
        if (bytes % MemorySizeUnits.GIGA.asBytes() == 0L) {
            return bytes / MemorySizeUnits.GIGA.asBytes() + "g";
        }
        return Conversion.toMega(bytes);
    }

    private static String toKilo(long bytes) {
        if (bytes % MemorySizeUnits.KILO.asBytes() == 0L) {
            return bytes / MemorySizeUnits.KILO.asBytes() + "k";
        }
        return bytes / MemorySizeUnits.KILO.asBytes() + 1L + "k";
    }

    private static String toMega(long bytes) {
        if (bytes % MemorySizeUnits.MEGA.asBytes() == 0L) {
            return bytes / MemorySizeUnits.MEGA.asBytes() + "m";
        }
        return bytes / MemorySizeUnits.MEGA.asBytes() + 1L + "m";
    }

    static {
        twoDForm.applyLocalizedPattern("#" + new DecimalFormatSymbols().getDecimalSeparator() + "##");
    }

    public static class MetricsFormatException
    extends TCException {
        public MetricsFormatException(String message) {
            super(message);
        }
    }

    public static enum MemorySizeUnits {
        KILO("k", 1024L),
        MEGA("m", 1024L * MemorySizeUnits.KILO.longValue),
        GIGA("g", 1024L * MemorySizeUnits.MEGA.longValue);

        private final String unit;
        private final long longValue;

        private MemorySizeUnits(String unit, long value) {
            this.unit = unit;
            this.longValue = value;
        }

        public long asBytes() {
            return this.longValue;
        }

        public String toString() {
            return '\'' + this.unit + '\'';
        }

        public String getUnit() {
            return this.unit;
        }
    }
}

