/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.entity.VoltronEntityMessage;
import com.tc.net.protocol.tcm.NetworkRecall;
import com.tc.net.protocol.tcm.TCAction;
import com.tc.object.EntityID;
import com.tc.object.ExceptionUtils;
import com.tc.object.InFlightStats;
import com.tc.object.SafeInvocationCallback;
import com.tc.object.StatType;
import com.tc.object.tx.TransactionID;
import com.tc.text.PrettyPrintable;
import com.tc.tracing.Trace;
import com.tc.util.Assert;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class InFlightMessage
implements PrettyPrintable {
    private final VoltronEntityMessage message;
    private final EntityID eid;
    private final SafeInvocationCallback<byte[]> callback;
    private final EnumSet<VoltronEntityMessage.Acks> outstandingAcks = EnumSet.allOf(VoltronEntityMessage.Acks.class);
    private Exception exception;
    private byte[] value;
    private final Trace trace;
    private final AtomicReference<State> state = new AtomicReference<State>(State.PENDING);
    private volatile long start;
    private volatile long send;
    private volatile long notifySent;
    private volatile long sent;
    private volatile long received;
    private volatile long complete;
    private volatile long retired;
    private volatile long end;
    private long[] serverStats;
    private NetworkRecall networkMessage;

    public InFlightMessage(EntityID eid, Supplier<? extends VoltronEntityMessage> message, SafeInvocationCallback<byte[]> callback) {
        this.eid = Objects.requireNonNull(eid);
        this.message = Objects.requireNonNull(message.get());
        this.callback = callback;
        this.trace = Trace.newTrace(this.message, "InFlightMessage");
    }

    void setStatisticsBoundries(long start, long end) {
        this.start = start;
        this.end = end;
    }

    public long[] collect() {
        long[] stats = new long[StatType.END.ordinal()];
        if (stats != null) {
            stats[StatType.CLIENT_ENCODE.ordinal()] = this.start;
            stats[StatType.CLIENT_SEND.ordinal()] = this.send;
            stats[StatType.CLIENT_SENT.ordinal()] = this.sent;
            stats[StatType.CLIENT_COMPLETE.ordinal()] = this.complete;
            stats[StatType.CLIENT_RECEIVED.ordinal()] = this.received;
            stats[StatType.CLIENT_RETIRED.ordinal()] = this.retired;
            stats[StatType.CLIENT_DECODED.ordinal()] = this.end;
            if (this.serverStats != null) {
                stats[StatType.SERVER_ADD.ordinal()] = this.serverStats[StatType.SERVER_ADD.serverSpot()];
                stats[StatType.SERVER_SCHEDULE.ordinal()] = this.serverStats[StatType.SERVER_SCHEDULE.serverSpot()];
                stats[StatType.SERVER_BEGININVOKE.ordinal()] = this.serverStats[StatType.SERVER_BEGININVOKE.serverSpot()];
                stats[StatType.SERVER_ENDINVOKE.ordinal()] = this.serverStats[StatType.SERVER_ENDINVOKE.serverSpot()];
                stats[StatType.SERVER_RECEIVED.ordinal()] = this.serverStats[StatType.SERVER_RECEIVED.serverSpot()];
                stats[StatType.SERVER_RETIRED.ordinal()] = this.serverStats[StatType.SERVER_RETIRED.serverSpot()];
                stats[StatType.SERVER_COMPLETE.ordinal()] = this.serverStats[StatType.SERVER_COMPLETE.serverSpot()];
            }
        }
        return stats;
    }

    @Override
    public Map<String, ?> getStateMap() {
        ArrayList<InFlightStats.Combo> values = new ArrayList<InFlightStats.Combo>(20);
        long[] collect = this.collect();
        values.add(new InFlightStats.Combo(StatType.CLIENT_ENCODE, StatType.CLIENT_SEND).add(collect));
        values.add(new InFlightStats.Combo(StatType.CLIENT_SEND, StatType.CLIENT_SENT).add(collect));
        values.add(new InFlightStats.Combo(StatType.CLIENT_SENT, StatType.CLIENT_RECEIVED).add(collect));
        values.add(new InFlightStats.Combo(StatType.CLIENT_RECEIVED, StatType.CLIENT_COMPLETE).add(collect));
        values.add(new InFlightStats.Combo(StatType.CLIENT_COMPLETE, StatType.CLIENT_GOT).add(collect));
        values.add(new InFlightStats.Combo(StatType.CLIENT_GOT, StatType.CLIENT_DECODED).add(collect));
        values.add(new InFlightStats.Combo(StatType.CLIENT_COMPLETE, StatType.CLIENT_RETIRED).add(collect));
        values.add(new InFlightStats.Combo(StatType.CLIENT_SENT, StatType.CLIENT_RETIRED).add(collect));
        values.add(new InFlightStats.Combo(StatType.CLIENT_ENCODE, StatType.CLIENT_DECODED).add(collect));
        values.add(new InFlightStats.Combo(StatType.SERVER_ADD, StatType.SERVER_SCHEDULE).add(collect));
        values.add(new InFlightStats.Combo(StatType.SERVER_SCHEDULE, StatType.SERVER_BEGININVOKE).add(collect));
        values.add(new InFlightStats.Combo(StatType.SERVER_BEGININVOKE, StatType.SERVER_ENDINVOKE).add(collect));
        values.add(new InFlightStats.Combo(StatType.SERVER_RECEIVED, StatType.SERVER_COMPLETE).add(collect));
        values.add(new InFlightStats.Combo(StatType.SERVER_COMPLETE, StatType.SERVER_RETIRED).add(collect));
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("entity", this.eid);
        LinkedHashMap<String, Long> timing = new LinkedHashMap<String, Long>();
        timing.put("send", this.send);
        timing.put("sent", this.sent);
        timing.put("notifySent", this.notifySent);
        timing.put("received", this.received);
        timing.put("complete", this.complete);
        timing.put("retired", this.retired);
        map.put("marks", timing);
        LinkedHashMap offset = new LinkedHashMap();
        values.forEach(c -> offset.put(c.toString(), c.value()));
        map.put("timing", offset);
        return map;
    }

    public EntityID getEntityID() {
        return this.eid;
    }

    public VoltronEntityMessage getMessage() {
        return this.message;
    }

    public TransactionID getTransactionID() {
        return this.message.getTransactionID();
    }

    public boolean send() {
        Trace.activeTrace().log("InFlightMessage.send()");
        this.send = System.nanoTime();
        try {
            this.networkMessage = ((TCAction)((Object)this.message)).send();
            boolean bl = this.networkMessage != null;
            return bl;
        }
        finally {
            this.sent = System.nanoTime();
        }
    }

    synchronized void sent() {
        if (this.ackDelivered(VoltronEntityMessage.Acks.SENT)) {
            this.notifySent = System.nanoTime();
        }
    }

    synchronized void received() {
        if (this.ackDelivered(VoltronEntityMessage.Acks.RECEIVED)) {
            this.received = System.nanoTime();
        }
    }

    public void setResult(byte[] value, Exception error) {
        if (Trace.isTraceEnabled()) {
            this.trace.log("Received Result: " + value + " ; Exception: " + (error != null ? error.getLocalizedMessage() : "None"));
        }
        if (this.ackDelivered(VoltronEntityMessage.Acks.RECEIVED)) {
            this.received = System.nanoTime();
        }
        if (this.outstandingAcks.contains((Object)VoltronEntityMessage.Acks.COMPLETED)) {
            try {
                if (error != null) {
                    Assert.assertNull(value);
                    this.exception = error;
                    this.handleException(this.exception);
                } else {
                    Assert.assertNotNull(value);
                    this.value = value;
                    this.handleMessage(value);
                }
            }
            finally {
                this.complete = System.nanoTime();
                this.ackDelivered(VoltronEntityMessage.Acks.COMPLETED);
            }
        }
    }

    void handleException(Exception ee) {
        this.callback.failure(ExceptionUtils.convert(ee));
    }

    void handleMessage(byte[] raw) {
        this.callback.result(raw);
    }

    private boolean ackDelivered(VoltronEntityMessage.Acks ack) {
        if (Trace.isTraceEnabled()) {
            this.trace.log("Received ACK: " + (Object)((Object)ack));
        }
        if (this.outstandingAcks.remove((Object)ack)) {
            switch (ack) {
                case SENT: {
                    this.callback.sent();
                    break;
                }
                case RECEIVED: {
                    this.callback.received();
                    break;
                }
                case COMPLETED: {
                    this.callback.complete();
                    break;
                }
                case RETIRED: {
                    this.callback.retired();
                }
            }
            return true;
        }
        return false;
    }

    public void retired() {
        if (this.ackDelivered(VoltronEntityMessage.Acks.RETIRED)) {
            this.retired = System.nanoTime();
            if (this.message.getVoltronType() == VoltronEntityMessage.Type.INVOKE_ACTION) {
                Assert.assertTrue("failed " + this.message.getTransactionID(), this.value != null || this.exception != null);
            }
        }
    }

    void addServerStatistics(long[] stats) {
        this.serverStats = stats;
    }

    public boolean commit() {
        return this.state.compareAndSet(State.PENDING, State.COMMITTED) || State.COMMITTED.equals((Object)this.state.get());
    }

    public boolean cancel() {
        return !(this.networkMessage != null && !this.networkMessage.recall() || !this.state.compareAndSet(State.PENDING, State.CANCELLED) && !State.CANCELLED.equals((Object)this.state.get()));
    }

    static enum State {
        PENDING,
        COMMITTED,
        CANCELLED;

    }
}

