/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.inet;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.terracotta.inet.HostAndIpValidator;

public class HostPort {
    private static final String INVALID_HOST_OR_IP_MESSAGE = "Server must be an RFC 1123 compliant hostname or a valid IP address";
    private final String host;
    private final int port;

    private HostPort(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        if (HostAndIpValidator.isValidIPv6(this.host, false)) {
            return "[" + this.host + "]:" + this.port;
        }
        return this.host + ":" + this.port;
    }

    public InetSocketAddress createInetSocketAddress() {
        return InetSocketAddress.createUnresolved(this.host, this.port);
    }

    public static HostPort create(InetSocketAddress address) {
        Objects.requireNonNull(address);
        return HostPort.create(address.getHostString(), address.getPort());
    }

    public static HostPort create(String host, int port) {
        Objects.requireNonNull(host);
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port out of range");
        }
        if (host.startsWith("[")) {
            host = host.substring(1);
        }
        if (host.endsWith("]")) {
            host = host.substring(0, Math.max(0, host.length() - 1));
        }
        if (host.isEmpty()) {
            throw new IllegalArgumentException("host name can not be blank");
        }
        return new HostPort(host, port);
    }

    public static List<HostPort> parse(String[] hostPorts, int defaultPort) {
        ArrayList<HostPort> serversList = new ArrayList<HostPort>();
        for (String hostPort : hostPorts) {
            serversList.add(HostPort.parse(hostPort, defaultPort));
        }
        return serversList;
    }

    public static List<HostPort> parse(String ... hostPorts) {
        ArrayList<HostPort> serversList = new ArrayList<HostPort>();
        for (String hostPort : hostPorts) {
            serversList.add(HostPort.parse(hostPort));
        }
        return serversList;
    }

    public static HostPort parse(String hostPort, int defaultPort) {
        int lastColon = hostPort.lastIndexOf(":");
        if (lastColon == -1) {
            if (!HostAndIpValidator.isValidIPv4(hostPort) && !HostAndIpValidator.isValidHost(hostPort)) {
                throw new IllegalArgumentException(INVALID_HOST_OR_IP_MESSAGE);
            }
            return HostPort.create(hostPort, defaultPort);
        }
        if (HostAndIpValidator.isValidIPv6(hostPort)) {
            return HostPort.create(hostPort, defaultPort);
        }
        return HostPort.parse(hostPort);
    }

    public static HostPort parse(String hostPort) {
        int lastColon = hostPort.lastIndexOf(":");
        if (lastColon == -1 || HostAndIpValidator.isValidIPv6(hostPort)) {
            throw new IllegalArgumentException("Missing port: " + hostPort);
        }
        String hostOrIp = hostPort.substring(0, lastColon);
        if (!(HostAndIpValidator.isValidIPv4(hostOrIp) || HostAndIpValidator.isValidHost(hostOrIp) || HostAndIpValidator.isValidIPv6(hostOrIp, true))) {
            throw new IllegalArgumentException(INVALID_HOST_OR_IP_MESSAGE);
        }
        return HostPort.create(hostOrIp, Integer.parseInt(hostPort.substring(lastColon + 1)));
    }

    public boolean isWildcard() {
        return this.host.equals("0.0.0.0") || this.host.equals("::");
    }

    public final boolean equals(Object o) {
        if (!(o instanceof HostPort)) {
            return false;
        }
        HostPort that = (HostPort)o;
        boolean sameHost = this.host == null ? that.host == null : this.host.equalsIgnoreCase(that.host);
        return sameHost && this.port == that.port;
    }

    public final int hashCode() {
        return Objects.hash(this.host.toLowerCase(), this.port);
    }
}

