/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.exception.TCRuntimeException;
import com.tc.logging.ConnectionIdLogger;
import com.tc.net.CommStackMismatchException;
import com.tc.net.MaxConnectionsExceededException;
import com.tc.net.ReconnectionRejectedException;
import com.tc.net.core.TCConnection;
import com.tc.net.core.TCConnectionManager;
import com.tc.net.core.event.TCConnectionEvent;
import com.tc.net.protocol.NetworkStackID;
import com.tc.net.protocol.TCNetworkMessage;
import com.tc.net.protocol.TCProtocolAdaptor;
import com.tc.net.protocol.transport.MessageTransportBase;
import com.tc.net.protocol.transport.MessageTransportListener;
import com.tc.net.protocol.transport.MessageTransportState;
import com.tc.net.protocol.transport.MessageTransportStatus;
import com.tc.net.protocol.transport.NoActiveException;
import com.tc.net.protocol.transport.ReconnectionRejectedHandler;
import com.tc.net.protocol.transport.ReconnectionRejectedHandlerL1;
import com.tc.net.protocol.transport.SynAckMessage;
import com.tc.net.protocol.transport.TransportHandshakeError;
import com.tc.net.protocol.transport.TransportHandshakeErrorContext;
import com.tc.net.protocol.transport.TransportHandshakeErrorHandler;
import com.tc.net.protocol.transport.TransportHandshakeException;
import com.tc.net.protocol.transport.TransportHandshakeMessage;
import com.tc.net.protocol.transport.TransportHandshakeMessageFactory;
import com.tc.net.protocol.transport.TransportRedirect;
import com.tc.net.protocol.transport.WireProtocolAdaptorFactory;
import com.tc.net.protocol.transport.WireProtocolMessage;
import com.tc.net.protocol.transport.WireProtocolMessageSink;
import com.tc.properties.TCPropertiesImpl;
import com.tc.util.Assert;
import com.tc.util.TCTimeoutException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.LoggerFactory;

public class ClientMessageTransport
extends MessageTransportBase {
    public static final long TRANSPORT_HANDSHAKE_SYNACK_TIMEOUT = TCPropertiesImpl.getProperties().getLong("tc.transport.handshake.timeout", 10000L);
    private final TCConnectionManager connectionManager;
    private CompletableFuture<NetworkStackID> opener;
    private CompletableFuture<SynAckMessage> waitForSynAckResult;
    private final WireProtocolAdaptorFactory wireProtocolAdaptorFactory;
    private final int callbackPort;
    private final int timeout;
    private final ReconnectionRejectedHandler reconnectionRejectedHandler;

    public ClientMessageTransport(TCConnectionManager clientConnectionEstablisher, TransportHandshakeErrorHandler handshakeErrorHandler, TransportHandshakeMessageFactory messageFactory, WireProtocolAdaptorFactory wireProtocolAdaptorFactory, int callbackPort, int timeout) {
        this(clientConnectionEstablisher, handshakeErrorHandler, messageFactory, wireProtocolAdaptorFactory, callbackPort, timeout, ReconnectionRejectedHandlerL1.SINGLETON);
    }

    public ClientMessageTransport(TCConnectionManager connectionManager, TransportHandshakeErrorHandler handshakeErrorHandler, TransportHandshakeMessageFactory messageFactory, WireProtocolAdaptorFactory wireProtocolAdaptorFactory, int callbackPort, int timeout, ReconnectionRejectedHandler reconnectionRejectedHandler) {
        super(MessageTransportState.STATE_START, handshakeErrorHandler, messageFactory, LoggerFactory.getLogger(ClientMessageTransport.class));
        this.wireProtocolAdaptorFactory = wireProtocolAdaptorFactory;
        this.connectionManager = connectionManager;
        this.callbackPort = callbackPort;
        this.timeout = timeout;
        this.reconnectionRejectedHandler = reconnectionRejectedHandler;
    }

    @Override
    public NetworkStackID open(InetSocketAddress serverAddress) throws TCTimeoutException, IOException, MaxConnectionsExceededException, CommStackMismatchException {
        CompletableFuture<NetworkStackID> opening = this.startOpen();
        if (opening != null) {
            try {
                return (NetworkStackID)opening.get();
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof TCTimeoutException) {
                    throw (TCTimeoutException)cause;
                }
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof MaxConnectionsExceededException) {
                    throw (MaxConnectionsExceededException)cause;
                }
                if (cause instanceof CommStackMismatchException) {
                    throw (CommStackMismatchException)cause;
                }
                throw new IOException(cause);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
        Assert.eval("can't open an already open transport", !this.status.isAlive());
        Assert.eval("can't open an already connected transport", !this.isConnected());
        TCConnection connection = null;
        try {
            connection = this.connect(serverAddress);
            this.openConnection(connection);
            NetworkStackID nid = new NetworkStackID(this.getConnectionID().getChannelID());
            if (connection.isClosed()) {
                throw new IOException("closed");
            }
            this.finishOpen(nid);
            return nid;
        }
        catch (CommStackMismatchException | MaxConnectionsExceededException | TCTimeoutException | IOException | RuntimeException e) {
            this.finishOpenWithException(e);
            if (connection != null) {
                connection.close();
            }
            throw e;
        }
    }

    TCConnection connect(InetSocketAddress sa) throws TCTimeoutException, IOException {
        TCConnection connection = this.connectionManager.createConnection(this.getProtocolAdapter());
        if (connection == null) {
            throw new IOException("failed to create a new connection");
        }
        this.fireTransportConnectAttemptEvent();
        try {
            connection.connect(sa, this.timeout);
        }
        catch (IOException e) {
            connection.close();
            throw e;
        }
        catch (TCTimeoutException e) {
            connection.close();
            throw e;
        }
        return connection;
    }

    @Override
    public void reset() {
        this.getLogger().info("Resetting connection " + this.getConnectionID());
        this.disconnect();
        this.clearConnection();
        this.clearConnectionID();
    }

    private void handleHandshakeError(HandshakeResult result) throws TransportHandshakeException, MaxConnectionsExceededException, CommStackMismatchException, ReconnectionRejectedException {
        if (result.hasErrorContext()) {
            switch (result.getError()) {
                case ERROR_NO_ACTIVE: {
                    if (this.getProductID().isRedirectEnabled()) {
                        throw new NoActiveException();
                    }
                    Assert.assertTrue(this.getProductID().isInternal());
                    break;
                }
                case ERROR_MAX_CONNECTION_EXCEED: {
                    this.cleanConnectionWithoutNotifyListeners();
                    throw new MaxConnectionsExceededException(this.getMaxConnectionsExceededMessage(result.maxConnections()));
                }
                case ERROR_STACK_MISMATCH: {
                    this.cleanConnectionWithoutNotifyListeners();
                    throw new CommStackMismatchException("Disconnected due to comm stack mismatch");
                }
                case ERROR_RECONNECTION_REJECTED: {
                    this.fireTransportReconnectionRejectedEvent();
                    this.cleanConnectionWithoutNotifyListeners();
                    throw new ReconnectionRejectedException("Reconnection rejected by L2 due to stack not found. Client will be unable to join the cluster again unless rejoin is enabled.");
                }
                case ERROR_REDIRECT_CONNECTION: {
                    if (this.getProductID().isRedirectEnabled()) {
                        throw new TransportRedirect(result.synAck.getErrorContext());
                    }
                    Assert.assertTrue(this.getProductID().isInternal());
                    break;
                }
                default: {
                    throw new TransportHandshakeException("Disconnected due to transport handshake error: " + (Object)((Object)result.getError()));
                }
            }
        }
    }

    private void cleanConnectionWithoutNotifyListeners() {
        ArrayList<MessageTransportListener> tl = new ArrayList<MessageTransportListener>(this.getTransportListeners());
        this.removeTransportListeners();
        this.clearConnection();
        this.clearConnectionID();
        this.addTransportListeners(tl);
    }

    public synchronized boolean wasOpened() {
        return this.opener != null && this.opener.isDone();
    }

    private synchronized CompletableFuture<NetworkStackID> startOpen() {
        if (this.opener == null) {
            this.opener = new CompletableFuture();
            return null;
        }
        return this.opener;
    }

    private synchronized void finishOpenWithException(Throwable e) {
        this.opener.completeExceptionally(e);
        this.opener = null;
    }

    private synchronized void finishOpen(NetworkStackID didOpen) {
        this.opener.complete(didOpen);
    }

    private synchronized boolean isOpening() {
        return this.opener != null && !this.opener.isDone();
    }

    @Override
    public void closeEvent(TCConnectionEvent event) {
        if (!this.isOpening() && !this.status.isAlive()) {
            return;
        }
        super.closeEvent(event);
        this.clearAckWaiter(new IOException("connection closed"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void receiveTransportMessageImpl(WireProtocolMessage message) {
        boolean receive = false;
        if (this.status.isEstablished()) {
            receive = true;
        } else {
            MessageTransportStatus messageTransportStatus = this.status;
            synchronized (messageTransportStatus) {
                if (this.status.isSynSent()) {
                    this.handleSynAck(message);
                } else if (!this.status.isEstablished()) {
                    this.getLogger().debug("Ignoring the message received for an Un-Established Connection; " + message.getSource() + "; " + message);
                } else {
                    receive = true;
                }
            }
        }
        if (receive) {
            super.receiveToReceiveLayer(message);
        }
    }

    private void handleSynAck(WireProtocolMessage message) {
        if (!this.verifySynAck(message)) {
            this.handleHandshakeError(new TransportHandshakeErrorContext("Received a message that was not a SYN_ACK while waiting for SYN_ACK: " + message, TransportHandshakeError.ERROR_HANDSHAKE));
            this.clearAckWaiter(new IOException("expecting syn ack but got " + message.getClass().getName()));
        } else {
            SynAckMessage synAck = (SynAckMessage)message;
            if (synAck.hasErrorContext()) {
                if (synAck.getErrorType() == TransportHandshakeError.ERROR_STACK_MISMATCH) {
                    this.handleHandshakeError(new TransportHandshakeErrorContext(this.getCommsStackMismatchErrorMessage(synAck) + "\n\nPLEASE RECONFIGURE THE STACKS", synAck.getErrorType()));
                } else {
                    this.handleHandshakeError(new TransportHandshakeErrorContext(synAck.getErrorContext() + " " + message, synAck.getErrorType()));
                }
            } else if (!this.getConnectionID().isNewConnection() && this.getConnectionID().isValid()) {
                Assert.eval(this.getConnectionID().equals(synAck.getConnectionId()));
            }
            this.getConnection().setTransportEstablished();
            this.setSynAckResult(synAck);
            this.setRemoteCallbackPort(synAck.getCallbackPort());
        }
    }

    private synchronized CompletableFuture<SynAckMessage> createAckWaiter() throws TransportHandshakeException {
        if (this.waitForSynAckResult != null) {
            throw new TransportHandshakeException("duplicate handshake");
        }
        this.waitForSynAckResult = new CompletableFuture();
        return this.waitForSynAckResult;
    }

    private synchronized void clearAckWaiter(Throwable e) {
        if (this.waitForSynAckResult != null) {
            this.waitForSynAckResult.completeExceptionally(e);
            this.waitForSynAckResult = null;
        }
    }

    private synchronized void setSynAckResult(SynAckMessage msg) {
        if (this.waitForSynAckResult != null) {
            this.waitForSynAckResult.complete(msg);
            this.waitForSynAckResult = null;
        }
    }

    private String getCommsStackMismatchErrorMessage(SynAckMessage synAck) {
        String errorMessage = "\n\nLayers Present in Client side communication stack: ";
        errorMessage = errorMessage + this.getCommunicationStackNames(this);
        errorMessage = "\nTHERE IS A MISMATCH IN THE COMMUNICATION STACKS\n" + synAck.getErrorContext() + errorMessage;
        if ((this.getCommunicationStackFlags(this) & 2) != 0) {
            this.getLogger().error("Once and Only Once Protocol Layer is present in client but not in server");
            errorMessage = "\n\nOnce and Only Once Protocol Layer is present in client but not in server" + errorMessage;
        } else {
            this.getLogger().error("Once and Only Once Protocol Layer is present in server but not in client");
            errorMessage = "\n\nOnce and Only Once Protocol Layer is present in server but not in client" + errorMessage;
        }
        return errorMessage;
    }

    private boolean verifySynAck(TCNetworkMessage message) {
        return message instanceof TransportHandshakeMessage && ((TransportHandshakeMessage)message).isSynAck();
    }

    HandshakeResult handShake() throws TCTimeoutException, TransportHandshakeException {
        try {
            SynAckMessage synAck = this.sendSyn().get(TRANSPORT_HANDSHAKE_SYNACK_TIMEOUT, TimeUnit.MILLISECONDS);
            return new HandshakeResult(synAck);
        }
        catch (TransportHandshakeException t) {
            this.clearAckWaiter(t);
            throw t;
        }
        catch (InterruptedException e) {
            this.clearAckWaiter(e);
            throw new TransportHandshakeException(e);
        }
        catch (ExecutionException e) {
            this.clearAckWaiter(e.getCause());
            throw new TransportHandshakeException(e.getCause());
        }
        catch (TimeoutException e) {
            this.clearAckWaiter(e);
            throw new TCTimeoutException(e);
        }
        catch (Throwable t) {
            this.clearAckWaiter(t);
            throw new TransportHandshakeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<SynAckMessage> sendSyn() throws TransportHandshakeException {
        CompletableFuture<SynAckMessage> targetFuture = this.createAckWaiter();
        MessageTransportStatus messageTransportStatus = this.status;
        synchronized (messageTransportStatus) {
            if (!this.status.isAlive() || !this.status.isConnected()) {
                this.logger.warn("transport in the incorrect state {}", (Object)this.status);
                this.clearAckWaiter(new IOException("closed"));
                return targetFuture;
            }
            if (this.status.isEstablished() || this.status.isSynSent()) {
                throw new AssertionError((Object)(" ERROR !!! " + this.status));
            }
            short stackLayerFlags = this.getCommunicationStackFlags(this);
            TransportHandshakeMessage syn = this.messageFactory.createSyn(this.getConnectionID(), this.getConnection(), stackLayerFlags, this.callbackPort);
            try {
                this.sendToConnection(syn);
                if (!targetFuture.isCompletedExceptionally()) {
                    this.status.synSent();
                }
            }
            catch (IOException ioe) {
                this.logger.warn("trouble syn", ioe);
            }
        }
        return targetFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAck() throws TransportHandshakeException {
        MessageTransportStatus messageTransportStatus = this.status;
        synchronized (messageTransportStatus) {
            if (!this.status.isSynSent()) {
                throw new TransportHandshakeException("Transport is not " + (Object)((Object)MessageTransportState.STATE_SYN_SENT) + ". Status: " + this.status);
            }
            TransportHandshakeMessage ack = this.messageFactory.createAck(this.getConnectionID(), this.getConnection());
            try {
                this.sendToConnection(ack);
            }
            catch (IOException ioe) {
                throw new TransportHandshakeException(ioe);
            }
            this.status.established();
        }
        this.fireTransportConnectedEvent();
    }

    protected void openConnection(TCConnection connection) throws TCTimeoutException, TransportHandshakeException, MaxConnectionsExceededException, CommStackMismatchException {
        Assert.eval(!this.isConnected());
        if (this.wireNewConnection(connection)) {
            try {
                this.handshakeConnection();
            }
            catch (TCTimeoutException e) {
                this.clearConnection();
                this.clearConnectionID();
                throw e;
            }
            catch (ReconnectionRejectedException e) {
                throw new TCRuntimeException("Should not happen here: " + e);
            }
            catch (TransportHandshakeException e) {
                this.clearConnection();
                this.clearConnectionID();
                throw e;
            }
        } else {
            throw new TransportHandshakeException("connection closed");
        }
    }

    void reopen(InetSocketAddress serverAddress) throws TCTimeoutException, ReconnectionRejectedException, MaxConnectionsExceededException, CommStackMismatchException, IOException {
        if (!this.wasOpened()) {
            this.getLogger().info("Transport never opened. Skip reconnect " + serverAddress);
            return;
        }
        this.reconnect(serverAddress);
    }

    void reconnect(InetSocketAddress socket) throws TCTimeoutException, ReconnectionRejectedException, MaxConnectionsExceededException, CommStackMismatchException, IOException {
        TCConnection connection = this.connect(socket);
        Assert.eval(!this.isConnected());
        if (this.wireNewConnection(connection)) {
            try {
                this.handshakeConnection();
                if (!connection.isConnected()) {
                    throw new IOException("closed");
                }
            }
            catch (TCTimeoutException exp) {
                this.clearConnection();
                throw exp;
            }
            catch (IOException io) {
                this.clearConnection();
                throw io;
            }
        }
    }

    private void handshakeConnection() throws TCTimeoutException, MaxConnectionsExceededException, TransportHandshakeException, CommStackMismatchException, ReconnectionRejectedException {
        HandshakeResult result = this.handShake();
        this.handleHandshakeError(result);
        this.initConnectionID(result.synAck.getConnectionId());
        this.sendAck();
        this.log("Handshake is complete");
    }

    private String getMaxConnectionsExceededMessage(int maxConnections) {
        return "Your product key only allows maximum " + maxConnections + " clients to connect.";
    }

    TCProtocolAdaptor getProtocolAdapter() {
        return this.wireProtocolAdaptorFactory.newWireProtocolAdaptor(new WireProtocolMessageSink(){

            @Override
            public void putMessage(WireProtocolMessage message) {
                ClientMessageTransport.this.receiveTransportMessage(message);
            }
        });
    }

    @Override
    protected void fireTransportConnectAttemptEvent() {
        super.fireTransportConnectAttemptEvent();
    }

    @Override
    public boolean isConnected() {
        return super.isConnected();
    }

    public void switchLoggerForTesting(ConnectionIdLogger tmpLogger) {
        this.logger = tmpLogger;
    }

    @Override
    public void sendToConnection(TCNetworkMessage message) throws IOException {
        super.sendToConnection(message);
    }

    boolean isRetryOnReconnectionRejected() {
        return this.reconnectionRejectedHandler.isRetryOnReconnectionRejected();
    }

    private static final class HandshakeResult {
        private final SynAckMessage synAck;

        private HandshakeResult(SynAckMessage synAck) {
            this.synAck = synAck;
        }

        public int maxConnections() {
            return this.synAck.getMaxConnections();
        }

        public boolean hasErrorContext() {
            return this.synAck.isMaxConnectionsExceeded() || this.synAck.hasErrorContext();
        }

        public boolean isConnectionValid() {
            return this.synAck.getConnectionId().isValid();
        }

        public TransportHandshakeError getError() {
            if (this.synAck.isMaxConnectionsExceeded()) {
                return TransportHandshakeError.ERROR_MAX_CONNECTION_EXCEED;
            }
            return this.synAck.getErrorType();
        }
    }
}

