/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol;

import com.tc.bytes.TCByteBuffer;
import com.tc.exception.TCInternalError;
import com.tc.net.protocol.TCNetworkHeader;
import com.tc.net.protocol.TCNetworkMessage;
import com.tc.util.Assert;
import com.tc.util.HexDump;
import com.tc.util.concurrent.SetOnceFlag;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCNetworkMessageImpl
implements TCNetworkMessage {
    protected static final Logger logger = LoggerFactory.getLogger(TCNetworkMessage.class);
    private static final int MESSAGE_DUMP_MAXBYTES = 4096;
    private final SetOnceFlag callbackFired = new SetOnceFlag();
    private static final TCByteBuffer[] EMPTY_BUFFER_ARRAY = new TCByteBuffer[0];
    private final TCNetworkHeader header;
    private TCByteBuffer[] payloadData;
    private TCByteBuffer[] entireMessageData;
    private int totalLength;
    private int dataLength;
    private int headerLength;
    private final CompletableFuture<Void> complete = new CompletableFuture();

    public TCNetworkMessageImpl(TCNetworkHeader header, TCByteBuffer[] payload) {
        this(header);
        this.setPayload(payload);
    }

    protected TCNetworkMessageImpl(TCNetworkHeader header) {
        Assert.eval(header != null);
        this.header = header;
    }

    @Override
    public final int getDataLength() {
        this.checkSealed();
        return this.dataLength;
    }

    @Override
    public final int getHeaderLength() {
        this.checkSealed();
        return this.headerLength;
    }

    @Override
    public final int getTotalLength() {
        this.checkSealed();
        return this.totalLength;
    }

    @Override
    public final TCNetworkHeader getHeader() {
        return this.header;
    }

    @Override
    public final TCByteBuffer[] getPayload() {
        Assert.eval(this.payloadData != null);
        return this.payloadData;
    }

    protected final void setPayload(TCByteBuffer[] newPayload) {
        Assert.eval(this.payloadData == null);
        this.payloadData = newPayload == null ? EMPTY_BUFFER_ARRAY : newPayload;
        this.seal();
    }

    @Override
    public final TCByteBuffer[] getEntireMessageData() {
        Assert.eval(this.entireMessageData != null);
        return this.entireMessageData;
    }

    public final String toString() {
        try {
            return this.toString0();
        }
        catch (Exception e) {
            logger.warn("Exception in toString()", (Throwable)e);
            return "EXCEPTION in toString(): " + e.getMessage();
        }
    }

    protected final String toString0() {
        String payload;
        StringBuilder buf = new StringBuilder();
        buf.append("Message Class: ").append(this.getClass().getName()).append("\n");
        buf.append("Sealed: ").append(this.payloadData != null).append(", ");
        buf.append("Header Length: ").append(this.getHeaderLength()).append(", ");
        buf.append("Data Length: ").append(this.getDataLength()).append(", ");
        buf.append("Total Length: ").append(this.getTotalLength()).append("\n");
        String extraMsgInfo = this.describeMessage();
        if (extraMsgInfo != null) {
            buf.append(extraMsgInfo).append("\n");
        }
        if ((payload = this.describePayload()) != null) {
            buf.append(payload);
        }
        return buf.toString();
    }

    protected String describeMessage() {
        return null;
    }

    protected String describePayload() {
        return null;
    }

    protected String messageBytes() {
        StringBuilder buf = new StringBuilder();
        int totalBytesDumped = 0;
        if (this.payloadData != null && this.payloadData.length != 0) {
            for (int i = 0; i < this.payloadData.length; ++i) {
                buf.append("Buffer ").append(i).append(": ");
                if (this.payloadData[i] != null) {
                    buf.append(this.payloadData[i].toString());
                    buf.append("\n");
                    if (totalBytesDumped >= 4096) continue;
                    int bytesFullBuf = this.payloadData[i].limit();
                    int bytesToDump = totalBytesDumped + bytesFullBuf < 4096 ? bytesFullBuf : 4096 - totalBytesDumped;
                    buf.append(HexDump.dump(this.payloadData[i].array(), this.payloadData[i].arrayOffset(), bytesToDump));
                    totalBytesDumped += bytesToDump;
                    continue;
                }
                buf.append("null");
            }
        } else {
            buf.append("No payload buffers present");
        }
        return buf.toString();
    }

    protected String dump() {
        StringBuilder toRet = new StringBuilder(this.toString());
        toRet.append("\n\n");
        if (this.entireMessageData != null) {
            for (int i = 0; i < this.entireMessageData.length; ++i) {
                byte[] ba;
                toRet.append('[').append(i).append(']').append('=').append(this.entireMessageData[i].toString());
                toRet.append(" =  { ");
                for (byte element : ba = this.entireMessageData[i].array()) {
                    toRet.append(Byte.toString(element)).append(' ');
                }
                toRet.append(" }  \n\n");
            }
        }
        return toRet.toString();
    }

    private final void seal() {
        int size = 1 + this.payloadData.length;
        this.entireMessageData = new TCByteBuffer[size];
        this.entireMessageData[0] = this.header.getDataBuffer();
        System.arraycopy(this.payloadData, 0, this.entireMessageData, 1, this.payloadData.length);
        long dataLen = 0L;
        for (int i = 1; i < this.entireMessageData.length; ++i) {
            dataLen += (long)this.entireMessageData[i].remaining();
        }
        if (dataLen > Integer.MAX_VALUE) {
            throw new TCInternalError("Message too big");
        }
        this.dataLength = (int)dataLen;
        this.headerLength = this.header.getHeaderByteLength();
        this.totalLength = this.headerLength + this.dataLength;
    }

    @Override
    public void complete() {
        this.fireCallbacks();
    }

    private void fireCallbacks() {
        if (this.callbackFired.attemptSet()) {
            this.complete.complete(null);
        }
    }

    @Override
    public void addCompleteCallback(Runnable r) {
        this.complete.thenRun(r);
    }

    @Override
    public Runnable stealCompleteAction() {
        this.callbackFired.set();
        return () -> this.complete.complete(null);
    }

    private void checkSealed() {
        if (this.payloadData == null) {
            throw new IllegalStateException("Message is not sealed");
        }
    }
}

