/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.service;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;

public class Props {
    public static final String EOL = "\n";

    public static Properties load(String content) {
        return Props.load(new StringReader(content));
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public static Properties load(Path propertiesFile) {
        Objects.requireNonNull(propertiesFile);
        if (propertiesFile.getFileName() == null || !propertiesFile.getFileName().toString().endsWith(".properties")) {
            throw new IllegalArgumentException("Expected a properties file, but got " + propertiesFile.getFileName());
        }
        Properties props = new Properties();
        try (InputStreamReader in = new InputStreamReader(Files.newInputStream(propertiesFile, new OpenOption[0]), StandardCharsets.UTF_8);){
            props.load(in);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read config file: " + propertiesFile.getFileName() + ". Make sure the file exists and is readable", e);
        }
        return props;
    }

    public static Properties load(InputStream inputStream) {
        Properties props = new Properties();
        try {
            props.load(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return props;
    }

    public static Properties load(Reader reader) {
        Properties props = new Properties();
        try {
            props.load(reader);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return props;
    }

    public static String toString(Properties properties) {
        return Props.toString(properties, null);
    }

    public static String toString(Properties properties, String comment) {
        StringWriter out = new StringWriter();
        Props.store(out, properties, comment);
        while (out.getBuffer().charAt(out.getBuffer().length() - 1) == '\r' || out.getBuffer().charAt(out.getBuffer().length() - 1) == '\n') {
            out.getBuffer().deleteCharAt(out.getBuffer().length() - 1);
        }
        return out.toString().replace("\r", "");
    }

    public static void store(Writer out, final Properties properties, String comment) {
        try {
            StringWriter tmp = new StringWriter();
            Properties copy = new Properties(){
                private static final long serialVersionUID = 1L;

                @Override
                public synchronized Enumeration<Object> keys() {
                    return Collections.enumeration(this.keySet());
                }

                @Override
                public Enumeration<?> propertyNames() {
                    return Collections.enumeration(this.stringPropertyNames());
                }

                @Override
                public Set<String> stringPropertyNames() {
                    return Collections.unmodifiableSet(new TreeSet<String>(properties.stringPropertyNames()));
                }

                @Override
                public synchronized Enumeration<Object> elements() {
                    return super.elements();
                }

                @Override
                public Set<Object> keySet() {
                    return new TreeSet<Object>(properties.keySet());
                }

                @Override
                public Set<Map.Entry<Object, Object>> entrySet() {
                    LinkedHashSet<Map.Entry<Object, Object>> set = new LinkedHashSet<Map.Entry<Object, Object>>();
                    this.stringPropertyNames().forEach((? super T key) -> set.add(new AbstractMap.SimpleEntry<String, String>((String)key, properties.getProperty((String)key))));
                    return set;
                }

                @Override
                public synchronized void forEach(BiConsumer<? super Object, ? super Object> action) {
                    this.entrySet().forEach((? super T e) -> action.accept(e.getKey(), e.getValue()));
                }
            };
            copy.putAll((Map<?, ?>)properties);
            copy.store(tmp, comment);
            while (tmp.getBuffer().charAt(tmp.getBuffer().length() - 1) == '\r' || tmp.getBuffer().charAt(tmp.getBuffer().length() - 1) == '\n') {
                tmp.getBuffer().deleteCharAt(tmp.getBuffer().length() - 1);
            }
            String content = tmp.toString().replace("\r", "");
            int secondLineStart = content.indexOf(10) + 1;
            if (secondLineStart != 0) {
                content = comment == null ? content.substring(secondLineStart) : content.substring(0, secondLineStart) + content.substring(content.indexOf(10, secondLineStart) + 1);
            }
            out.write(content);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

