/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.tripwire;

import java.util.concurrent.TimeUnit;
import jdk.jfr.Category;
import jdk.jfr.Label;
import jdk.jfr.Period;
import jdk.jfr.StackTrace;
import jdk.jfr.Timespan;
import org.terracotta.tripwire.Event;

@Category(value={"Tripwire"})
@Period(value="1 s")
@Label(value="Stage")
@StackTrace(value=false)
class StageEvent
extends jdk.jfr.Event
implements Event {
    private final String stage;
    private final int threads;
    private int count;
    @Label(value="Min Backlog")
    private int min;
    @Label(value="Max Backlog")
    private int max;
    @Timespan(value="MILLISECONDS")
    private long runtime;

    StageEvent(String stage, int threads) {
        this.stage = stage;
        this.threads = threads;
    }

    void setStats(int count, int min, int max, long runtime) {
        this.count = count;
        this.min = min;
        this.max = max;
        this.runtime = TimeUnit.NANOSECONDS.toMillis(runtime);
    }

    boolean hasCount() {
        return this.count > 0;
    }

    @Override
    public void setDescription(String description) {
    }
}

