/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.async.api.EventHandler;
import com.tc.async.api.EventHandlerException;
import com.tc.async.api.Sink;
import com.tc.cluster.ClientChannelEventController;
import com.tc.entity.DiagnosticMessageImpl;
import com.tc.entity.DiagnosticResponse;
import com.tc.entity.DiagnosticResponseImpl;
import com.tc.entity.LinearVoltronEntityMultiResponse;
import com.tc.entity.NetworkVoltronEntityMessageImpl;
import com.tc.entity.ReplayVoltronEntityMultiResponse;
import com.tc.entity.VoltronEntityAppliedResponseImpl;
import com.tc.entity.VoltronEntityMultiResponse;
import com.tc.entity.VoltronEntityReceivedResponseImpl;
import com.tc.entity.VoltronEntityResponse;
import com.tc.entity.VoltronEntityRetiredResponseImpl;
import com.tc.lang.TCThreadGroup;
import com.tc.logging.ClientIDLoggerProvider;
import com.tc.net.CommStackMismatchException;
import com.tc.net.MaxConnectionsExceededException;
import com.tc.net.core.TCConnectionManager;
import com.tc.net.protocol.PlainNetworkStackHarnessFactory;
import com.tc.net.protocol.tcm.ChannelEvent;
import com.tc.net.protocol.tcm.ChannelEventListener;
import com.tc.net.protocol.tcm.ClientMessageChannel;
import com.tc.net.protocol.tcm.CommunicationsManager;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.MessageMonitorImpl;
import com.tc.net.protocol.tcm.TCAction;
import com.tc.net.protocol.tcm.TCMessageHydrateAndConvertSink;
import com.tc.net.protocol.tcm.TCMessageHydrateSink;
import com.tc.net.protocol.tcm.TCMessageRouter;
import com.tc.net.protocol.tcm.TCMessageRouterImpl;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.net.protocol.transport.HealthCheckerConfigClientImpl;
import com.tc.net.protocol.transport.NullConnectionPolicy;
import com.tc.net.protocol.transport.ReconnectionRejectedHandlerL1;
import com.tc.net.protocol.transport.TransportHandshakeException;
import com.tc.object.ClientBuilder;
import com.tc.object.ClientEntityManager;
import com.tc.object.ClientShutdownManager;
import com.tc.object.StandardClientBuilderFactory;
import com.tc.object.handler.ClientCoordinationHandler;
import com.tc.object.handshakemanager.ClientHandshakeManager;
import com.tc.object.handshakemanager.ClientHandshakeManagerImpl;
import com.tc.object.msg.ClientHandshakeAckMessageImpl;
import com.tc.object.msg.ClientHandshakeMessage;
import com.tc.object.msg.ClientHandshakeMessageFactory;
import com.tc.object.msg.ClientHandshakeMessageImpl;
import com.tc.object.msg.ClientHandshakeRefusedMessageImpl;
import com.tc.object.msg.ClientHandshakeResponse;
import com.tc.object.msg.ClusterMembershipMessage;
import com.tc.object.request.MultiRequestReceiveHandler;
import com.tc.object.request.RequestReceiveHandler;
import com.tc.productinfo.ProductInfo;
import com.tc.properties.TCProperties;
import com.tc.properties.TCPropertiesImpl;
import com.tc.stats.counter.CounterManager;
import com.tc.stats.counter.CounterManagerImpl;
import com.tc.text.MapListPrettyPrint;
import com.tc.util.Assert;
import com.tc.util.CommonShutDownHook;
import com.tc.util.TCTimeoutException;
import com.tc.util.UUID;
import com.tc.util.concurrent.SetOnceFlag;
import com.tc.util.concurrent.SetOnceRef;
import com.tc.util.concurrent.ThreadUtil;
import com.tc.util.runtime.ThreadDumpUtil;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedObjectClient {
    protected static final Logger DSO_LOGGER = LoggerFactory.getLogger(DistributedObjectClient.class);
    private final ClientBuilder clientBuilder;
    private final Iterable<InetSocketAddress> serverAddresses;
    private final TCThreadGroup threadGroup;
    private ClientMessageChannel channel;
    private TCConnectionManager connectionManager;
    private CommunicationsManager communicationsManager;
    private ClientHandshakeManager clientHandshakeManager;
    private CounterManager counterManager;
    private final String uuid;
    private final String name;
    private final ClientShutdownManager shutdownManager = new ClientShutdownManager(this);
    private final SetOnceFlag clientStopped = new SetOnceFlag();
    private final SetOnceFlag connectionMade = new SetOnceFlag();
    private final SetOnceRef<Thread> connectionThread = new SetOnceRef();
    private final SetOnceRef<Exception> exceptionMade = new SetOnceRef();
    private ClientEntityManager clientEntityManager;

    public DistributedObjectClient(Iterable<InetSocketAddress> serverAddresses, TCThreadGroup threadGroup, Properties properties) {
        this(serverAddresses, new StandardClientBuilderFactory("terracotta").create(properties), threadGroup, UUID.NULL_ID.toString(), "");
    }

    public DistributedObjectClient(Iterable<InetSocketAddress> serverAddresses, ClientBuilder builder, TCThreadGroup threadGroup, String uuid, String name) {
        Assert.assertNotNull(serverAddresses);
        this.serverAddresses = serverAddresses;
        this.threadGroup = threadGroup;
        this.clientBuilder = builder;
        this.uuid = uuid;
        this.name = name;
    }

    public boolean isShutdown() {
        return this.clientStopped.isSet();
    }

    public boolean connectFor(long timeout, TimeUnit units) throws InterruptedException {
        ClientMessageChannel client = this.internalStart(this.getSocketConnectTimeout());
        this.setClientMessageChannel(client);
        this.connectionThread.set(new Thread(this.threadGroup, () -> {
            while (!(this.connectionMade.isSet() || this.clientStopped.isSet() || this.exceptionMade.isSet())) {
                this.connectionSequence(client);
            }
        }, "Connection Maker - " + this.uuid));
        this.connectionThread.get().start();
        try {
            return this.waitForConnection(timeout, units);
        }
        catch (Error | InterruptedException | RuntimeException e) {
            this.shutdown();
            throw e;
        }
    }

    private int getSocketConnectTimeout() {
        TCProperties tcProperties = TCPropertiesImpl.getProperties();
        int socketConnectTimeout = tcProperties.getInt("l1.socket.connect.timeout");
        if (socketConnectTimeout < 0) {
            throw new IllegalArgumentException("invalid socket time value: " + socketConnectTimeout);
        }
        return socketConnectTimeout;
    }

    public boolean connectOnce() {
        try {
            if (!this.directConnect(this.internalStart(this.getSocketConnectTimeout()))) {
                this.shutdown();
                return false;
            }
            return true;
        }
        catch (Error | RuntimeException t) {
            this.shutdown();
            throw t;
        }
    }

    private synchronized ClientMessageChannel internalStart(int socketTimeout) {
        TCProperties tcProperties = TCPropertiesImpl.getProperties();
        PlainNetworkStackHarnessFactory networkStackHarnessFactory = new PlainNetworkStackHarnessFactory();
        this.counterManager = new CounterManagerImpl();
        TCMessageRouterImpl messageRouter = new TCMessageRouterImpl();
        HealthCheckerConfigClientImpl hc = new HealthCheckerConfigClientImpl(tcProperties.getPropertiesFor("l1.healthcheck.l2"), "TC Client");
        this.connectionManager = this.clientBuilder.createConnectionManager(this.uuid, this.name);
        MessageMonitor mm = MessageMonitorImpl.createMonitor(tcProperties, DSO_LOGGER, this.threadGroup, this.connectionManager);
        this.communicationsManager = this.clientBuilder.createCommunicationsManager(mm, messageRouter, networkStackHarnessFactory, new NullConnectionPolicy(), this.connectionManager, hc, this.getMessageTypeClassMapping(), ReconnectionRejectedHandlerL1.SINGLETON);
        DSO_LOGGER.debug("Created CommunicationsManager.");
        ClientMessageChannel clientChannel = this.clientBuilder.createClientMessageChannel(this.communicationsManager, socketTimeout);
        ClientIDLoggerProvider cidLoggerProvider = new ClientIDLoggerProvider(() -> clientChannel.getClientID());
        DSO_LOGGER.debug("Created channel.");
        this.clientEntityManager = this.clientBuilder.createClientEntityManager(clientChannel);
        RequestReceiveHandler singleMessageReceiver = new RequestReceiveHandler(this.clientEntityManager);
        MultiRequestReceiveHandler mutil = new MultiRequestReceiveHandler(this.clientEntityManager);
        Sink<VoltronEntityMultiResponse> multiResponseSink = EventHandler.directSink(mutil);
        clientChannel.addAttachment("ChannelStats", () -> {
            LinkedHashMap map = new LinkedHashMap();
            map.put("messageHandler", mutil.getStateMap());
            return map;
        }, true);
        ProductInfo pInfo = ProductInfo.getInstance(this.getClass().getClassLoader());
        ClientHandshakeMessageFactory chmf = (u, n, c, r) -> {
            ClientMessageChannel cmc = this.getClientMessageChannel();
            if (cmc != null) {
                ClientHandshakeMessage rv = (ClientHandshakeMessage)cmc.createMessage(TCMessageType.CLIENT_HANDSHAKE_MESSAGE);
                rv.setClientVersion(c);
                rv.setClientRevision(r);
                rv.setClientPID(this.getPID());
                rv.setUUID(u);
                rv.setName(n);
                return rv;
            }
            return null;
        };
        this.clientHandshakeManager = this.clientBuilder.createClientHandshakeManager(cidLoggerProvider.getLogger(ClientHandshakeManagerImpl.class), chmf, this.uuid, this.name, pInfo.version(), pInfo.buildRevision(), this.clientEntityManager);
        ClientChannelEventController.connectChannelEventListener(clientChannel, this.clientHandshakeManager);
        ClientCoordinationHandler handshake = new ClientCoordinationHandler(this.clientHandshakeManager);
        this.initChannelMessageRouter(messageRouter, EventHandler.directSink(handshake), multiResponseSink, this.clientEntityManager, singleMessageReceiver);
        return clientChannel;
    }

    private boolean directConnect(ClientMessageChannel clientChannel) {
        try {
            this.setClientMessageChannel(clientChannel);
            clientChannel.open(this.serverAddresses);
            this.waitForHandshake(clientChannel);
            this.connectionMade();
            return true;
        }
        catch (CommStackMismatchException | MaxConnectionsExceededException | TCTimeoutException tt) {
            DSO_LOGGER.error(tt.getMessage());
            throw new IllegalStateException(tt);
        }
        catch (IOException io) {
            DSO_LOGGER.debug("connection error", (Throwable)io);
            return false;
        }
    }

    private void connectionSequence(ClientMessageChannel clientChannel) {
        try {
            this.openChannel(clientChannel);
            this.waitForHandshake(clientChannel);
            this.connectionMade();
        }
        catch (InterruptedException | RuntimeException runtime) {
            this.exceptionMade.set(runtime);
        }
    }

    private void connectionMade() {
        this.connectionMade.attemptSet();
    }

    public void addShutdownHook(Runnable r) {
        this.shutdownManager.registerBeforeShutdownHook(r);
    }

    private boolean waitForConnection(long timeout, TimeUnit units) throws InterruptedException {
        if (!this.connectionThread.isSet()) {
            throw new IllegalStateException("not started");
        }
        this.connectionThread.get().join(units.toMillis(timeout));
        if (this.exceptionMade.isSet()) {
            Exception exp = this.exceptionMade.get();
            throw new RuntimeException(exp);
        }
        if (!this.connectionMade.isSet()) {
            this.shutdown();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openChannel(ClientMessageChannel channel) throws InterruptedException {
        long waitTime = 0L;
        while (!this.clientStopped.isSet()) {
            SetOnceFlag setOnceFlag;
            try {
                waitTime = Math.min(Math.max(Math.round((double)waitTime * 1.5), 1000L), 30000L);
                DSO_LOGGER.debug("Trying to open channel....");
                channel.open(this.serverAddresses);
                DSO_LOGGER.debug("Channel open");
                break;
            }
            catch (TCTimeoutException tcte) {
                DSO_LOGGER.info("Unable to connect to server/s {} ...sleeping for {} sec.", this.serverAddresses, (Object)TimeUnit.MILLISECONDS.toSeconds(waitTime));
                DSO_LOGGER.debug("Timeout connecting to server/s: {} {}", this.serverAddresses, (Object)tcte.getMessage());
                setOnceFlag = this.clientStopped;
                synchronized (setOnceFlag) {
                    this.clientStopped.wait(waitTime);
                }
            }
            catch (ConnectException e) {
                DSO_LOGGER.info("Unable to connect to server/s {} ...sleeping for {} sec.", this.serverAddresses, (Object)TimeUnit.MILLISECONDS.toSeconds(waitTime));
                DSO_LOGGER.debug("Connection refused from server/s: {} {}", this.serverAddresses, (Object)e.getMessage());
                setOnceFlag = this.clientStopped;
                synchronized (setOnceFlag) {
                    this.clientStopped.wait(waitTime);
                }
            }
            catch (MaxConnectionsExceededException e) {
                DSO_LOGGER.error(e.getMessage());
                throw new IllegalStateException(e.getMessage(), e);
            }
            catch (CommStackMismatchException e) {
                DSO_LOGGER.error(e.getMessage());
                throw new IllegalStateException(e.getMessage(), e);
            }
            catch (TransportHandshakeException handshake) {
                DSO_LOGGER.error(handshake.getMessage());
                throw new IllegalStateException(handshake.getMessage(), handshake);
            }
            catch (IOException ioe) {
                DSO_LOGGER.info("Unable to connect to server/s {} ...sleeping for {} sec.", this.serverAddresses, (Object)TimeUnit.MILLISECONDS.toSeconds(waitTime));
                DSO_LOGGER.debug("IOException connecting to server/s: {} {}", this.serverAddresses, (Object)ioe.getMessage());
                setOnceFlag = this.clientStopped;
                synchronized (setOnceFlag) {
                    this.clientStopped.wait(waitTime);
                }
            }
        }
    }

    private void waitForHandshake(ClientMessageChannel channel) {
        this.clientHandshakeManager.waitForHandshake();
        ClientMessageChannel cmc = this.getClientMessageChannel();
        if (cmc != null) {
            InetSocketAddress remoteAddress = cmc.getRemoteAddress();
            String infoMsg = "Connection successfully established to server at " + remoteAddress;
            if (!channel.getProductID().isInternal() && channel.isConnected()) {
                DSO_LOGGER.info(infoMsg);
            }
        }
    }

    private Map<TCMessageType, Class<? extends TCAction>> getMessageTypeClassMapping() {
        HashMap<TCMessageType, Class<? extends TCAction>> messageTypeClassMapping = new HashMap<TCMessageType, Class<? extends TCAction>>();
        messageTypeClassMapping.put(TCMessageType.CLIENT_HANDSHAKE_MESSAGE, ClientHandshakeMessageImpl.class);
        messageTypeClassMapping.put(TCMessageType.CLIENT_HANDSHAKE_ACK_MESSAGE, ClientHandshakeAckMessageImpl.class);
        messageTypeClassMapping.put(TCMessageType.CLIENT_HANDSHAKE_REFUSED_MESSAGE, ClientHandshakeRefusedMessageImpl.class);
        messageTypeClassMapping.put(TCMessageType.CLUSTER_MEMBERSHIP_EVENT_MESSAGE, ClusterMembershipMessage.class);
        messageTypeClassMapping.put(TCMessageType.VOLTRON_ENTITY_MESSAGE, NetworkVoltronEntityMessageImpl.class);
        messageTypeClassMapping.put(TCMessageType.VOLTRON_ENTITY_RECEIVED_RESPONSE, VoltronEntityReceivedResponseImpl.class);
        messageTypeClassMapping.put(TCMessageType.VOLTRON_ENTITY_COMPLETED_RESPONSE, VoltronEntityAppliedResponseImpl.class);
        messageTypeClassMapping.put(TCMessageType.VOLTRON_ENTITY_RETIRED_RESPONSE, VoltronEntityRetiredResponseImpl.class);
        messageTypeClassMapping.put(TCMessageType.VOLTRON_ENTITY_MULTI_RESPONSE, LinearVoltronEntityMultiResponse.class);
        messageTypeClassMapping.put(TCMessageType.DIAGNOSTIC_REQUEST, DiagnosticMessageImpl.class);
        messageTypeClassMapping.put(TCMessageType.DIAGNOSTIC_RESPONSE, DiagnosticResponseImpl.class);
        return messageTypeClassMapping;
    }

    private void initChannelMessageRouter(TCMessageRouter messageRouter, Sink<ClientHandshakeResponse> ack, Sink<VoltronEntityMultiResponse> multiSink, ClientEntityManager cem, final RequestReceiveHandler single) {
        Function<VoltronEntityResponse, VoltronEntityMultiResponse> multiConverter = response -> new ReplayVoltronEntityMultiResponse((VoltronEntityResponse)response){
            final /* synthetic */ VoltronEntityResponse val$response;
            {
                this.val$response = voltronEntityResponse;
            }

            @Override
            public int replay(VoltronEntityMultiResponse.ReplayReceiver receiver) {
                try {
                    single.handleEvent(this.val$response);
                    return 1;
                }
                catch (EventHandlerException ee) {
                    throw new RuntimeException(ee);
                }
            }
        };
        messageRouter.routeMessageType(TCMessageType.CLIENT_HANDSHAKE_ACK_MESSAGE, new TCMessageHydrateSink<ClientHandshakeResponse>(ack));
        messageRouter.routeMessageType(TCMessageType.CLIENT_HANDSHAKE_REFUSED_MESSAGE, new TCMessageHydrateSink<ClientHandshakeResponse>(ack));
        messageRouter.routeMessageType(TCMessageType.CLIENT_HANDSHAKE_REDIRECT_MESSAGE, new TCMessageHydrateSink<ClientHandshakeResponse>(ack));
        messageRouter.routeMessageType(TCMessageType.CLUSTER_MEMBERSHIP_EVENT_MESSAGE, new TCMessageHydrateSink<Object>(context -> {}));
        messageRouter.routeMessageType(TCMessageType.VOLTRON_ENTITY_RECEIVED_RESPONSE, new TCMessageHydrateAndConvertSink<VoltronEntityResponse, VoltronEntityMultiResponse>(multiSink, multiConverter));
        messageRouter.routeMessageType(TCMessageType.VOLTRON_ENTITY_COMPLETED_RESPONSE, new TCMessageHydrateAndConvertSink<VoltronEntityResponse, VoltronEntityMultiResponse>(multiSink, multiConverter));
        messageRouter.routeMessageType(TCMessageType.VOLTRON_ENTITY_RETIRED_RESPONSE, new TCMessageHydrateAndConvertSink<VoltronEntityResponse, VoltronEntityMultiResponse>(multiSink, multiConverter));
        messageRouter.routeMessageType(TCMessageType.VOLTRON_ENTITY_MULTI_RESPONSE, new TCMessageHydrateSink<VoltronEntityMultiResponse>(multiSink));
        messageRouter.routeMessageType(TCMessageType.DIAGNOSTIC_RESPONSE, new TCMessageHydrateAndConvertSink<DiagnosticResponse, Void>(null, r -> {
            cem.complete(r.getTransactionID(), r.getResponse());
            return null;
        }));
        DSO_LOGGER.debug("Added message routing types.");
    }

    public ClientEntityManager getEntityManager() {
        return this.clientEntityManager;
    }

    public String getClientState() {
        MapListPrettyPrint printer = new MapListPrettyPrint();
        this.clientEntityManager.prettyPrint(printer);
        return ((Object)printer).toString();
    }

    public void dump() {
        DSO_LOGGER.info(this.getClientState());
        DSO_LOGGER.info(ThreadDumpUtil.getThreadDump());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdownResources() {
        ClientMessageChannel clientChannel;
        Logger logger = DSO_LOGGER;
        if (this.counterManager != null) {
            try {
                this.counterManager.shutdown();
            }
            catch (Throwable t) {
                logger.error("error shutting down counter manager", t);
            }
            finally {
                this.counterManager = null;
            }
        }
        if (this.clientHandshakeManager != null) {
            this.clientHandshakeManager.shutdown();
        }
        if ((clientChannel = this.getClientMessageChannel()) != null) {
            try {
                clientChannel.close();
            }
            catch (Throwable t) {
                logger.error("Error closing channel", t);
            }
        }
        if (this.communicationsManager != null) {
            try {
                this.communicationsManager.shutdown();
            }
            catch (Throwable t) {
                logger.error("Error shutting down communications manager", t);
            }
            finally {
                this.communicationsManager = null;
            }
        }
        if (this.connectionManager != null) {
            try {
                this.connectionManager.shutdown();
            }
            catch (Throwable t) {
                logger.error("Error shutting down connection manager", t);
            }
            finally {
                this.connectionManager = null;
            }
        }
        CommonShutDownHook.shutdown();
        if (this.threadGroup != null) {
            long timeout = TCPropertiesImpl.getProperties().getLong("l1.shutdown.threadgroup.gracetime");
            SetOnceFlag interrupted = new SetOnceFlag();
            try {
                if (!this.threadGroup.retire(timeout, e -> interrupted.attemptSet())) {
                    logger.warn("Timed out waiting for TC thread group threads to die for connection " + this.name + "/" + this.uuid + " - probable shutdown memory leak\n in thread group " + this.threadGroup);
                    this.threadGroup.printLiveThreads(arg_0 -> ((Logger)logger).warn(arg_0));
                    ThreadUtil.executeInThread(this.threadGroup.getParent(), () -> {
                        if (!this.threadGroup.retire(timeout, e -> interrupted.attemptSet())) {
                            this.threadGroup.interrupt();
                        }
                    }, this.name + " - Connection Reaper", true);
                }
            }
            catch (Throwable t) {
                logger.error("Error destroying TC thread group", t);
            }
            finally {
                if (interrupted.isSet()) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (TCPropertiesImpl.getProperties().getBoolean("l1.shutdown.force.finalization")) {
            System.runFinalization();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.connectionThread.isSet()) {
            this.connectionThread.get().interrupt();
        }
        if (this.clientStopped.attemptSet()) {
            SetOnceFlag setOnceFlag = this.clientStopped;
            synchronized (setOnceFlag) {
                this.clientStopped.notifyAll();
            }
            ClientMessageChannel clientChannel = this.getClientMessageChannel();
            if (clientChannel != null && !clientChannel.getProductID().isInternal() && clientChannel.isConnected()) {
                DSO_LOGGER.info("closing down Terracotta Connection channel=" + clientChannel.getChannelID() + " client=" + clientChannel.getClientID());
            }
            this.shutdownManager.execute();
        }
    }

    private int getPID() {
        String vmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = vmName.indexOf(64);
        if (index < 0) {
            throw new RuntimeException("unexpected format: " + vmName);
        }
        return Integer.parseInt(vmName.substring(0, index));
    }

    private synchronized ClientMessageChannel getClientMessageChannel() {
        return this.channel;
    }

    private synchronized void setClientMessageChannel(ClientMessageChannel channel) {
        ClientMessageChannel old = this.channel;
        this.channel = channel;
        channel.addListener(new ChannelEventListener(){

            @Override
            public void notifyChannelEvent(ChannelEvent event) {
                switch (event.getType()) {
                    case TRANSPORT_CLOSED_EVENT: 
                    case TRANSPORT_RECONNECTION_REJECTED_EVENT: {
                        DSO_LOGGER.info("shutting down due to " + event);
                        DistributedObjectClient.this.shutdown();
                    }
                }
            }
        });
        if (old != null) {
            old.close();
        }
    }
}

