/*
 * Decompiled with CFR 0.152.
 */
package com.tc.lang;

import com.tc.exception.ExceptionHelper;
import com.tc.lang.ThrowableHandler;
import com.tc.logging.CallbackOnExitHandler;
import com.tc.logging.CallbackOnExitState;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;

public class L1ThrowableHandler
implements ThrowableHandler {
    private final Callable<Void> l1ShutdownCallable;
    private final Logger logger;
    private final List<CallbackOnExitHandler> handlers = new LinkedList<CallbackOnExitHandler>();

    public L1ThrowableHandler(Logger logger, Callable<Void> l1ShutdownCallable) {
        this.l1ShutdownCallable = l1ShutdownCallable;
        this.logger = logger;
    }

    @Override
    public synchronized void handleThrowable(Thread thread, Throwable throwable) {
        this.logger.error("internal error on Thread: " + thread.toString(), throwable);
        try {
            CallbackOnExitState throwableState = new CallbackOnExitState(throwable);
            this.handlers.forEach(h -> h.callbackOnExit(throwableState));
            this.l1ShutdownCallable.call();
        }
        catch (Exception e) {
            this.logger.error("internal error shutting down client", (Throwable)e);
        }
    }

    @Override
    public void addHelper(ExceptionHelper helper) {
    }

    @Override
    public void handlePossibleOOME(Throwable t) {
    }

    @Override
    public synchronized void addCallbackOnExitDefaultHandler(CallbackOnExitHandler callbackOnExitHandler) {
        this.handlers.add(callbackOnExitHandler);
    }

    @Override
    public void addCallbackOnExitExceptionHandler(Class<?> c, CallbackOnExitHandler callbackOnExitHandler) {
    }
}

