/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.connection;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Properties;
import org.terracotta.connection.Connection;
import org.terracotta.connection.ConnectionException;
import org.terracotta.connection.ConnectionFactory;
import org.terracotta.connection.Diagnostics;
import org.terracotta.connection.DiagnosticsConfig;
import org.terracotta.connection.entity.EntityRef;
import org.terracotta.exception.EntityNotFoundException;
import org.terracotta.exception.EntityNotProvidedException;
import org.terracotta.exception.EntityVersionMismatchException;

public class DiagnosticsFactory {
    public static String REQUEST_TIMEOUT = "request.timeout";
    public static String REQUEST_TIMEOUT_MESSAGE = "request.timeoutMessage";

    public static Diagnostics connect(InetSocketAddress server, Properties props) throws ConnectionException {
        if (props == null) {
            props = new Properties();
        }
        props.setProperty("connection.type", "diagnostic");
        props.setProperty("connection.timeout", "-1");
        Connection connection = ConnectionFactory.connect(Collections.singleton(server), props);
        try {
            EntityRef d = connection.getEntityRef(Diagnostics.class, 1L, "root");
            Diagnostics handle = d.fetchEntity(new DiagnosticsConfig(props, () -> {
                try {
                    connection.close();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }));
            return handle;
        }
        catch (EntityNotFoundException | EntityNotProvidedException | EntityVersionMismatchException e) {
            try {
                connection.close();
            }
            catch (IOException c) {
                throw new RuntimeException(c);
            }
            throw new ConnectionException(e);
        }
    }
}

