/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.file.Path;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ConfigFormat {
    JSON(false, "json", new String[0]),
    PROPERTIES(true, "properties", new String[0]),
    CONFIG(true, "cfg", "conf", "config"),
    UNKNOWN(false, null, new String[0]);

    private final boolean exposed;
    private final String primaryExtension;
    private final String[] supportedExtensions;

    private ConfigFormat(boolean exposed, String primaryExtension, String ... supportedExtensions) {
        this.primaryExtension = primaryExtension;
        this.supportedExtensions = supportedExtensions;
        this.exposed = exposed && primaryExtension != null;
    }

    public String toString() {
        return this.primaryExtension == null ? "<unknown>" : this.primaryExtension;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public static ConfigFormat from(Path file) {
        String name = file == null || file.getFileName() == null ? "" : file.getFileName().toString().toLowerCase();
        for (ConfigFormat format : ConfigFormat.values()) {
            if (format.primaryExtension == null || !Stream.concat(Stream.of(format.primaryExtension), Stream.of(format.supportedExtensions)).anyMatch(ext -> name.endsWith("." + ext))) continue;
            return format;
        }
        return UNKNOWN;
    }

    public static Collection<String> supported() {
        return Stream.of(ConfigFormat.values()).filter(configFormat -> configFormat.exposed).map(configFormat -> configFormat.primaryExtension).sorted().collect(Collectors.toList());
    }
}

